/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.text.MessageFormat;
import org.eclipse.rwt.internal.theme.QxType;

public class QxBoolean
implements QxType {
    public static final QxBoolean TRUE = new QxBoolean(true);
    public static final QxBoolean FALSE = new QxBoolean(false);
    private static final String[] VALID_TRUE_STRINGS = new String[]{"true", "yes", "on"};
    private static final String[] VALID_FALSE_STRINGS = new String[]{"false", "no", "off"};
    public final boolean value;

    private QxBoolean(boolean value) {
        this.value = value;
    }

    public static QxBoolean valueOf(String input) {
        return QxBoolean.evalInput(input) ? TRUE : FALSE;
    }

    public String toDefaultString() {
        return this.value ? VALID_TRUE_STRINGS[0] : VALID_FALSE_STRINGS[0];
    }

    public String toString() {
        return "QxBoolean{ " + String.valueOf(this.value) + " }";
    }

    private static boolean evalInput(String input) {
        boolean result = false;
        if (input == null) {
            throw new NullPointerException("null argument");
        }
        boolean found = false;
        int i = 0;
        while (i < VALID_TRUE_STRINGS.length && !found) {
            if (VALID_TRUE_STRINGS[i].equals(input)) {
                result = true;
                found = true;
            }
            ++i;
        }
        i = 0;
        while (i < VALID_FALSE_STRINGS.length && !found) {
            if (VALID_FALSE_STRINGS[i].equals(input)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            String mesg = "Illegal boolean value: ''{0}''";
            Object[] arguments = new Object[]{input};
            String message = MessageFormat.format(mesg, arguments);
            throw new IllegalArgumentException(message);
        }
        return result;
    }
}

