/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.rwt.internal.theme.IThemeCssAttribute;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.IThemeCssProperty;

public class ThemeCssElement
implements IThemeCssElement {
    private final String name;
    private String description;
    private Collection properties;
    private Collection styles;
    private Collection states;

    public ThemeCssElement(String name) {
        this.name = name;
        this.properties = new ArrayList();
        this.styles = new ArrayList();
        this.states = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public IThemeCssProperty[] getProperties() {
        IThemeCssProperty[] result = new IThemeCssProperty[this.properties.size()];
        this.properties.toArray(result);
        return result;
    }

    public IThemeCssAttribute[] getStyles() {
        IThemeCssAttribute[] result = new IThemeCssAttribute[this.styles.size()];
        this.styles.toArray(result);
        return result;
    }

    public IThemeCssAttribute[] getStates() {
        IThemeCssAttribute[] result = new IThemeCssAttribute[this.states.size()];
        this.states.toArray(result);
        return result;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addProperty(IThemeCssProperty property) {
        this.properties.add(property);
    }

    public void addStyle(IThemeCssAttribute style) {
        this.styles.add(style);
    }

    public void addState(IThemeCssAttribute state) {
        this.states.add(state);
    }
}

