/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.util;

import java.io.IOException;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.util.EntitiesUtil;

public final class HTMLUtil {
    public static String hiddenInput(String name, String value) {
        StringBuffer buffer = new StringBuffer();
        HTMLUtil.hiddenInput(buffer, name, value);
        return buffer.toString();
    }

    public static void hiddenInput(StringBuffer buffer, String name, String value) {
        String id = name == null ? null : EntitiesUtil.encodeHTMLEntities(name);
        String encodedValue = value == null ? null : EntitiesUtil.encodeHTMLEntities(value);
        buffer.append("<input type=\"hidden\" id=\"");
        buffer.append(id);
        buffer.append("\" name=\"");
        buffer.append(id);
        buffer.append("\" value=\"");
        buffer.append(encodedValue);
        buffer.append("\" />");
    }

    public static void hiddenInput(HtmlResponseWriter writer, String name, String value) throws IOException {
        writer.startElement("input", null);
        writer.writeAttribute("type", "hidden", null);
        writer.writeAttribute("id", name, null);
        writer.writeAttribute("name", name, null);
        writer.writeAttribute("value", value, null);
        writer.endElement("input");
    }

    public static void attribute(StringBuffer buffer, String name, String value) {
        buffer.append(" ");
        buffer.append(name);
        buffer.append("=\"");
        String encodedValue = value == null ? value : EntitiesUtil.encodeHTMLEntities(value);
        buffer.append(encodedValue);
        buffer.append("\"");
    }

    public static String attribute(String name, String value) {
        StringBuffer buffer = new StringBuffer();
        HTMLUtil.attribute(buffer, name, value);
        return buffer.toString();
    }

    public static String createXmlProcessingInstruction() {
        StringBuffer result = new StringBuffer();
        result.append("<?xml");
        HTMLUtil.attribute(result, "version", "1.0");
        HTMLUtil.attribute(result, "encoding", "UTF-8");
        result.append(" ?>");
        return result.toString();
    }

    public static String createJavaScriptInline(String javaScriptCode) {
        StringBuffer result = new StringBuffer();
        if (javaScriptCode != null && !"".equals(javaScriptCode)) {
            result.append("<script");
            HTMLUtil.attribute(result, "type", "text/javascript");
            result.append(">");
            result.append(EntitiesUtil.encodeHTMLEntities(javaScriptCode));
            result.append("</script>");
        }
        return result.toString();
    }
}

