/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Item;

public class ExpandItem
extends Item {
    static final int LEFT_MARGIN = 4;
    static final int RIGHT_MARGIN = 24;
    static final int INTERNAL_SPACING = 4;
    static final int BORDER = 1;
    static final int CHEVRON_SIZE = 24;
    ExpandBar parent;
    Control control;
    boolean expanded;
    int x;
    int y;
    int width;
    int height;
    int imageHeight;
    int imageWidth;

    public ExpandItem(ExpandBar parent, int style) {
        this(parent, style, ExpandItem.checkNull(parent).getItemCount());
    }

    public ExpandItem(ExpandBar parent, int style, int index) {
        super(parent, style);
        this.parent = parent;
        parent.createItem(this, style, index);
    }

    static ExpandBar checkNull(ExpandBar control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    public void dispose() {
        if (!this.isDisposed()) {
            this.parent.destroyItem(this);
            if (this.control != null) {
                this.control.dispose();
                this.control = null;
            }
            super.dispose();
        }
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public boolean getExpanded() {
        this.checkWidget();
        return this.expanded;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return Math.max(this.parent.getBandHeight(), this.imageHeight);
    }

    public int getHeight() {
        this.checkWidget();
        return this.height;
    }

    public ExpandBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    int getPreferredWidth() {
        int result = 0;
        if (!this.isDisposed()) {
            Image image = this.getImage();
            int w = image == null ? 0 : image.getBounds().width;
            String text = this.getText();
            if (text != null) {
                if (w > 0) {
                    w += 4;
                }
                Font parentFont = this.getParent().getFont();
                w += TextSizeDetermination.stringExtent((Font)parentFont, (String)text).x;
            }
            result = w + 4 + 24;
        }
        return result;
    }

    Rectangle getBounds() {
        Rectangle bounds = new Rectangle(0, 0, 0, 0);
        bounds = this.expanded ? new Rectangle(this.x, this.y, this.width, this.getHeaderHeight() + this.height) : new Rectangle(this.x, this.y, this.width, this.getHeaderHeight());
        return bounds;
    }

    void setBounds(int x, int y, int width, int height, boolean move, boolean size) {
        int headerHeight = this.getHeaderHeight();
        int aX = x;
        int aY = y;
        int aWidth = width;
        int aHeight = height;
        if (move) {
            if (this.imageHeight > headerHeight) {
                aY += this.imageHeight - headerHeight;
            }
            this.x = aX;
            this.y = aY;
        }
        if (size) {
            this.width = aWidth;
            this.height = aHeight;
        }
        if (this.control != null && !this.control.isDisposed()) {
            if (!this.parent.isAppThemed()) {
                ++aX;
                aWidth = Math.max(0, aWidth - 2);
                aHeight = Math.max(0, aHeight - 1);
            }
            if (move && size) {
                this.control.setBounds(aX, aY + headerHeight, aWidth, aHeight);
            }
            if (move && !size) {
                this.control.setLocation(aX, aY + headerHeight);
            }
            if (!move && size) {
                this.control.setSize(aWidth, aHeight);
            }
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        this.control = control;
        if (control != null) {
            int headerHeight = this.getHeaderHeight();
            control.setVisible(this.expanded);
            if (!this.parent.isAppThemed()) {
                int width = Math.max(0, this.width - 2);
                int height = Math.max(0, this.height - 1);
                control.setBounds(this.x + 1, this.y + headerHeight, width, height);
            } else {
                control.setBounds(this.x, this.y + headerHeight, this.width, this.height);
            }
        }
    }

    public void setExpanded(boolean expanded) {
        this.checkWidget();
        this.expanded = expanded;
        this.parent.showItem(this);
    }

    public void setHeight(int height) {
        this.checkWidget();
        if (height >= 0) {
            this.setBounds(0, 0, this.width, height, false, true);
            if (this.expanded) {
                this.parent.layoutItems(this.parent.indexOf(this) + 1, true);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != this.getImage()) {
            super.setImage(image);
            int parentWidth = this.parent.computeSize((int)-1, (int)-1, (boolean)false).x;
            int availableWidth = parentWidth - 2 * this.parent.spacing - this.parent.v_scroll;
            this.width = Math.max(this.getPreferredWidth(), availableWidth);
            this.setBounds(0, 0, this.width, this.height, false, true);
        }
        int oldImageHeight = this.imageHeight;
        if (image != null) {
            Rectangle bounds = image.getBounds();
            this.imageHeight = bounds.height;
            this.imageWidth = bounds.width;
        } else {
            this.imageWidth = 0;
            this.imageHeight = 0;
        }
        if (oldImageHeight != this.imageHeight) {
            this.parent.layoutItems(this.parent.indexOf(this), true);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        if (!string.equals(this.getText())) {
            super.setText(string);
            int parentWidth = this.parent.computeSize((int)-1, (int)-1, (boolean)false).x;
            int availableWidth = parentWidth - 2 * this.parent.spacing - this.parent.v_scroll;
            this.width = Math.max(this.getPreferredWidth(), availableWidth);
            this.setBounds(0, 0, this.width, this.height, false, true);
        }
    }
}

