/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.widgets.IListAdapter;
import org.eclipse.swt.internal.widgets.ListModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Scrollable;

public class List
extends Scrollable {
    private static final int VERTICAL_ITEM_MARGIN = 3;
    private static final int HORIZONTAL_ITEM_MARGIN = 5;
    private static final int SCROLL_SIZE = 16;
    private final ListModel model;
    private int focusIndex = -1;
    private IListAdapter listAdapter;
    static /* synthetic */ Class class$0;

    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
        this.model = new ListModel((style & 4) != 0);
    }

    public Object getAdapter(Class adapter) {
        Object result;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IListAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            if (this.listAdapter == null) {
                this.listAdapter = new IListAdapter(){

                    public void setFocusIndex(int focusIndex) {
                        List.this.setFocusIndex(focusIndex);
                    }
                };
            }
            result = this.listAdapter;
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] selectionIndices = this.model.getSelectionIndices();
        String[] result = new String[selectionIndices.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.model.getItem(selectionIndices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.model.getSelectionIndex();
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        return this.model.getSelectionIndices();
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.model.getSelectionCount();
    }

    public void setSelection(int selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(int[] selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.model.setSelection(start, end);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void setSelection(String[] selection) {
        this.checkWidget();
        this.model.setSelection(selection);
        this.updateFocusIndexAfterSelectionChange();
    }

    public void select(int index) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if (index >= 0 && index < this.model.getItemCount()) {
                this.model.setSelection(index);
            }
        } else {
            this.model.addSelection(index);
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) != 0 && ((this.style & 4) == 0 || length <= 1)) {
            int i = 0;
            while (i < length) {
                int index = indices[i];
                this.model.addSelection(index);
                ++i;
            }
        }
    }

    public void select(int start, int end) {
        int count;
        this.checkWidget();
        if (end >= 0 && start <= end && ((this.style & 4) == 0 || start == end) && (count = this.model.getItemCount()) != 0 && start < count) {
            int startIndex = Math.max(0, start);
            int endIndex = Math.min(end, count - 1);
            if ((this.style & 4) != 0) {
                this.model.setSelection(startIndex);
            } else {
                int i = startIndex;
                while (i <= endIndex) {
                    this.model.addSelection(i);
                    ++i;
                }
            }
        }
    }

    public void selectAll() {
        this.checkWidget();
        this.model.selectAll();
        this.updateFocusIndexAfterSelectionChange();
    }

    public void deselectAll() {
        this.checkWidget();
        this.model.deselectAll();
        this.updateFocusIndexAfterSelectionChange();
    }

    public boolean isSelected(int index) {
        boolean result;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            result = index == this.getSelectionIndex();
        } else {
            int[] selectionIndices = this.getSelectionIndices();
            result = false;
            int i = 0;
            while (!result && i < selectionIndices.length) {
                if (index == selectionIndices[i]) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    public int getFocusIndex() {
        this.checkWidget();
        return this.focusIndex;
    }

    public void add(String string) {
        this.checkWidget();
        this.model.add(string);
        this.updateFocusIndexAfterItemChange();
    }

    public void add(String string, int index) {
        this.checkWidget();
        this.model.add(string, index);
        this.updateFocusIndexAfterItemChange();
    }

    public void remove(int index) {
        this.checkWidget();
        this.model.remove(index);
        this.updateFocusIndexAfterItemChange();
    }

    public void remove(int start, int end) {
        this.checkWidget();
        this.model.remove(start, end);
        this.updateFocusIndexAfterItemChange();
    }

    public void remove(int[] indices) {
        this.checkWidget();
        this.model.remove(indices);
        this.updateFocusIndexAfterItemChange();
    }

    public void remove(String string) {
        this.checkWidget();
        this.model.remove(string);
        this.updateFocusIndexAfterItemChange();
    }

    public void removeAll() {
        this.checkWidget();
        this.model.removeAll();
        this.updateFocusIndexAfterItemChange();
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        this.model.setItem(index, string);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.model.setItems(items);
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.model.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.model.getItemCount();
    }

    public String[] getItems() {
        this.checkWidget();
        return this.model.getItems();
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        int result = -1;
        int count = this.getItemCount();
        int i = start;
        while (result == -1 && i < count) {
            if (string.equals(this.getItem(i))) {
                result = i;
            }
            ++i;
        }
        return result;
    }

    public int getItemHeight() {
        this.checkWidget();
        int margin = 6;
        return TextSizeDetermination.getCharHeight(this.getFont()) + margin;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.addListener(this, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionEvent.removeListener(this, listener);
    }

    boolean isTabGroup() {
        return true;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        String[] items = this.getItems();
        int itemWidth = 0;
        int i = 0;
        while (i < items.length) {
            itemWidth = this.getItemWidth(items[i]);
            width = Math.max(width, itemWidth);
            ++i;
        }
        height = this.getItemHeight() * items.length;
        if (width == 0) {
            width = 64;
        }
        if (height == 0) {
            height = 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        width += border * 2;
        height += border * 2;
        if ((this.style & 0x200) != 0) {
            width += 16;
        }
        if ((this.style & 0x100) != 0) {
            height += 16;
        }
        return new Point(width, height);
    }

    private void setFocusIndex(int focusIndex) {
        int count = this.model.getItemCount();
        if (focusIndex == -1 || focusIndex >= 0 && focusIndex < count) {
            this.focusIndex = focusIndex;
        }
    }

    private void updateFocusIndexAfterSelectionChange() {
        this.focusIndex = -1;
        if (this.model.getItemCount() > 0) {
            this.focusIndex = this.model.getSelectionIndex() == -1 ? 0 : this.model.getSelectionIndices()[0];
        }
    }

    private void updateFocusIndexAfterItemChange() {
        if (this.model.getItemCount() == 0) {
            this.focusIndex = -1;
        } else if (this.model.getSelectionIndex() == -1) {
            this.focusIndex = this.model.getItemCount() - 1;
        }
    }

    private static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    private int getItemWidth(String item) {
        int margin = 10;
        return TextSizeDetermination.stringExtent((Font)this.getFont(), (String)item).x + margin;
    }
}

