/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.internal.widgets.formtextkit;

import java.io.IOException;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.HyperlinkSettings;
import org.eclipse.ui.forms.internal.widgets.IAggregateHyperlinkSegmentAdapter;
import org.eclipse.ui.forms.internal.widgets.IBulletParagraphAdapter;
import org.eclipse.ui.forms.internal.widgets.IFormTextAdapter;
import org.eclipse.ui.forms.internal.widgets.ITextSegmentAdapter;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.internal.forms.widgets.AggregateHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.BulletParagraph;
import org.eclipse.ui.internal.forms.widgets.ControlSegment;
import org.eclipse.ui.internal.forms.widgets.ImageHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.ImageSegment;
import org.eclipse.ui.internal.forms.widgets.Paragraph;
import org.eclipse.ui.internal.forms.widgets.ParagraphSegment;
import org.eclipse.ui.internal.forms.widgets.TextHyperlinkSegment;
import org.eclipse.ui.internal.forms.widgets.TextSegment;

public class FormTextLCA
extends AbstractWidgetLCA {
    private static final Pattern FONT_NAME_FILTER_PATTERN = Pattern.compile("\"|\\\\");
    private static final String NBSP = "&nbsp;";
    private static final String PREFIX = "resource/widget/rap/formtext/";
    private static final String BULLET_CIRCLE_GIF = "resource/widget/rap/formtext/bullet_circle.gif";
    static final String PROP_PARAGRAPHS = "paragraphs";
    static final String PROP_HYPERLINK_SETTINGS = "hyperlinkSettings";
    private static final Paragraph[] DEFAULT_PARAGRAPHS = new Paragraph[0];
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public void preserveValues(Widget widget) {
        FormText formText = (FormText)widget;
        ControlLCAUtil.preserveValues((Control)formText);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)formText);
        adapter.preserve(PROP_PARAGRAPHS, (Object)FormTextLCA.getParagraphs(formText));
        adapter.preserve(PROP_HYPERLINK_SETTINGS, (Object)formText.getHyperlinkSettings());
    }

    public void renderInitialization(Widget widget) throws IOException {
        FormText formText = (FormText)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        writer.newWidget("org.eclipse.ui.forms.widgets.FormText");
        ControlLCAUtil.writeStyleFlags((Control)formText);
    }

    public void readData(Widget widget) {
        FormText formText = (FormText)widget;
        ControlLCAUtil.processSelection((Widget)formText, null, (boolean)false);
        ControlLCAUtil.processMouseEvents((Control)formText);
        ControlLCAUtil.processKeyEvents((Control)formText);
    }

    public void renderChanges(Widget widget) throws IOException {
        FormText formText = (FormText)widget;
        ControlLCAUtil.writeChanges((Control)formText);
        FormTextLCA.writeHyperlinkSettings(formText);
        FormTextLCA.writeParagraphs(formText);
        WidgetLCAUtil.writeCustomVariant((Widget)formText);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)widget);
        writer.dispose();
    }

    public void createResetHandlerCalls(String typePoolId) throws IOException {
    }

    public String getTypePoolId(Widget widget) {
        return null;
    }

    private static void writeParagraphs(FormText formText) throws IOException {
        Paragraph[] defValue;
        String prop = PROP_PARAGRAPHS;
        Paragraph[] paragraphs = FormTextLCA.getParagraphs(formText);
        if (WidgetLCAUtil.hasChanged((Widget)formText, (String)prop, (Object)paragraphs, (Object)(defValue = DEFAULT_PARAGRAPHS)) || FormTextLCA.hasLayoutChanged(formText)) {
            FormTextLCA.clearContent(formText);
            int i = 0;
            while (i < paragraphs.length) {
                Paragraph paragraph = paragraphs[i];
                if (paragraph instanceof BulletParagraph) {
                    BulletParagraph bullet = (BulletParagraph)paragraph;
                    FormTextLCA.writeBullet(formText, bullet);
                }
                ParagraphSegment[] segments = paragraph.getSegments();
                FormTextLCA.writeSegments(formText, segments);
                ++i;
            }
            FormTextLCA.updateHyperlinks(formText);
        }
    }

    private static void writeBullet(FormText formText, BulletParagraph bullet) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        int style = bullet.getBulletStyle();
        Image image = FormTextLCA.getBulletImage(formText, bullet);
        String imageName = ResourceFactory.getImagePath((Image)image);
        String text = bullet.getBulletText();
        Rectangle bounds = FormTextLCA.getBulletBounds(bullet);
        Object[] args = new Object[]{new Integer(style), imageName, text, new Integer(bounds.x), new Integer(bounds.y), new Integer(bounds.width), new Integer(bounds.height)};
        writer.call("createBullet", args);
    }

    private static void writeSegments(FormText formText, ParagraphSegment[] segments) throws IOException {
        int i = 0;
        while (i < segments.length) {
            ParagraphSegment segment = segments[i];
            if (segment instanceof TextHyperlinkSegment) {
                FormTextLCA.writeTextHyperlinkSegment(formText, (TextHyperlinkSegment)segment);
            } else if (segment instanceof TextSegment) {
                FormTextLCA.writeTextSegment(formText, (TextSegment)segment);
            } else if (segment instanceof ImageHyperlinkSegment) {
                FormTextLCA.writeImageHyperlinkSegment(formText, (ImageHyperlinkSegment)segment);
            } else if (segment instanceof ImageSegment) {
                FormTextLCA.writeImageSegment(formText, (ImageSegment)segment);
            } else if (segment instanceof ControlSegment) {
                FormTextLCA.writeControlSegment(formText, (ControlSegment)segment);
            } else if (segment instanceof AggregateHyperlinkSegment) {
                FormTextLCA.writeAggregateHyperlinkSegment(formText, (AggregateHyperlinkSegment)segment);
            }
            ++i;
        }
    }

    private static void writeTextSegment(FormText formText, TextSegment segment) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        String[] textFragments = FormTextLCA.getTextFragments(segment);
        Rectangle[] textFragmentsBounds = FormTextLCA.getTextFragmentsBounds(segment);
        String fontId = FormTextLCA.getFontId(segment);
        Font font = null;
        if (fontId != null) {
            font = (Font)FormTextLCA.getResourceTable(formText).get(fontId);
        }
        String colorId = segment.getColorId();
        Color color = null;
        if (colorId != null) {
            color = (Color)FormTextLCA.getResourceTable(formText).get(colorId);
        }
        int i = 0;
        while (i < textFragments.length) {
            Object[] args = new Object[]{textFragments[i].replaceAll(" ", NBSP), new Integer(textFragmentsBounds[i].x), new Integer(textFragmentsBounds[i].y), new Integer(textFragmentsBounds[i].width), new Integer(textFragmentsBounds[i].height), FormTextLCA.getFontName(font), FormTextLCA.getFontSize(font), FormTextLCA.getFontStyle(font, 1), FormTextLCA.getFontStyle(font, 2), FormTextLCA.colorToHtmlString(color)};
            writer.call("createTextFragment", args);
            ++i;
        }
    }

    private static void writeTextHyperlinkSegment(FormText formText, TextHyperlinkSegment segment) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        String[] textFragments = FormTextLCA.getTextFragments(segment);
        String tooltipText = segment.getTooltipText();
        Rectangle[] textFragmentsBounds = FormTextLCA.getTextFragmentsBounds(segment);
        String fontId = FormTextLCA.getFontId(segment);
        Font font = null;
        if (fontId != null) {
            font = (Font)FormTextLCA.getResourceTable(formText).get(fontId);
        }
        int i = 0;
        while (i < textFragments.length) {
            Object[] args = new Object[]{textFragments[i].replaceAll(" ", NBSP), tooltipText, new Integer(textFragmentsBounds[i].x), new Integer(textFragmentsBounds[i].y), new Integer(textFragmentsBounds[i].width), new Integer(textFragmentsBounds[i].height), FormTextLCA.getFontName(font), FormTextLCA.getFontSize(font), FormTextLCA.getFontStyle(font, 1), FormTextLCA.getFontStyle(font, 2)};
            writer.call("createTextHyperlinkSegment", args);
            ++i;
        }
    }

    private static void writeImageSegment(FormText formText, ImageSegment segment) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        Rectangle bounds = segment.getBounds();
        Image image = segment.getImage(FormTextLCA.getResourceTable(formText));
        String imageName = ResourceFactory.getImagePath((Image)image);
        Object[] args = new Object[]{imageName, new Integer(bounds.x), new Integer(bounds.y), new Integer(bounds.width), new Integer(bounds.height)};
        writer.call("createImageSegment", args);
    }

    private static void writeImageHyperlinkSegment(FormText formText, ImageHyperlinkSegment segment) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        String tooltipText = segment.getTooltipText();
        Rectangle bounds = segment.getBounds();
        Image image = segment.getImage(FormTextLCA.getResourceTable(formText));
        String imageName = ResourceFactory.getImagePath((Image)image);
        Object[] args = new Object[]{imageName, tooltipText, new Integer(bounds.x), new Integer(bounds.y), new Integer(bounds.width), new Integer(bounds.height)};
        writer.call("createImageHyperlinkSegment", args);
    }

    private static void writeControlSegment(FormText formText, ControlSegment segment) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        Control control = segment.getControl(FormTextLCA.getResourceTable(formText));
        Object[] args = new Object[]{WidgetUtil.getId((Widget)control)};
        writer.call("createControlSegment", args);
    }

    private static void writeAggregateHyperlinkSegment(FormText formText, AggregateHyperlinkSegment segment) throws IOException {
        Object[] segments = FormTextLCA.getHyperlinkSegments(segment);
        int i = 0;
        while (i < segments.length) {
            Object hyperlinkSegment = segments[i];
            if (hyperlinkSegment instanceof TextHyperlinkSegment) {
                FormTextLCA.writeTextHyperlinkSegment(formText, (TextHyperlinkSegment)hyperlinkSegment);
            } else if (hyperlinkSegment instanceof ImageHyperlinkSegment) {
                FormTextLCA.writeImageHyperlinkSegment(formText, (ImageHyperlinkSegment)hyperlinkSegment);
            }
            ++i;
        }
    }

    private static void writeHyperlinkSettings(FormText formText) throws IOException {
        String prop = PROP_HYPERLINK_SETTINGS;
        HyperlinkSettings newValue = formText.getHyperlinkSettings();
        if (WidgetLCAUtil.hasChanged((Widget)formText, (String)prop, (Object)newValue)) {
            int underlineMode = newValue.getHyperlinkUnderlineMode();
            Color foreground = newValue.getForeground();
            Color activeForeground = newValue.getActiveForeground();
            Object[] args = new Object[]{new Integer(underlineMode), FormTextLCA.colorToHtmlString(foreground), FormTextLCA.colorToHtmlString(activeForeground)};
            JSWriter writer = JSWriter.getWriterFor((Widget)formText);
            writer.call("setHyperlinkSettings", args);
        }
    }

    private static void clearContent(FormText formText) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        writer.call("clearContent", new Object[0]);
    }

    private static void updateHyperlinks(FormText formText) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)formText);
        writer.call("updateHyperlinks", new Object[0]);
    }

    private static IFormTextAdapter getAdapter(FormText formText) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.forms.internal.widgets.IFormTextAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = formText.getAdapter(clazz);
        return (IFormTextAdapter)adapter;
    }

    private static ITextSegmentAdapter getAdapter(TextSegment segment) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.forms.internal.widgets.ITextSegmentAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = segment.getAdapter(clazz);
        return (ITextSegmentAdapter)adapter;
    }

    private static IBulletParagraphAdapter getAdapter(BulletParagraph bullet) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.ui.forms.internal.widgets.IBulletParagraphAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = bullet.getAdapter(clazz);
        return (IBulletParagraphAdapter)adapter;
    }

    private static IAggregateHyperlinkSegmentAdapter getAdapter(AggregateHyperlinkSegment segment) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.ui.forms.internal.widgets.IAggregateHyperlinkSegmentAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = segment.getAdapter(clazz);
        return (IAggregateHyperlinkSegmentAdapter)adapter;
    }

    private static Image getBulletImage(FormText formText, BulletParagraph bullet) {
        Image img;
        String text;
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.ui.forms.internal.widgets.formtextkit.FormTextLCA");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ClassLoader classLoader = clazz.getClassLoader();
        Image bulletImage = Graphics.getImage((String)BULLET_CIRCLE_GIF, (ClassLoader)classLoader);
        if (bullet.getBulletStyle() == 3 && (text = bullet.getBulletText()) != null && (img = (Image)FormTextLCA.getResourceTable(formText).get(text)) != null) {
            bulletImage = img;
        }
        return bulletImage;
    }

    private static Rectangle getBulletBounds(BulletParagraph bullet) {
        IBulletParagraphAdapter bulletParagraphAdapter = FormTextLCA.getAdapter(bullet);
        return bulletParagraphAdapter.getBulletBounds();
    }

    private static Paragraph[] getParagraphs(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.getParagraphs();
    }

    private static Hashtable getResourceTable(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.getResourceTable();
    }

    private static boolean hasLayoutChanged(FormText formText) {
        IFormTextAdapter adapter = FormTextLCA.getAdapter(formText);
        return adapter.hasLayoutChanged();
    }

    private static String[] getTextFragments(TextSegment segment) {
        ITextSegmentAdapter textSegmentAdapter = FormTextLCA.getAdapter(segment);
        return textSegmentAdapter.getTextFragments();
    }

    private static Rectangle[] getTextFragmentsBounds(TextSegment segment) {
        ITextSegmentAdapter textSegmentAdapter = FormTextLCA.getAdapter(segment);
        return textSegmentAdapter.getTextFragmentsBounds();
    }

    private static String getFontId(TextSegment segment) {
        ITextSegmentAdapter textSegmentAdapter = FormTextLCA.getAdapter(segment);
        return textSegmentAdapter.getFontId();
    }

    private static Object[] getHyperlinkSegments(AggregateHyperlinkSegment segment) {
        IAggregateHyperlinkSegmentAdapter hyperlinkSegmentAdapter = FormTextLCA.getAdapter(segment);
        return hyperlinkSegmentAdapter.getHyperlinkSegments();
    }

    private static String colorToHtmlString(Color color) {
        String result = null;
        if (color != null) {
            int red = color.getRed();
            int green = color.getGreen();
            int blue = color.getBlue();
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            sb.append(FormTextLCA.getHexStr(red));
            sb.append(FormTextLCA.getHexStr(green));
            sb.append(FormTextLCA.getHexStr(blue));
            result = sb.toString();
        }
        return result;
    }

    private static String getHexStr(int value) {
        String hex = Integer.toHexString(value);
        return hex.length() == 1 ? "0" + hex : hex;
    }

    private static String[] getFontName(Font font) {
        String[] result = null;
        if (font != null) {
            FontData fontData = font.getFontData()[0];
            String fontName = fontData.getName();
            result = fontName.split(",");
            int i = 0;
            while (i < result.length) {
                result[i] = result[i].trim();
                Matcher matcher = FONT_NAME_FILTER_PATTERN.matcher(result[i]);
                result[i] = matcher.replaceAll("");
                ++i;
            }
        }
        return result;
    }

    private static Integer getFontSize(Font font) {
        Integer result = null;
        if (font != null) {
            FontData fontData = font.getFontData()[0];
            result = new Integer(fontData.getHeight());
        }
        return result;
    }

    private static Boolean getFontStyle(Font font, int style) {
        Boolean result = null;
        if (font != null) {
            FontData fontData = font.getFontData()[0];
            result = (fontData.getStyle() & style) != 0;
        }
        return result;
    }
}

