/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.internal.forms.widgets.FormsResources;

public abstract class AbstractHyperlink
extends Canvas {
    private boolean hasFocus;
    boolean paintFocus = true;
    private ListenerList listeners;
    protected int marginWidth = 1;
    protected int marginHeight = 1;

    public AbstractHyperlink(Composite parent, int style) {
        super(parent, style);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 15: {
                        AbstractHyperlink.this.hasFocus = true;
                        AbstractHyperlink.this.handleEnter(e);
                        break;
                    }
                    case 16: {
                        AbstractHyperlink.this.hasFocus = false;
                        AbstractHyperlink.this.handleExit(e);
                        break;
                    }
                    case 14: {
                        AbstractHyperlink.this.handleActivate(e);
                    }
                }
            }
        };
        this.addListener(15, listener);
        this.addListener(16, listener);
        this.addListener(14, listener);
        this.setCursor(FormsResources.getHandCursor());
    }

    public void addHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        this.listeners.add((Object)listener);
    }

    public void removeHyperlinkListener(IHyperlinkListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove((Object)listener);
    }

    public boolean getSelection() {
        return this.hasFocus;
    }

    protected void handleEnter(Event e) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        Object[] listenerList = this.listeners.getListeners();
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)listenerList[i];
            listener.linkEntered(he);
            ++i;
        }
    }

    protected void handleExit(Event e) {
        this.redraw();
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        Object[] listenerList = this.listeners.getListeners();
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)listenerList[i];
            listener.linkExited(he);
            ++i;
        }
    }

    protected void handleActivate(Event e) {
        if (this.listeners == null) {
            return;
        }
        int size = this.listeners.size();
        this.setCursor(FormsResources.getBusyCursor());
        HyperlinkEvent he = new HyperlinkEvent((Widget)this, this.getHref(), this.getText(), e.stateMask);
        Object[] listenerList = this.listeners.getListeners();
        int i = 0;
        while (i < size) {
            IHyperlinkListener listener = (IHyperlinkListener)listenerList[i];
            listener.linkActivated(he);
            ++i;
        }
        if (!this.isDisposed()) {
            this.setCursor(FormsResources.getHandCursor());
        }
    }

    public void setHref(Object href) {
        this.setData("href", href);
    }

    public Object getHref() {
        return this.getData("href");
    }

    public String getText() {
        return this.getToolTipText();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }
}

