/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.forms.widgets;

import java.util.HashMap;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public class FormFonts {
    private HashMap fonts;
    private HashMap ids;
    static /* synthetic */ Class class$0;

    public static FormFonts getInstance() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.forms.widgets.FormFonts");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (FormFonts)SessionSingletonBase.getInstance((Class)clazz);
    }

    private FormFonts() {
    }

    public Font getBoldFont(Display display, Font font) {
        this.checkHashMaps();
        FontIdentifier fid = new FontIdentifier(display, font);
        FontReference result = (FontReference)this.fonts.get(fid);
        if (result != null) {
            result.incCount();
            return result.getFont();
        }
        Font boldFont = this.createBoldFont(display, font);
        this.fonts.put(fid, new FontReference(boldFont));
        this.ids.put(boldFont, fid);
        return boldFont;
    }

    public boolean markFinished(Font boldFont) {
        FontReference ref;
        this.checkHashMaps();
        FontIdentifier id = (FontIdentifier)this.ids.get(boldFont);
        if (id != null && (ref = (FontReference)this.fonts.get(id)) != null) {
            if (ref.decCount()) {
                this.fonts.remove(id);
                this.ids.remove(ref.getFont());
                this.validateHashMaps();
            }
            return true;
        }
        return false;
    }

    private Font createBoldFont(Display display, Font regularFont) {
        FontData fontData = regularFont.getFontData()[0];
        return Graphics.getFont((String)fontData.getName(), (int)fontData.getHeight(), (int)(fontData.getStyle() | 1));
    }

    private void checkHashMaps() {
        if (this.fonts == null) {
            this.fonts = new HashMap();
        }
        if (this.ids == null) {
            this.ids = new HashMap();
        }
    }

    private void validateHashMaps() {
        if (this.fonts.size() == 0) {
            this.fonts = null;
        }
        if (this.ids.size() == 0) {
            this.ids = null;
        }
    }

    private class FontIdentifier {
        private Display fDisplay;
        private Font fFont;

        FontIdentifier(Display display, Font font) {
            this.fDisplay = display;
            this.fFont = font;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FontIdentifier) {
                FontIdentifier id = (FontIdentifier)obj;
                return id.fDisplay.equals(this.fDisplay) && id.fFont.equals(this.fFont);
            }
            return false;
        }

        public int hashCode() {
            return this.fDisplay.hashCode() * 7 + this.fFont.hashCode();
        }
    }

    private class FontReference {
        private Font fFont;
        private int fCount;

        public FontReference(Font font) {
            this.fFont = font;
            this.fCount = 1;
        }

        public Font getFont() {
            return this.fFont;
        }

        public boolean decCount() {
            return --this.fCount == 0;
        }

        public void incCount() {
            ++this.fCount;
        }
    }
}

