/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.BaseNewWizardMenu;
import org.eclipse.ui.internal.ChangeToPerspectiveMenu;
import org.eclipse.ui.internal.ReopenEditorMenu;
import org.eclipse.ui.internal.ShowViewMenu;

public abstract class ContributionItemFactory {
    private final String contributionItemId;
    public static final ContributionItemFactory VIEWS_SHORTLIST = new ContributionItemFactory("viewsShortlist"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            return new ShowViewMenu(window, this.getId());
        }
    };
    public static final ContributionItemFactory REOPEN_EDITORS = new ContributionItemFactory("reopenEditors"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            return new ReopenEditorMenu(window, this.getId(), true);
        }
    };
    public static final ContributionItemFactory PERSPECTIVES_SHORTLIST = new ContributionItemFactory("perspectivesShortlist"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            return new ChangeToPerspectiveMenu(window, this.getId());
        }
    };
    public static final ContributionItemFactory NEW_WIZARD_SHORTLIST = new ContributionItemFactory("newWizardShortlist"){

        public IContributionItem create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            return new BaseNewWizardMenu(window, this.getId());
        }
    };

    protected ContributionItemFactory(String contributionItemId) {
        this.contributionItemId = contributionItemId;
    }

    public abstract IContributionItem create(IWorkbenchWindow var1);

    public String getId() {
        return this.contributionItemId;
    }
}

