/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.keys;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.keys.IBindingService;

public final class BindingService
implements IBindingService {
    private final BindingManager bindingManager;

    public BindingService(BindingManager bindingManager, ICommandService commandService, Workbench workbench) {
        if (bindingManager == null) {
            throw new NullPointerException("Cannot create a binding service with a null manager");
        }
        if (commandService == null) {
            throw new NullPointerException("Cannot create a binding service with a null command service");
        }
        this.bindingManager = bindingManager;
    }

    public final void addBinding(Binding binding) {
        this.bindingManager.addBinding(binding);
    }

    public final void dispose() {
    }

    public final TriggerSequence[] getActiveBindingsFor(ParameterizedCommand parameterizedCommand) {
        return this.bindingManager.getActiveBindingsFor(parameterizedCommand);
    }

    public final TriggerSequence[] getActiveBindingsFor(String commandId) {
        return this.bindingManager.getActiveBindingsFor(commandId);
    }

    public final Scheme getActiveScheme() {
        return this.bindingManager.getActiveScheme();
    }

    public final TriggerSequence getBestActiveBindingFor(String commandId) {
        return this.bindingManager.getBestActiveBindingFor(commandId);
    }

    public TriggerSequence getBestActiveBindingFor(ParameterizedCommand command) {
        return this.bindingManager.getBestActiveBindingFor(command);
    }

    public final String getBestActiveBindingFormattedFor(String commandId) {
        return this.bindingManager.getBestActiveBindingFormattedFor(commandId);
    }

    public final Binding[] getBindings() {
        return this.bindingManager.getBindings();
    }

    public final Scheme[] getDefinedSchemes() {
        return this.bindingManager.getDefinedSchemes();
    }

    public final String getLocale() {
        return this.bindingManager.getLocale();
    }

    public final Map getPartialMatches(TriggerSequence trigger) {
        return this.bindingManager.getPartialMatches(trigger);
    }

    public final Binding getPerfectMatch(TriggerSequence trigger) {
        return this.bindingManager.getPerfectMatch(trigger);
    }

    public final String getPlatform() {
        return this.bindingManager.getPlatform();
    }

    public final Scheme getScheme(String schemeId) {
        return this.bindingManager.getScheme(schemeId);
    }

    public final boolean isPartialMatch(TriggerSequence sequence) {
        return this.bindingManager.isPartialMatch(sequence);
    }

    public final boolean isPerfectMatch(TriggerSequence sequence) {
        return this.bindingManager.isPerfectMatch(sequence);
    }

    public final void readRegistryAndPreferences(ICommandService commandService) {
    }

    public final void removeBinding(Binding binding) {
        this.bindingManager.removeBinding(binding);
    }

    public final void savePreferences(Scheme activeScheme, Binding[] bindings) throws IOException {
        this.bindingManager.setBindings(bindings);
    }
}

