/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;

public final class EditorSelectionDialog
extends Dialog {
    private EditorDescriptor selectedEditor;
    private Table editorTable;
    private Button okButton;
    private String message;
    private IEditorDescriptor[] internalEditors;
    private Image[] externalEditorImages;
    private Image[] internalEditorImages;
    private IEditorDescriptor[] editorsToFilter;
    private DialogListener listener;
    private static final int TABLE_WIDTH = 200;

    public EditorSelectionDialog(Shell parentShell) {
        super(parentShell);
        this.message = WorkbenchMessages.get().EditorSelection_chooseAnEditor;
        this.listener = new DialogListener();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveWidgetValues();
        }
        super.buttonPressed(buttonId);
    }

    public boolean close() {
        if (this.internalEditorImages != null) {
            this.internalEditorImages = null;
        }
        if (this.externalEditorImages != null) {
            this.externalEditorImages = null;
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.get().EditorSelection_title);
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite contents = (Composite)super.createDialogArea(parent);
        ((GridLayout)contents.getLayout()).numColumns = 2;
        Label textLabel = new Label(contents, 0);
        textLabel.setText(this.message);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        textLabel.setLayoutData((Object)data);
        textLabel.setFont(font);
        this.editorTable = new Table(contents, 2052);
        this.editorTable.addListener(13, (Listener)this.listener);
        this.editorTable.addListener(14, (Listener)this.listener);
        data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(200);
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalSpan = 2;
        this.editorTable.setLayoutData((Object)data);
        this.editorTable.setFont(font);
        data.heightHint = this.editorTable.getItemHeight() * 12;
        this.restoreWidgetValues();
        this.fillEditorTable();
        this.updateEnableState();
        return contents;
    }

    protected void fillEditorTable() {
        this.editorTable.removeAll();
        this.editorTable.redraw();
        IEditorDescriptor[] editors = this.getInternalEditors();
        Image[] images = this.internalEditorImages;
        this.editorTable.setRedraw(false);
        int i = 0;
        while (i < editors.length) {
            TableItem item = new TableItem(this.editorTable, 0);
            item.setData((Object)editors[i]);
            item.setText(editors[i].getLabel());
            item.setImage(images[i]);
            ++i;
        }
        this.editorTable.setRedraw(true);
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("EditorSelectionDialog");
        if (section == null) {
            section = workbenchSettings.addNewSection("EditorSelectionDialog");
        }
        return section;
    }

    protected IEditorDescriptor[] filterEditors(IEditorDescriptor[] editors) {
        if (editors == null || editors.length < 1) {
            return editors;
        }
        if (this.editorsToFilter == null || this.editorsToFilter.length < 1) {
            return editors;
        }
        ArrayList<IEditorDescriptor> filteredList = new ArrayList<IEditorDescriptor>();
        int i = 0;
        while (i < editors.length) {
            boolean add = true;
            int j = 0;
            while (j < this.editorsToFilter.length) {
                if (editors[i].getId().equals(this.editorsToFilter[j].getId())) {
                    add = false;
                }
                ++j;
            }
            if (add) {
                filteredList.add(editors[i]);
            }
            ++i;
        }
        return filteredList.toArray(new IEditorDescriptor[filteredList.size()]);
    }

    protected Image[] getImages(IEditorDescriptor[] editors) {
        Image[] images = new Image[editors.length];
        int i = 0;
        while (i < editors.length) {
            images[i] = editors[i].getImageDescriptor().createImage();
            ++i;
        }
        return images;
    }

    protected IEditorDescriptor[] getInternalEditors() {
        if (this.internalEditors == null) {
            EditorRegistry reg = (EditorRegistry)WorkbenchPlugin.getDefault().getEditorRegistry();
            this.internalEditors = reg.getSortedEditorsFromPlugins();
            this.internalEditors = this.filterEditors(this.internalEditors);
            this.internalEditorImages = this.getImages(this.internalEditors);
        }
        return this.internalEditors;
    }

    public IEditorDescriptor getSelectedEditor() {
        return this.selectedEditor;
    }

    protected void handleDoubleClickEvent() {
        this.buttonPressed(0);
    }

    protected void restoreWidgetValues() {
    }

    protected void saveWidgetValues() {
    }

    public void setMessage(String aMessage) {
        this.message = aMessage;
    }

    public void setEditorsToFilter(IEditorDescriptor[] editors) {
        this.editorsToFilter = editors;
    }

    protected void updateEnableState() {
        this.updateOkButton();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.get().OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.get().CANCEL_LABEL, false);
        this.okButton.setEnabled(false);
    }

    protected void updateOkButton() {
        if (this.okButton == null) {
            return;
        }
        if (this.editorTable.getSelectionCount() == 0) {
            this.okButton.setEnabled(false);
            return;
        }
        this.okButton.setEnabled(this.selectedEditor != null);
    }

    private class DialogListener
    implements Listener {
        private DialogListener() {
        }

        public void handleEvent(Event event) {
            if (event.widget == EditorSelectionDialog.this.editorTable) {
                if (EditorSelectionDialog.this.editorTable.getSelectionIndex() != -1) {
                    EditorSelectionDialog.this.selectedEditor = (EditorDescriptor)EditorSelectionDialog.this.editorTable.getSelection()[0].getData();
                } else {
                    EditorSelectionDialog.this.selectedEditor = null;
                    EditorSelectionDialog.this.okButton.setEnabled(false);
                }
            }
            EditorSelectionDialog.this.updateEnableState();
        }
    }
}

