/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.preferences;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.service.ISettingStore;
import org.eclipse.rwt.service.SettingStoreEvent;
import org.eclipse.rwt.service.SettingStoreException;
import org.eclipse.rwt.service.SettingStoreListener;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.preferences.SessionPreferencesNode;
import org.osgi.service.prefs.Preferences;

final class SessionPreferenceNodeCore {
    private final SessionPreferencesNode node;
    private ListenerList prefListeners;
    private final ListenerList nodeListeners = new ListenerList(1);
    private SettingStoreListener rwtListener;
    private boolean trackChanges = true;
    private String ignoreKey;

    SessionPreferenceNodeCore(SessionPreferencesNode node) {
        ParamCheck.notNull((Object)node, (String)"node");
        this.node = node;
    }

    void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (listener != null) {
            this.getListenerList().add((Object)listener);
            this.setTrackRWTChanges(true);
        }
    }

    void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        if (listener != null) {
            ListenerList list = this.getListenerList();
            list.remove((Object)listener);
            if (list.isEmpty()) {
                this.setTrackRWTChanges(false);
            }
        }
    }

    void firePreferenceEvent(String key, String oldValue, String newValue) {
        if (this.prefListeners != null) {
            final IEclipsePreferences.PreferenceChangeEvent event = new IEclipsePreferences.PreferenceChangeEvent((Object)this.node, key, (Object)oldValue, (Object)newValue);
            Object[] listeners = this.prefListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                final IEclipsePreferences.IPreferenceChangeListener listener = (IEclipsePreferences.IPreferenceChangeListener)listeners[i];
                ISafeRunnable op = new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.preferenceChange(event);
                    }
                };
                SafeRunner.run((ISafeRunnable)op);
                ++i;
            }
        }
    }

    void clear() {
        if (this.prefListeners != null) {
            this.prefListeners.clear();
            this.prefListeners = null;
            this.setTrackRWTChanges(false);
        }
        this.nodeListeners.clear();
    }

    synchronized String put(String uniqueKey, String value) {
        ISettingStore store = RWT.getSettingStore();
        String result = store.getAttribute(uniqueKey);
        try {
            this.ignoreKey = uniqueKey;
            store.setAttribute(uniqueKey, value);
            this.ignoreKey = null;
        }
        catch (SettingStoreException exc) {
            String msg = "Could not persist preference: " + uniqueKey;
            WorkbenchPlugin.log(msg, exc);
        }
        return result;
    }

    private synchronized ListenerList getListenerList() {
        if (this.prefListeners == null) {
            this.prefListeners = new ListenerList(1);
        }
        return this.prefListeners;
    }

    private synchronized void setTrackRWTChanges(boolean doTrack) {
        this.trackChanges = doTrack;
        if (this.trackChanges) {
            if (this.rwtListener == null) {
                this.rwtListener = new SettingStoreListener(){

                    public void settingChanged(SettingStoreEvent event) {
                        String absPath;
                        String fullKey;
                        if (SessionPreferenceNodeCore.this.trackChanges && !(fullKey = event.getAttributeName()).equals(SessionPreferenceNodeCore.this.ignoreKey) && fullKey.startsWith(absPath = SessionPreferenceNodeCore.this.node.absolutePath())) {
                            String key = fullKey.substring(absPath.length() + 1);
                            String oldValue = event.getOldValue();
                            String newValue = event.getNewValue();
                            SessionPreferenceNodeCore.this.firePreferenceEvent(key, oldValue, newValue);
                        }
                    }
                };
            }
            RWT.getSettingStore().addSettingStoreListener(this.rwtListener);
        } else if (this.rwtListener != null) {
            RWT.getSettingStore().removeSettingStoreListener(this.rwtListener);
        }
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.nodeListeners.add((Object)listener);
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        this.nodeListeners.remove((Object)listener);
    }

    public void fireNodeEvent(Preferences child, final boolean wasAdded, SessionPreferencesNode spn) {
        final IEclipsePreferences.NodeChangeEvent event = new IEclipsePreferences.NodeChangeEvent((Preferences)spn, child);
        Object[] listeners = this.nodeListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final IEclipsePreferences.INodeChangeListener listener = (IEclipsePreferences.INodeChangeListener)listeners[i];
            ISafeRunnable op = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    if (wasAdded) {
                        listener.added(event);
                    } else {
                        listener.removed(event);
                    }
                }
            };
            SafeRunner.run((ISafeRunnable)op);
            ++i;
        }
    }
}

