/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.internal.core.LoadTargetOperation;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetModel;
import org.eclipse.pde.internal.core.target.TargetModel;
import org.eclipse.rap.ui.internal.intro.ErrorUtil;
import org.eclipse.rap.ui.internal.intro.IntroPlugin;
import org.eclipse.rap.ui.internal.intro.target.InstallTargetDialog;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class InstallRAPTargetHandler
extends AbstractHandler {
    private static final String TARGET_FILE = "target/rap.target";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
        InstallTargetDialog dialog = new InstallTargetDialog(shell);
        int result = dialog.open();
        if (result == 0) {
            String targetDestination = dialog.getTargetDestination();
            InstallRAPTargetHandler.installTarget(targetDestination);
            if (dialog.shouldSwitchTarget()) {
                InstallRAPTargetHandler.switchTarget(targetDestination);
            }
        }
        return null;
    }

    private static void installTarget(final String targetDestination) throws ExecutionException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    TargetProvider.install(targetDestination, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            String msg = IntroMessages.InstallRAPTargetHandler_InstallFailed;
            throw new ExecutionException(msg, cause);
        }
        catch (InterruptedException interruptedException) {
            String msg = IntroMessages.InstallRAPTargetHandler_InstallInterrupted;
            throw new ExecutionException(msg);
        }
    }

    private static void switchTarget(final String targetDestination) {
        IRunnableWithProgress run = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        ITargetModel model = InstallRAPTargetHandler.getTargetModel(targetDestination);
                        if (model.isLoaded()) {
                            ITarget target = model.getTarget();
                            LoadTargetOperation operation = new LoadTargetOperation(target);
                            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)operation, monitor);
                        }
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_10 = null;
                }
                monitor.done();
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.runInUI((IRunnableContext)service, run, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            String msg = IntroMessages.InstallRAPTargetHandler_SwitchTargetFailed;
            ErrorUtil.show(msg, e);
        }
        catch (InterruptedException e) {
            String msg = IntroMessages.InstallRAPTargetHandler_SwitchTargetInterrupted;
            ErrorUtil.log(msg, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ITargetModel getTargetModel(String targetDestination) throws IOException, CoreException {
        TargetModel targetModel = new TargetModel();
        URL entry = IntroPlugin.getDefault().getBundle().getEntry(TARGET_FILE);
        BufferedInputStream is = new BufferedInputStream(entry.openStream());
        try {
            targetModel.load((InputStream)is, true);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((InputStream)is).close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((InputStream)is).close();
        File path = new File(targetDestination, "eclipse");
        targetModel.getTarget().getLocationInfo().setPath(path.toString());
        return targetModel;
    }
}

