/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ant.core.AntRunner;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rap.ui.internal.intro.IntroPlugin;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.osgi.framework.Bundle;

public final class TargetProvider {
    private static final String COPY_ANT_XML = "copy.ant.xml";
    private static final String CHARSET_NAME = "ISO-8859-1";
    private static final String DEFAULT_TARGET_DEST = "org.eclipse.rap.target-1.2";
    static /* synthetic */ Class class$0;

    public static String getDefaultTargetDestination() {
        URL configLocation = Platform.getConfigurationLocation().getURL();
        File targetDest = new File(configLocation.getFile(), DEFAULT_TARGET_DEST);
        return targetDest.toString();
    }

    public static void install(String targetDest, IProgressMonitor monitor) throws CoreException {
        TargetProvider.checkTargetDestination(targetDest);
        File scriptFile = TargetProvider.createScriptFile();
        AntRunner runner = new AntRunner();
        runner.setBuildFileLocation(scriptFile.getAbsolutePath());
        runner.addUserProperties(TargetProvider.getProperties(targetDest));
        runner.run(monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File createScriptFile() throws CoreException {
        String path = IntroPlugin.getDefault().getStateLocation().toOSString();
        File file = new File(path, COPY_ANT_XML);
        if (file.exists()) {
            file.delete();
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                Charset charset = Charset.forName(CHARSET_NAME);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, charset);
                try {
                    writer.write(TargetProvider.loadContent());
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    writer.close();
                    throw throwable;
                }
                {
                    Object var5_10 = null;
                    writer.close();
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                stream.close();
                throw throwable;
            }
            {
                Object var7_13 = null;
                stream.close();
                return file;
            }
        }
        catch (IOException e) {
            String msg = IntroMessages.TargetProvider_FailureCreateScript;
            Status status = new Status(4, "org.eclipse.rap.ui.intro", msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static void checkTargetDestination(String location) throws CoreException {
        boolean valid;
        File file = new File(location);
        file.mkdirs();
        boolean bl = valid = file.canWrite() && file.isDirectory();
        if (!valid) {
            String text = IntroMessages.TargetProvider_InvalidTargetDest;
            Object[] args = new Object[]{file.toString()};
            String msg = MessageFormat.format(text, args);
            Status status = new Status(4, "org.eclipse.rap.ui.intro", msg, null);
            throw new CoreException((IStatus)status);
        }
    }

    private static Map getProperties(String targetDest) throws CoreException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("src", TargetProvider.getTargetSrc());
        result.put("dest", targetDest);
        return result;
    }

    private static String getTargetSrc() throws CoreException {
        URL result;
        try {
            Bundle bundle = IntroPlugin.getDefault().getBundle();
            URL targetEntry = bundle.getEntry("target/target.zip");
            if (targetEntry == null) {
                String msg = IntroMessages.TargetProvider_ArchiveNotFound;
                Status status = new Status(4, "org.eclipse.rap.ui.intro", msg, null);
                throw new CoreException((IStatus)status);
            }
            result = FileLocator.resolve((URL)targetEntry);
        }
        catch (IOException e) {
            String msg = IntroMessages.TargetProvider_SourceNotFound;
            Status status = new Status(4, "org.eclipse.rap.ui.intro", msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        return result.getFile();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadContent() throws IOException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.rap.ui.internal.intro.target.TargetProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        InputStream stream = clazz.getResourceAsStream(COPY_ANT_XML);
        StringBuffer buffer = new StringBuffer();
        Charset charset = Charset.forName(CHARSET_NAME);
        InputStreamReader reader = new InputStreamReader(stream, charset);
        BufferedReader br = new BufferedReader(reader);
        try {
            int character = br.read();
            while (character != -1) {
                buffer.append((char)character);
                character = br.read();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            br.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        br.close();
        return buffer.toString();
    }

    private TargetProvider() {
    }
}

