/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.RuntimeProcess;
import org.eclipse.pde.ui.launcher.EquinoxLaunchConfiguration;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.PortBusyStatusHandler;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.URLBuilder;
import org.eclipse.rap.ui.internal.launch.util.ErrorUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class RAPLaunchDelegate
extends EquinoxLaunchConfiguration {
    private static final String VMARG_PORT = "-Dorg.osgi.service.http.port=";
    private static final String VMARG_LOG_LEVEL = "-Dorg.eclipse.rwt.clientLogLevel=";
    private static final String VMARG_LIBRARY_VARIANT = "-Dorg.eclipse.rwt.clientLibraryVariant=";
    private static final String VMARG_AWT_HEADLESS = "-Djava.awt.headless=";
    private static final int CONNECT_TIMEOUT = 20000;
    private ILaunch launch;
    private RAPLaunchConfig config;
    private int port;
    private final boolean testMode;

    public RAPLaunchDelegate() {
        this(false);
    }

    public RAPLaunchDelegate(boolean testMode) {
        this.testMode = testMode;
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = this.doPreLaunch(config, launch, monitor);
        super.launch(config, mode, launch, (IProgressMonitor)subMonitor);
    }

    public SubProgressMonitor doPreLaunch(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        this.launch = launch;
        this.config = new RAPLaunchConfig(config);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, -1);
        this.terminateIfRunning((IProgressMonitor)subMonitor);
        subMonitor = new SubProgressMonitor(monitor, -1);
        this.warnIfPortBusy(subMonitor);
        subMonitor = new SubProgressMonitor(monitor, -1);
        this.port = this.determinePort((IProgressMonitor)subMonitor);
        if (this.config.getOpenBrowser()) {
            this.registerBrowserOpener();
        }
        return subMonitor;
    }

    public String[] getVMArguments(ILaunchConfiguration config) throws CoreException {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(super.getVMArguments(config)));
        list.addAll(Arrays.asList(this.getRAPVMArguments()));
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    private String[] getRAPVMArguments() throws CoreException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(VMARG_PORT + this.port);
        list.add(VMARG_LOG_LEVEL + this.config.getLogLevel().getName());
        RAPLaunchConfig.LibraryVariant libraryVariant = this.config.getLibraryVariant();
        if (libraryVariant != RAPLaunchConfig.LibraryVariant.STANDARD) {
            list.add(VMARG_LIBRARY_VARIANT + libraryVariant.getName());
        }
        if ("macosx".equals(Platform.getOS())) {
            list.add(VMARG_AWT_HEADLESS + Boolean.TRUE);
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void warnIfPortBusy(SubProgressMonitor monitor) throws CoreException {
        String taskName = "Checking manual port";
        monitor.beginTask(taskName, -1);
        try {
            IStatus status;
            Object resolution;
            DebugPlugin debugPlugin;
            IStatusHandler prompter;
            if (this.config.getUseManualPort() && RAPLaunchDelegate.isPortBusy(this.config.getPort()) && (prompter = (debugPlugin = DebugPlugin.getDefault()).getStatusHandler(promptStatus)) != null && Boolean.FALSE.equals(resolution = prompter.handleStatus(status = PortBusyStatusHandler.STATUS, (Object)this.config))) {
                String text = "Port {0,number,#} in use. Launch ''{1}'' interrupted by user.";
                Object[] args = new Object[]{new Integer(this.config.getPort()), this.config.getName()};
                String msg = MessageFormat.format(text, args);
                String pluginId = "org.eclipse.rap.ui.launch";
                Status infoStatus = new Status(1, pluginId, msg);
                throw new CoreException((IStatus)infoStatus);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int determinePort(IProgressMonitor monitor) throws CoreException {
        int result;
        String taskName = "Determining port number";
        monitor.beginTask(taskName, -1);
        try {
            result = this.config.getUseManualPort() ? this.config.getPort() : RAPLaunchDelegate.findFreePort();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findFreePort() throws CoreException {
        try {
            int n;
            ServerSocket server = new ServerSocket(0);
            try {
                n = server.getLocalPort();
                Object var1_4 = null;
            }
            catch (Throwable throwable) {
                Object var1_5 = null;
                server.close();
                throw throwable;
            }
            server.close();
            return n;
        }
        catch (IOException e) {
            String msg = "Could not obtain a free port number.";
            String pluginId = Activator.getPluginId();
            Status status = new Status(4, pluginId, msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private static boolean isPortBusy(int port) {
        ServerSocket server = null;
        try {
            server = new ServerSocket(port);
        }
        catch (IOException iOException) {}
        if (server != null) {
            try {
                server.close();
            }
            catch (IOException iOException) {}
        }
        return server == null;
    }

    private URL getUrl() throws CoreException {
        try {
            return URLBuilder.fromLaunchConfig(this.config, this.port, this.testMode);
        }
        catch (MalformedURLException e) {
            String msg = "Invalid URL.";
            String pluginId = Activator.getPluginId();
            Status status = new Status(4, pluginId, 0, msg, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void terminateIfRunning(IProgressMonitor monitor) throws CoreException {
        if (!this.config.getTerminatePrevious()) return;
        String taskName = "Terminating previous launch";
        monitor.beginTask(taskName, -1);
        try {
            ILaunch runningLaunch = this.findRunning();
            if (runningLaunch != null) {
                RAPLaunchDelegate.terminate(runningLaunch);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    private ILaunch findRunning() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] runningLaunches = launchManager.getLaunches();
        ILaunch result = null;
        int i = 0;
        while (result == null && i < runningLaunches.length) {
            ILaunch runningLaunch = runningLaunches[i];
            if (runningLaunch != this.launch && this.config.getName().equals(RAPLaunchDelegate.getLaunchName(runningLaunch)) && !runningLaunch.isTerminated()) {
                result = runningLaunches[i];
            }
            ++i;
        }
        return result;
    }

    private static String getLaunchName(ILaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        return launchConfiguration == null ? null : launchConfiguration.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void terminate(final ILaunch previousLaunch) throws DebugException {
        final Object signal = new Object();
        final boolean[] terminated = new boolean[1];
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener(new IDebugEventSetListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (RAPLaunchDelegate.isTerminateEventFor(event, previousLaunch)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        terminated[0] = true;
                        Object object = signal;
                        synchronized (object) {
                            signal.notifyAll();
                        }
                    }
                    ++i;
                }
            }
        });
        previousLaunch.terminate();
        if (!terminated[0]) {
            try {
                Object object = signal;
                synchronized (object) {
                    signal.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static boolean isCreateEventFor(DebugEvent event, ILaunch launch) {
        Object source = event.getSource();
        return event.getKind() == 4 && source instanceof RuntimeProcess && ((RuntimeProcess)source).getLaunch() == launch;
    }

    private static boolean isTerminateEventFor(DebugEvent event, ILaunch launch) {
        boolean result = false;
        if (event.getKind() == 8 && event.getSource() instanceof RuntimeProcess) {
            RuntimeProcess process = (RuntimeProcess)event.getSource();
            result = process.getLaunch() == launch;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitForHttpService(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = "Waiting for HTTP service";
        subMonitor.beginTask(taskName, -1);
        try {
            this.waitForHttpService();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            subMonitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        subMonitor.done();
    }

    private void waitForHttpService() {
        long start = System.currentTimeMillis();
        boolean canConnect = false;
        boolean interrupted = false;
        while (!(System.currentTimeMillis() - start > 20000L || canConnect || interrupted || this.launch.isTerminated())) {
            try {
                Socket socket = new Socket(URLBuilder.getHost(), this.port);
                socket.close();
                canConnect = true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
        }
    }

    private void registerBrowserOpener() {
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        debugPlugin.addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    if (RAPLaunchDelegate.isCreateEventFor(event, RAPLaunchDelegate.this.launch)) {
                        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                        Job job = new Job(this, "Starting client application"){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            protected IStatus run(IProgressMonitor monitor) {
                                monitor.beginTask("Starting client application", 2);
                                try {
                                    RAPLaunchDelegate.access$3(2.access$0(this.this$1), monitor);
                                    monitor.worked(1);
                                    if (!RAPLaunchDelegate.access$1(2.access$0(this.this$1)).isTerminated()) {
                                        RAPLaunchDelegate.access$4(2.access$0(this.this$1), monitor);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var2_3 = null;
                                    monitor.done();
                                    throw throwable;
                                }
                                {
                                    Object var2_4 = null;
                                }
                                monitor.done();
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    ++i;
                }
            }

            static /* synthetic */ RAPLaunchDelegate access$0(2 var0) {
                return var0.RAPLaunchDelegate.this;
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void openBrowser(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        String taskName = "Starting client application";
        subMonitor.beginTask(taskName, -1);
        try {
            URL url = null;
            try {
                url = this.getUrl();
                IWebBrowser browser = this.getBrowser();
                RAPLaunchDelegate.openUrl(browser, url);
            }
            catch (CoreException e) {
                String text = "Failed to open browser for URL ''{0}''.";
                String msg = MessageFormat.format(text, url);
                ErrorUtil.show(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            subMonitor.done();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        subMonitor.done();
    }

    private IWebBrowser getBrowser() throws CoreException {
        final IWebBrowser[] result = new IWebBrowser[1];
        final CoreException[] exception = new CoreException[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    IWorkbenchBrowserSupport support = workbench.getBrowserSupport();
                    int style = 14;
                    style = RAPLaunchConfig.BrowserMode.EXTERNAL.equals(RAPLaunchDelegate.this.config.getBrowserMode()) ? (style |= 0x80) : (style |= 0x20);
                    String id = String.valueOf(RAPLaunchDelegate.this.config.getName()) + RAPLaunchDelegate.this.config.getBrowserMode();
                    String name = RAPLaunchDelegate.this.config.getName();
                    String toolTip = RAPLaunchDelegate.this.config.getName();
                    result[0] = support.createBrowser(style, id, name, toolTip);
                }
                catch (CoreException e) {
                    exception[0] = e;
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
        return result[0];
    }

    private static void openUrl(final IWebBrowser browser, final URL url) throws PartInitException {
        final PartInitException[] exception = new PartInitException[1];
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    browser.openURL(url);
                }
                catch (PartInitException e) {
                    String text = "Failed to open URL ''{0}'' in browser.";
                    String msg = MessageFormat.format(text, url);
                    String pluginId = Activator.getPluginId();
                    Status status = new Status(4, pluginId, msg, (Throwable)e);
                    exception[0] = new PartInitException((IStatus)status);
                }
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    static /* synthetic */ void access$3(RAPLaunchDelegate rAPLaunchDelegate, IProgressMonitor iProgressMonitor) {
        rAPLaunchDelegate.waitForHttpService(iProgressMonitor);
    }

    static /* synthetic */ void access$4(RAPLaunchDelegate rAPLaunchDelegate, IProgressMonitor iProgressMonitor) {
        rAPLaunchDelegate.openBrowser(iProgressMonitor);
    }
}

