/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.text.MessageFormat;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public final class RAPLaunchConfig {
    public static final Level[] LOG_LEVELS = new Level[]{Level.OFF, Level.ALL, Level.WARNING, Level.INFO, Level.SEVERE, Level.FINE, Level.FINER, Level.FINEST};
    public static final int MIN_PORT_NUMBER = 0;
    public static final int MAX_PORT_NUMBER = 65535;
    private static final String PREFIX = "org.eclipse.rap.launch.";
    public static final String SERVLET_NAME = "org.eclipse.rap.launch.servletName";
    public static final String ENTRY_POINT = "org.eclipse.rap.launch.entryPoint";
    public static final String TERMINATE_PREVIOUS = "org.eclipse.rap.launch.terminatePrevious";
    public static final String OPEN_BROWSER = "org.eclipse.rap.launch.openBrowser";
    public static final String BROWSER_MODE = "org.eclipse.rap.launch.browserMode";
    public static final String PORT = "org.eclipse.rap.launch.port";
    public static final String USE_MANUAL_PORT = "org.eclipse.rap.launch.useManualPort";
    public static final String LOG_LEVEL = "org.eclipse.rap.launch.logLevel";
    public static final String LIBRARY_VARIANT = "org.eclipse.rap.launch.libraryVariant";
    private static final String DEFAULT_SERVLET_NAME = "rap";
    private static final String DEFAULT_ENTRY_POINT = "";
    private static final boolean DEFAULT_TERMINATE_PREVIOUS = true;
    private static final BrowserMode DEFAULT_BROWSER_MODE = BrowserMode.INTERNAL;
    private static final int DEFAULT_PORT = 10080;
    private static final boolean DEFAULT_USE_MANUAL_PORT = false;
    private static final String DEFAULT_LOG_LEVEL = Level.OFF.getName();
    private static final String DEFAULT_LIBRARY_VARIANT = LibraryVariant.STANDARD.getName();
    private final ILaunchConfiguration config;
    private final ILaunchConfigurationWorkingCopy workingCopy;

    public static void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(SERVLET_NAME, DEFAULT_SERVLET_NAME);
        config.setAttribute(ENTRY_POINT, DEFAULT_ENTRY_POINT);
        config.setAttribute(TERMINATE_PREVIOUS, true);
        config.setAttribute(BROWSER_MODE, DEFAULT_BROWSER_MODE.getName());
        config.setAttribute(PORT, 10080);
        config.setAttribute(USE_MANUAL_PORT, false);
        config.setAttribute(LOG_LEVEL, DEFAULT_LOG_LEVEL);
        config.setAttribute(LIBRARY_VARIANT, DEFAULT_LIBRARY_VARIANT);
    }

    public RAPLaunchConfig(ILaunchConfiguration config) {
        this.config = config;
        this.workingCopy = config instanceof ILaunchConfigurationWorkingCopy ? (ILaunchConfigurationWorkingCopy)config : null;
    }

    public String getName() {
        return this.config.getName();
    }

    public String getServletName() throws CoreException {
        return this.config.getAttribute(SERVLET_NAME, DEFAULT_SERVLET_NAME);
    }

    public void setServletName(String entryPoint) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(SERVLET_NAME, entryPoint);
    }

    public String getEntryPoint() throws CoreException {
        return this.config.getAttribute(ENTRY_POINT, DEFAULT_ENTRY_POINT);
    }

    public void setEntryPoint(String entryPoint) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(ENTRY_POINT, entryPoint);
    }

    public boolean getTerminatePrevious() throws CoreException {
        return this.config.getAttribute(TERMINATE_PREVIOUS, true);
    }

    public void setTerminatePrevious(boolean terminatePrevious) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(TERMINATE_PREVIOUS, terminatePrevious);
    }

    public boolean getOpenBrowser() throws CoreException {
        return this.config.getAttribute(OPEN_BROWSER, true);
    }

    public void setOpenBrowser(boolean openBrowser) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(OPEN_BROWSER, openBrowser);
    }

    public BrowserMode getBrowserMode() throws CoreException {
        String value = this.config.getAttribute(BROWSER_MODE, BrowserMode.INTERNAL.getName());
        return BrowserMode.parse(value);
    }

    public void setBrowserMode(BrowserMode browserMode) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(BROWSER_MODE, browserMode.getName());
    }

    public boolean getUseManualPort() throws CoreException {
        return this.config.getAttribute(USE_MANUAL_PORT, false);
    }

    public void setUseManualPort(boolean useManualPort) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(USE_MANUAL_PORT, useManualPort);
    }

    public int getPort() throws CoreException {
        return this.config.getAttribute(PORT, 10080);
    }

    public void setPort(int port) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(PORT, port);
    }

    public Level getLogLevel() throws CoreException {
        String value = this.config.getAttribute(LOG_LEVEL, DEFAULT_LOG_LEVEL);
        return Level.parse(value);
    }

    public void setLogLevel(Level logLevel) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(LOG_LEVEL, logLevel.getName());
    }

    public LibraryVariant getLibraryVariant() throws CoreException {
        String value = this.config.getAttribute(LIBRARY_VARIANT, DEFAULT_LIBRARY_VARIANT);
        return LibraryVariant.parse(value);
    }

    public void setLibraryVariant(LibraryVariant libraryVariant) {
        this.checkWorkingCopy();
        this.workingCopy.setAttribute(LIBRARY_VARIANT, libraryVariant.getName());
    }

    private void checkWorkingCopy() {
        if (this.workingCopy == null) {
            String msg = "Launch configuration cannot be modified, no working copy available";
            throw new IllegalStateException(msg);
        }
    }

    public static final class BrowserMode {
        public static final BrowserMode INTERNAL = new BrowserMode("INTERNAL");
        public static final BrowserMode EXTERNAL = new BrowserMode("EXTERNAL");
        private final String name;

        public static BrowserMode[] values() {
            return new BrowserMode[]{INTERNAL, EXTERNAL};
        }

        public static BrowserMode parse(String name) {
            BrowserMode result = null;
            BrowserMode[] knownValues = BrowserMode.values();
            int i = 0;
            while (result == null && i < knownValues.length) {
                if (knownValues[i].getName().equalsIgnoreCase(name)) {
                    result = knownValues[i];
                }
                ++i;
            }
            if (result == null) {
                String text = "Unknown BrowserMode ''{0}''.";
                String msg = MessageFormat.format(text, name);
                throw new IllegalArgumentException(msg);
            }
            return result;
        }

        private BrowserMode(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class LibraryVariant {
        public static final LibraryVariant STANDARD = new LibraryVariant("STANDARD");
        public static final LibraryVariant DEBUG = new LibraryVariant("DEBUG");
        private final String name;

        public static LibraryVariant[] values() {
            return new LibraryVariant[]{STANDARD, DEBUG};
        }

        public static LibraryVariant parse(String name) {
            LibraryVariant result = null;
            LibraryVariant[] knownValues = LibraryVariant.values();
            int i = 0;
            while (result == null && i < knownValues.length) {
                if (knownValues[i].getName().equalsIgnoreCase(name)) {
                    result = knownValues[i];
                }
                ++i;
            }
            if (result == null) {
                String text = "Unknown LibraryVariant ''{0}''.";
                String msg = MessageFormat.format(text, name);
                throw new IllegalArgumentException(msg);
            }
            return result;
        }

        private LibraryVariant(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

