/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.URLBuilder;

public final class RAPLaunchConfigValidator {
    private static final String RAP_LAUNCH_CONFIG_TYPE = "org.eclipse.rap.ui.launch.RAPLauncher";
    private static final String EMPTY = "";
    private final RAPLaunchConfig config;

    public RAPLaunchConfigValidator(RAPLaunchConfig config) {
        this.config = config;
    }

    public IStatus[] validate() {
        ArrayList<IStatus> states = new ArrayList<IStatus>();
        try {
            states.add(this.validateServletName());
            states.add(this.validateEntryPoint());
            states.add(this.validatePort());
            states.add(this.validateUniquePort());
            states.add(this.validateURL());
        }
        catch (CoreException e) {
            String text = "An error occured while validating the launch configuration: {0}";
            Object[] args = new Object[]{e.getLocalizedMessage()};
            String msg = MessageFormat.format(text, args);
            states.add(this.createError(msg, e));
        }
        IStatus[] result = new IStatus[states.size()];
        states.toArray(result);
        return result;
    }

    private IStatus validateServletName() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (EMPTY.equals(this.config.getServletName())) {
            result = this.createError("The servlet name must not be empty", null);
        }
        return result;
    }

    private IStatus validateEntryPoint() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (EMPTY.equals(this.config.getEntryPoint())) {
            result = this.createError("The entry point must not be empty", null);
        }
        return result;
    }

    private IStatus validatePort() throws CoreException {
        int port;
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort() && ((port = this.config.getPort()) < 0 || port > 65535)) {
            String text = "Port number must be between {0} and {1}";
            Object[] args = new Object[]{new Integer(0), new Integer(65535)};
            String msg = MessageFormat.format(text, args);
            result = this.createError(msg, null);
        }
        return result;
    }

    private IStatus validateUniquePort() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort()) {
            RAPLaunchConfig duplicate = null;
            ILaunchConfiguration[] launchConfigs = RAPLaunchConfigValidator.getLaunchConfigs();
            int i = 0;
            while (duplicate == null && i < launchConfigs.length) {
                RAPLaunchConfig otherConfig = new RAPLaunchConfig(launchConfigs[i]);
                if (this.hasSamePort(otherConfig)) {
                    duplicate = otherConfig;
                }
                ++i;
            }
            if (duplicate != null) {
                String text = "The port {0,number,#} is already used by {1}.";
                Object[] args = new Object[]{new Integer(this.config.getPort()), duplicate.getName()};
                String msg = MessageFormat.format(text, args);
                result = this.createWarning(msg, null);
            }
        }
        return result;
    }

    private IStatus validateURL() throws CoreException {
        IStatus result = Status.OK_STATUS;
        try {
            URLBuilder.fromLaunchConfig(this.config, 80, false);
        }
        catch (MalformedURLException e) {
            String text = "Servlet name and/or entry point cause a malformed URL.";
            result = this.createWarning(text, e);
        }
        return result;
    }

    private IStatus createWarning(String msg, Throwable thr) {
        return new Status(2, Activator.getPluginId(), msg, thr);
    }

    private IStatus createError(String msg, Throwable thr) {
        return new Status(4, Activator.getPluginId(), msg, thr);
    }

    private static ILaunchConfiguration[] getLaunchConfigs() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(RAP_LAUNCH_CONFIG_TYPE);
        return launchManager.getLaunchConfigurations(type);
    }

    private boolean hasSamePort(RAPLaunchConfig otherConfig) throws CoreException {
        return otherConfig.getUseManualPort() && !this.config.getName().equals(otherConfig.getName()) && this.config.getPort() == otherConfig.getPort();
    }
}

