/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class PortBusyStatusHandler
implements IStatusHandler {
    static final IStatus STATUS = new Status(1, "org.eclipse.rap.ui.launch", 601, "", null);

    public Object handleStatus(IStatus status, Object source) throws CoreException {
        RAPLaunchConfig config = (RAPLaunchConfig)source;
        String title = "Port in use";
        String text = "Port {0,number,#} is currently in use.\nProceed with launching ''{1}''?";
        Object[] args = new Object[]{new Integer(config.getPort()), config.getName()};
        String msg = MessageFormat.format(text, args);
        String[] buttons = new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL};
        MessageDialog dialog = new MessageDialog(PortBusyStatusHandler.getShell(), title, null, msg, 3, buttons, 0);
        Boolean result = dialog.open() == 0 ? Boolean.TRUE : Boolean.FALSE;
        return result;
    }

    public static Shell getShell() {
        Shell result = null;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
            if (windows.length > 0) {
                result = windows[0].getShell();
            }
        } else {
            result = window.getShell();
        }
        return result;
    }
}

