/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;

final class URLBuilder {
    private static final String EMPTY = "";
    private static final String SLASH = "/";
    private static final String PROTOCOL = "http";
    private static final String HOST = "127.0.0.1";
    private static final String QUERY_STARTUP = "?startup=";
    private static final String QUERY_STARTUP_TEST = "?startup=rapjunit&testentrypoint=";

    static String getHost() {
        return HOST;
    }

    static URL fromLaunchConfig(RAPLaunchConfig config, int port, boolean testMode) throws CoreException, MalformedURLException {
        String servletName = config.getServletName();
        if (!servletName.startsWith(SLASH)) {
            servletName = SLASH + servletName;
        }
        String entryPoint = config.getEntryPoint();
        String query = EMPTY;
        if (testMode) {
            query = QUERY_STARTUP_TEST + entryPoint;
        } else if (!EMPTY.equals(entryPoint)) {
            query = QUERY_STARTUP + entryPoint;
        }
        return new URL(PROTOCOL, HOST, port, String.valueOf(servletName) + query);
    }

    private URLBuilder() {
    }
}

