/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.ui.launcher.BundlesTab;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfigValidator;
import org.eclipse.rap.ui.internal.launch.tab.BrandingExtension;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointExtension;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointSelectionDialog;
import org.eclipse.rap.ui.internal.launch.tab.ServletNameSelectionDialog;
import org.eclipse.rap.ui.internal.launch.util.ErrorUtil;
import org.eclipse.rap.ui.internal.launch.util.Images;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class MainTab
extends AbstractLaunchConfigurationTab {
    private static final String BROWSER_PREFERENCE_PAGE = "org.eclipse.ui.browser.preferencePage";
    private final GridDataFactory fillHorizontal;
    private final ModifyListener modifyListener;
    private final SelectionListener selectionListener;
    private final Image tabImage = Images.DESC_MAIN_TAB.createImage();
    private final Image warnImage = Images.WARNING.createImage();
    private Text txtServletName;
    private Text txtEntryPoint;
    private Button cbTerminatePrevious;
    private Button cbOpenBrowser;
    private Button rbInternalBrowser;
    private Button rbExternalBrowser;
    private Button cbManualPort;
    private Spinner spnPort;
    private ComboViewer cmbLogLevel;
    private ComboViewer cmbLibVariant;

    public MainTab() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.fillHorizontal = GridDataFactory.createFrom((GridData)gridData);
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    public void dispose() {
        this.tabImage.dispose();
        this.warnImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createServletNameAndEntryPointSection(container);
        this.createBrowserModeSection(container);
        this.createRuntimeSettingsSection(container);
        this.createInfoSection(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public String getName() {
        return "&Main";
    }

    public Image getImage() {
        return this.tabImage;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig(config);
        try {
            this.txtServletName.setText(rapConfig.getServletName());
            this.txtEntryPoint.setText(rapConfig.getEntryPoint());
            this.cbTerminatePrevious.setSelection(rapConfig.getTerminatePrevious());
            this.cbManualPort.setSelection(rapConfig.getUseManualPort());
            this.spnPort.setSelection(rapConfig.getPort());
            boolean openBrowser = rapConfig.getOpenBrowser();
            this.cbOpenBrowser.setSelection(openBrowser);
            this.rbInternalBrowser.setEnabled(openBrowser);
            this.rbExternalBrowser.setEnabled(openBrowser);
            if (RAPLaunchConfig.BrowserMode.EXTERNAL.equals(rapConfig.getBrowserMode())) {
                this.rbExternalBrowser.setSelection(true);
                this.rbInternalBrowser.setSelection(false);
            } else {
                this.rbExternalBrowser.setSelection(false);
                this.rbInternalBrowser.setSelection(true);
            }
            Level logLevel = rapConfig.getLogLevel();
            StructuredSelection logSelection = new StructuredSelection((Object)logLevel);
            this.cmbLogLevel.setSelection((ISelection)logSelection);
            RAPLaunchConfig.LibraryVariant libVariant = rapConfig.getLibraryVariant();
            StructuredSelection libSelection = new StructuredSelection((Object)libVariant);
            this.cmbLibVariant.setSelection((ISelection)libSelection);
        }
        catch (CoreException e) {
            ErrorUtil.show(null, e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig((ILaunchConfiguration)config);
        rapConfig.setServletName(this.txtServletName.getText());
        rapConfig.setEntryPoint(this.txtEntryPoint.getText());
        rapConfig.setTerminatePrevious(this.cbTerminatePrevious.getSelection());
        rapConfig.setOpenBrowser(this.cbOpenBrowser.getSelection());
        rapConfig.setBrowserMode(this.getBrowserMode());
        this.spnPort.setEnabled(this.cbManualPort.getSelection());
        rapConfig.setUseManualPort(this.cbManualPort.getSelection());
        rapConfig.setPort(this.spnPort.getSelection());
        rapConfig.setLogLevel(this.getLogLevel());
        rapConfig.setLibraryVariant(this.getLibraryVariant());
        this.validate(rapConfig);
        this.setDirty(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig.setDefaults(config);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    private void createServletNameAndEntryPointSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText("Servlet and Entry Point to Run");
        Label lblServletName = new Label((Composite)group, 0);
        lblServletName.setText("Ser&vlet Name");
        this.txtServletName = new Text((Composite)group, 2048);
        this.txtServletName.setLayoutData((Object)this.fillHorizontal.create());
        this.txtServletName.addModifyListener(this.modifyListener);
        Button btnBrowseServletName = new Button((Composite)group, 8);
        btnBrowseServletName.setText("Bro&wse...");
        btnBrowseServletName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowseServletName();
            }
        });
        Label lblEntryPoint = new Label((Composite)group, 0);
        lblEntryPoint.setText("&Entry Point");
        this.txtEntryPoint = new Text((Composite)group, 2048);
        this.txtEntryPoint.setLayoutData((Object)this.fillHorizontal.create());
        this.txtEntryPoint.addModifyListener(this.modifyListener);
        Button btnBrowseEntryPoint = new Button((Composite)group, 8);
        btnBrowseEntryPoint.setText("&Browse...");
        btnBrowseEntryPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowseEntryPoint();
            }
        });
        this.cbTerminatePrevious = new Button((Composite)group, 32);
        this.cbTerminatePrevious.setLayoutData((Object)MainTab.spanHorizontal(3, 0));
        String text = "&Terminate possibly running previous launch";
        this.cbTerminatePrevious.setText(text);
        this.cbTerminatePrevious.addSelectionListener(this.selectionListener);
    }

    private void createBrowserModeSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText("Browser");
        group.setLayout((Layout)new GridLayout(2, false));
        this.cbOpenBrowser = new Button((Composite)group, 32);
        GridDataFactory grab = GridDataFactory.swtDefaults();
        grab.grab(true, false);
        this.cbOpenBrowser.setLayoutData((Object)grab.create());
        this.cbOpenBrowser.setText("Open Application in");
        this.cbOpenBrowser.addSelectionListener(this.selectionListener);
        Link lnkBrowserPrefs = new Link((Composite)group, 0);
        lnkBrowserPrefs.setText("<a>Configure Browsers...</a>");
        lnkBrowserPrefs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowserPrefsLink();
            }
        });
        this.rbInternalBrowser = new Button((Composite)group, 16);
        this.rbInternalBrowser.setLayoutData((Object)MainTab.spanHorizontal(2, 17));
        this.rbInternalBrowser.setText("Intern&al Browser");
        this.rbInternalBrowser.addSelectionListener(this.selectionListener);
        this.rbExternalBrowser = new Button((Composite)group, 16);
        this.rbExternalBrowser.setLayoutData((Object)MainTab.spanHorizontal(2, 17));
        this.rbExternalBrowser.setText("E&xternal Browser");
        this.rbExternalBrowser.addSelectionListener(this.selectionListener);
        this.cbOpenBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean openBrowser = MainTab.this.cbOpenBrowser.getSelection();
                MainTab.this.rbInternalBrowser.setEnabled(openBrowser);
                MainTab.this.rbExternalBrowser.setEnabled(openBrowser);
            }
        });
    }

    private void createRuntimeSettingsSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText("Runtime Settings");
        group.setLayout((Layout)new GridLayout(2, false));
        this.cbManualPort = new Button((Composite)group, 32);
        this.cbManualPort.setText("Manual &Port configuration");
        this.cbManualPort.addSelectionListener(this.selectionListener);
        this.spnPort = new Spinner((Composite)group, 2048);
        this.spnPort.setLayoutData((Object)new GridData(60, -1));
        this.spnPort.setMinimum(0);
        this.spnPort.setMaximum(65535);
        this.spnPort.addModifyListener(this.modifyListener);
        Label lblLogLevel = new Label((Composite)group, 0);
        lblLogLevel.setText("Client-side &Log Level");
        this.cmbLogLevel = new ComboViewer((Composite)group, 12);
        int itemCount = RAPLaunchConfig.LOG_LEVELS.length;
        this.cmbLogLevel.getCombo().setVisibleItemCount(itemCount);
        this.cmbLogLevel.setLabelProvider((IBaseLabelProvider)new LogLevelLabelProvider());
        this.cmbLogLevel.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmbLogLevel.setInput((Object)RAPLaunchConfig.LOG_LEVELS);
        this.cmbLogLevel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label lblLibraryVariant = new Label((Composite)group, 0);
        lblLibraryVariant.setText("Client-side Library Variant");
        this.cmbLibVariant = new ComboViewer((Composite)group, 12);
        this.cmbLibVariant.setLabelProvider((IBaseLabelProvider)new LibraryVariantLabelProvider());
        this.cmbLibVariant.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmbLibVariant.setInput((Object)RAPLaunchConfig.LibraryVariant.values());
        this.cmbLibVariant.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createInfoSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText("Important Information");
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblImage = new Label((Composite)group, 0);
        lblImage.setLayoutData((Object)new GridData(128, 16384, false, false));
        lblImage.setImage(this.warnImage);
        String text = "Please note, that the RAP Application Launcher only works with the  Equinox OSGi Framework (this is the default setting on page <a>'Bundles'</a>).";
        Link lblText = new Link((Composite)group, 64);
        lblText.setLayoutData((Object)new GridData(4, 4, true, false));
        lblText.setText(text);
        lblText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleSelectBundlesTab();
            }
        });
    }

    private static GridData spanHorizontal(int span, int indent) {
        GridData result = new GridData(4, 0x1000000, true, false, span, -1);
        result.horizontalIndent = indent;
        return result;
    }

    private void validate(RAPLaunchConfig config) {
        RAPLaunchConfigValidator validator = new RAPLaunchConfigValidator(config);
        IStatus[] states = validator.validate();
        String infoMessage = MainTab.findMessage(states, 1);
        String warnMessage = MainTab.findMessage(states, 2);
        String errorMessage = MainTab.findMessage(states, 4);
        if (warnMessage != null) {
            this.setMessage(warnMessage);
        } else {
            this.setMessage(infoMessage);
        }
        this.setErrorMessage(errorMessage);
    }

    private static String findMessage(IStatus[] states, int severity) {
        String result = null;
        int i = 0;
        while (result == null && i < states.length) {
            if (states[i].matches(severity)) {
                result = states[i].getMessage();
            }
            ++i;
        }
        return result;
    }

    private void handleBrowseEntryPoint() {
        EntryPointSelectionDialog dialog = new EntryPointSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            EntryPointExtension entryPoint = (EntryPointExtension)selection[0];
            this.txtEntryPoint.setText(entryPoint.getParameter());
        }
    }

    private void handleBrowseServletName() {
        ServletNameSelectionDialog dialog = new ServletNameSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            BrandingExtension branding = (BrandingExtension)selection[0];
            this.txtServletName.setText(branding.getServletName());
            String defaultEntryPointId = branding.getDefaultEntryPointId();
            String parameter = null;
            try {
                EntryPointExtension defaultEntryPoint = EntryPointExtension.findById(defaultEntryPointId);
                if (defaultEntryPoint != null) {
                    parameter = defaultEntryPoint.getParameter();
                }
            }
            catch (CoreException e) {
                String msg = "Failed to obtain default entry point from branding";
                ErrorUtil.show(msg, e);
            }
            if (this.txtEntryPoint.getText().length() == 0 && parameter != null) {
                this.txtEntryPoint.setText(parameter);
            }
        }
    }

    private void handleBrowserPrefsLink() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)BROWSER_PREFERENCE_PAGE, null, null);
        dialog.open();
    }

    private void handleSelectBundlesTab() {
        ILaunchConfigurationTab bundlesTab = null;
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (bundlesTab == null && i < tabs.length) {
            if (tabs[i] instanceof BundlesTab) {
                bundlesTab = tabs[i];
            }
            ++i;
        }
        if (bundlesTab != null) {
            this.getLaunchConfigurationDialog().setActiveTab(bundlesTab);
        }
    }

    private RAPLaunchConfig.BrowserMode getBrowserMode() {
        return this.rbExternalBrowser.getSelection() ? RAPLaunchConfig.BrowserMode.EXTERNAL : RAPLaunchConfig.BrowserMode.INTERNAL;
    }

    private Level getLogLevel() {
        Level result = Level.OFF;
        ISelection selection = this.cmbLogLevel.getSelection();
        if (!selection.isEmpty()) {
            result = (Level)((IStructuredSelection)selection).getFirstElement();
        }
        return result;
    }

    private RAPLaunchConfig.LibraryVariant getLibraryVariant() {
        RAPLaunchConfig.LibraryVariant result = RAPLaunchConfig.LibraryVariant.STANDARD;
        ISelection selection = this.cmbLibVariant.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSel = (IStructuredSelection)selection;
            result = (RAPLaunchConfig.LibraryVariant)structuredSel.getFirstElement();
        }
        return result;
    }

    private static final class LibraryVariantLabelProvider
    extends LabelProvider {
        private LibraryVariantLabelProvider() {
        }

        public String getText(Object element) {
            String result = RAPLaunchConfig.LibraryVariant.STANDARD.equals(element) ? "Standard" : (RAPLaunchConfig.LibraryVariant.DEBUG.equals(element) ? "Debug" : super.getText(element));
            return result;
        }
    }

    private static final class LogLevelLabelProvider
    extends LabelProvider {
        private static final Map lables = new HashMap();

        static {
            lables.put(Level.ALL, "All");
            lables.put(Level.OFF, "Off");
            lables.put(Level.CONFIG, "Config");
            lables.put(Level.WARNING, "Warning");
            lables.put(Level.SEVERE, "Severe");
            lables.put(Level.FINE, "Fine");
            lables.put(Level.FINER, "Finer");
            lables.put(Level.FINEST, "Finest");
            lables.put(Level.INFO, "Info");
        }

        private LogLevelLabelProvider() {
        }

        public String getText(Object element) {
            String result = (String)lables.get(element);
            if (result == null) {
                result = super.getText(element);
            }
            return result;
        }
    }
}

