/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.tab.BrandingExtension;
import org.eclipse.rap.ui.internal.launch.tab.SelectionDialogUtil;
import org.eclipse.rap.ui.internal.launch.util.Images;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

final class ServletNameSelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String SETTINGS_ID = "org.eclipse.rap.ui.launch.SERVLET_NAME_SELECTION_DIALOG";
    private static final Comparator COMPARATOR = new BrandingComparator();
    private BrandingExtension[] brandings;

    ServletNameSelectionDialog(Shell shell) {
        super(shell);
        this.setTitle("Select Servlet Name");
        String msg = "&Select a servlet name to open (? = any character, * = any string, SN = ServletName)";
        this.setMessage(msg);
        this.setSelectionHistory(new ServletNameSelectionHistory());
        this.setListLabelProvider((ILabelProvider)new BrandingLabelProvider());
        this.setDetailsLabelProvider((ILabelProvider)new BrandingLabelProvider());
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_ID);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_ID);
        }
        return section;
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider provider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor monitor) throws CoreException {
        if (this.brandings == null) {
            if (monitor != null) {
                String msg = "Searching for servlet names in workspace";
                monitor.beginTask(msg, -1);
            }
            this.brandings = BrandingExtension.findInWorkspace(monitor);
        }
        int i = 0;
        while (i < this.brandings.length) {
            provider.add((Object)this.brandings[i], itemsFilter);
            ++i;
        }
        if (monitor != null) {
            monitor.done();
        }
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new BrandingItemsFilter(SelectionDialogUtil.createSearchPattern());
    }

    public String getElementName(Object element) {
        BrandingExtension branding = (BrandingExtension)element;
        String project = branding.getProject();
        String servletName = branding.getServletName();
        return SelectionDialogUtil.getLabel(project, servletName);
    }

    protected Comparator getItemsComparator() {
        return COMPARATOR;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    private static final class BrandingComparator
    implements Comparator {
        private BrandingComparator() {
        }

        public int compare(Object object1, Object object2) {
            BrandingExtension extension1 = (BrandingExtension)object1;
            BrandingExtension extension2 = (BrandingExtension)object2;
            String string1 = String.valueOf(extension1.getProject()) + extension1.getServletName();
            String string2 = String.valueOf(extension2.getProject()) + extension2.getServletName();
            return string1.compareTo(string2);
        }
    }

    private final class BrandingItemsFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public BrandingItemsFilter(SearchPattern searchPattern) {
            super((FilteredItemsSelectionDialog)ServletNameSelectionDialog.this, searchPattern);
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean matchItem(Object item) {
            return this.matches(((BrandingExtension)item).getServletName());
        }
    }

    private static final class BrandingLabelProvider
    extends LabelProvider {
        private final Image image = Images.EXTENSION.createImage();

        private BrandingLabelProvider() {
        }

        public String getText(Object element) {
            String result = null;
            if (element != null) {
                BrandingExtension branding = (BrandingExtension)element;
                String project = branding.getProject();
                String servletName = branding.getServletName();
                result = SelectionDialogUtil.getLabel(project, servletName);
            }
            return result;
        }

        public Image getImage(Object element) {
            return this.image;
        }

        public void dispose() {
            this.image.dispose();
            super.dispose();
        }
    }

    private static final class ServletNameSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private ServletNameSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }
    }
}

