/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch;

import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.launcher.OSGiFrameworkManager;
import org.eclipse.rap.ui.internal.launch.Activator;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.URLBuilder;

public final class RAPLaunchConfigValidator {
    public static final int ERR_SERVLET_NAME = 6001;
    public static final int ERR_ENTRY_POINT_EMPTY = 6002;
    public static final int ERR_PORT = 6004;
    public static final int ERR_URL = 6005;
    public static final int ERR_LOG_LEVEL = 6006;
    public static final int WARN_OSGI_FRAMEWORK = 7002;
    private static final String RAP_LAUNCH_CONFIG_TYPE = "org.eclipse.rap.ui.launch.RAPLauncher";
    private static final String EQUINOX_FRAMEWORK = "org.eclipse.pde.ui.EquinoxFramework";
    private static final String EMPTY = "";
    private final RAPLaunchConfig config;

    public RAPLaunchConfigValidator(RAPLaunchConfig config) {
        this.config = config;
    }

    public IStatus[] validate() {
        ArrayList<IStatus> states = new ArrayList<IStatus>();
        try {
            this.addNonOKState(states, this.validateServletName());
            this.addNonOKState(states, this.validateEntryPoint());
            this.addNonOKState(states, this.validatePort());
            this.addNonOKState(states, this.validateUniquePort());
            this.addNonOKState(states, this.validateURL());
            this.addNonOKState(states, this.validateLogLevel());
            this.addNonOKState(states, this.validateOSGiFramework());
        }
        catch (CoreException e) {
            String text = "An error occured while validating the launch configuration: {0}";
            Object[] args = new Object[]{e.getLocalizedMessage()};
            String msg = MessageFormat.format(text, args);
            states.add(this.createError(msg, 0, e));
        }
        IStatus[] result = new IStatus[states.size()];
        states.toArray(result);
        return result;
    }

    private IStatus validateServletName() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (EMPTY.equals(this.config.getServletName())) {
            String msg = "The servlet name must not be empty";
            result = this.createError(msg, 6001, null);
        }
        return result;
    }

    private IStatus validateEntryPoint() throws CoreException {
        IStatus result = Status.OK_STATUS;
        String entryPoint = this.config.getEntryPoint();
        if (EMPTY.equals(entryPoint)) {
            String msg = "The entry point must not be empty";
            result = this.createError(msg, 6002, null);
        }
        return result;
    }

    private IStatus validatePort() throws CoreException {
        int port;
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort() && ((port = this.config.getPort()) < 0 || port > 65535)) {
            String text = "Port number must be between {0} and {1}";
            Object[] args = new Object[]{new Integer(0), new Integer(65535)};
            String msg = MessageFormat.format(text, args);
            result = this.createError(msg, 6004, null);
        }
        return result;
    }

    private IStatus validateUniquePort() throws CoreException {
        IStatus result = Status.OK_STATUS;
        if (this.config.getUseManualPort()) {
            RAPLaunchConfig duplicate = null;
            ILaunchConfiguration[] launchConfigs = RAPLaunchConfigValidator.getLaunchConfigs();
            int i = 0;
            while (duplicate == null && i < launchConfigs.length) {
                RAPLaunchConfig otherConfig = new RAPLaunchConfig(launchConfigs[i]);
                if (this.hasSamePort(otherConfig)) {
                    duplicate = otherConfig;
                }
                ++i;
            }
            if (duplicate != null) {
                String text = "The port {0,number,#} is already used by {1}.";
                Object[] args = new Object[]{new Integer(this.config.getPort()), duplicate.getName()};
                String msg = MessageFormat.format(text, args);
                result = this.createWarning(msg, 0, null);
            }
        }
        return result;
    }

    private IStatus validateURL() throws CoreException {
        IStatus result = Status.OK_STATUS;
        try {
            URLBuilder.fromLaunchConfig(this.config, 80, false);
        }
        catch (MalformedURLException e) {
            String text = "Servlet name and/or entry point cause a malformed URL.";
            result = this.createWarning(text, 6005, e);
        }
        return result;
    }

    private IStatus validateLogLevel() throws CoreException {
        IStatus result = Status.OK_STATUS;
        boolean isValid = false;
        Level logLevel = this.config.getLogLevel();
        int i = 0;
        while (!isValid && i < RAPLaunchConfig.LOG_LEVELS.length) {
            if (RAPLaunchConfig.LOG_LEVELS[i].equals(logLevel)) {
                isValid = true;
            }
            ++i;
        }
        if (!isValid) {
            Object[] args = new Object[]{logLevel.getName()};
            String msg = MessageFormat.format("Invalid log level: ''{0}''.", args);
            result = this.createError(msg, 6006, null);
        }
        return result;
    }

    private IStatus validateOSGiFramework() throws CoreException {
        IStatus result = Status.OK_STATUS;
        String frameworkId = this.getOSGiFrameworkId();
        if (!EQUINOX_FRAMEWORK.equals(frameworkId)) {
            String msg = "The RAP launcher only works with the Equinox OSGi Framework";
            result = this.createWarning(msg, 7002, null);
        }
        return result;
    }

    private void addNonOKState(List states, IStatus state) {
        if (state != null && !state.isOK()) {
            states.add(state);
        }
    }

    private IStatus createWarning(String msg, int code, Throwable thr) {
        String pluginId = Activator.getPluginId();
        return new Status(2, pluginId, code, msg, thr);
    }

    private IStatus createError(String msg, int code, Throwable thr) {
        return new Status(4, Activator.getPluginId(), code, msg, thr);
    }

    private static ILaunchConfiguration[] getLaunchConfigs() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType(RAP_LAUNCH_CONFIG_TYPE);
        return launchManager.getLaunchConfigurations(type);
    }

    private boolean hasSamePort(RAPLaunchConfig otherConfig) throws CoreException {
        return otherConfig.getUseManualPort() && !this.config.getName().equals(otherConfig.getName()) && this.config.getPort() == otherConfig.getPort();
    }

    private String getOSGiFrameworkId() throws CoreException {
        ILaunchConfiguration launchConfig = this.config.getUnderlyingLaunchConfig();
        OSGiFrameworkManager manager = PDEPlugin.getDefault().getOSGiFrameworkManager();
        String defaultFrameworkId = manager.getDefaultFramework();
        String attributeName = "osgi_framework_id";
        return launchConfig.getAttribute(attributeName, defaultFrameworkId);
    }
}

