/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.ArrayList;
import java.util.Dictionary;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModel;
import org.eclipse.pde.internal.core.plugin.PluginHandler;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModel;
import org.osgi.framework.Bundle;

final class ExtensionUtil {
    static IPluginExtension[] getWorkspaceExtensions(String extensionPoint, IProgressMonitor monitor) throws CoreException {
        return ExtensionUtil.getPluginExtensions(null, extensionPoint, monitor);
    }

    static IPluginExtension[] getPluginExtensions(String[] pluginIds, String extensionPoint, IProgressMonitor monitor) throws CoreException {
        IPluginExtension[] result = ExtensionUtil.isPDECore33() ? ExtensionUtil.getWorkspaceExtensions33(pluginIds, extensionPoint, monitor) : ExtensionUtil.getWorkspaceExtensions34(pluginIds, extensionPoint, monitor);
        return result;
    }

    static String getAttribute(IPluginElement element, String attributeName) {
        IPluginAttribute attribute = element.getAttribute(attributeName);
        return attribute == null ? null : attribute.getValue();
    }

    static String getProjectName(IPluginExtension pluginExtension) {
        String result = null;
        IPluginModelBase pluginModel = pluginExtension.getPluginModel();
        if (ExtensionUtil.isPDECore33()) {
            if (pluginModel instanceof WorkspacePluginModel) {
                WorkspacePluginModel workspacePlugin = (WorkspacePluginModel)pluginModel;
                IResource resource = workspacePlugin.getUnderlyingResource();
                result = resource.getProject().getName();
            }
        } else {
            result = pluginModel.getUnderlyingResource().getProject().getName();
        }
        return result;
    }

    private static IPluginExtension[] getWorkspaceExtensions33(String[] pluginIdFilter, String extensionPoint, IProgressMonitor monitor) throws CoreException {
        IPluginExtension[] result;
        ArrayList<IPluginExtension> list = new ArrayList<IPluginExtension>();
        IPluginModelBase[] workspacePlugins = ExtensionUtil.findInWorkspace33(extensionPoint);
        int i = 0;
        while (!ExtensionUtil.isCanceled(monitor) && i < workspacePlugins.length) {
            String pluginId;
            IPluginModelBase modelBase = workspacePlugins[i];
            if (modelBase instanceof IBundlePluginModel) {
                IBundlePluginModel bundlePlugin = (IBundlePluginModel)modelBase;
                ISharedExtensionsModel extensionsModel = bundlePlugin.getExtensionsModel();
                IFile pluginXml = (IFile)extensionsModel.getUnderlyingResource();
                WorkspacePluginModel workspacePlugin = new WorkspacePluginModel(pluginXml, false);
                workspacePlugin.load(pluginXml.getContents(), false, new PluginHandler(false));
                modelBase = workspacePlugin;
            }
            if (ExtensionUtil.isContained(pluginIdFilter, pluginId = modelBase.getPluginBase().getId())) {
                IPluginExtension[] extensions = modelBase.getExtensions().getExtensions();
                int k = 0;
                while (k < extensions.length) {
                    if (extensionPoint.equals(extensions[k].getPoint())) {
                        list.add(extensions[k]);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (ExtensionUtil.isCanceled(monitor)) {
            result = new IPluginExtension[]{};
        } else {
            result = new IPluginExtension[list.size()];
            list.toArray(result);
        }
        return result;
    }

    private static IPluginExtension[] getWorkspaceExtensions34(String[] pluginIds, String extensionPoint, IProgressMonitor monitor) {
        IPluginExtension[] result;
        ArrayList<IPluginExtension> list = new ArrayList<IPluginExtension>();
        IPluginModelBase[] pluginModels = PluginRegistry.getWorkspaceModels();
        int i = 0;
        while (!ExtensionUtil.isCanceled(monitor) && i < pluginModels.length) {
            String pluginId = pluginModels[i].getPluginBase().getId();
            if (ExtensionUtil.isContained(pluginIds, pluginId)) {
                IPluginExtension[] extensions = pluginModels[i].getExtensions().getExtensions();
                int k = 0;
                while (k < extensions.length) {
                    if (extensionPoint.equals(extensions[k].getPoint())) {
                        list.add(extensions[k]);
                    }
                    ++k;
                }
            }
            ++i;
        }
        if (ExtensionUtil.isCanceled(monitor)) {
            result = new IPluginExtension[]{};
        } else {
            result = new IPluginExtension[list.size()];
            list.toArray(result);
        }
        return result;
    }

    private static IPluginModelBase[] findInWorkspace33(String extensionPoint) {
        ArrayList<IPluginModelBase> list = new ArrayList<IPluginModelBase>();
        IPluginModelBase[] workspaceModels = PluginRegistry.getWorkspaceModels();
        int i = 0;
        while (i < workspaceModels.length) {
            IPluginExtension[] extensions = workspaceModels[i].getExtensions().getExtensions();
            int k = 0;
            while (k < extensions.length) {
                if (extensionPoint.equals(extensions[k].getPoint())) {
                    list.add(workspaceModels[i]);
                }
                ++k;
            }
            ++i;
        }
        IPluginModelBase[] result = new IPluginModelBase[list.size()];
        list.toArray(result);
        return result;
    }

    private static boolean isCanceled(IProgressMonitor monitor) {
        return monitor != null && monitor.isCanceled();
    }

    private static boolean isPDECore33() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.pde.core");
        Dictionary headers = bundle.getHeaders();
        String version = (String)headers.get("Bundle-Version");
        return version.startsWith("3.3");
    }

    private static boolean isContained(String[] pluginIds, String pluginId) {
        boolean result;
        if (pluginIds == null) {
            result = true;
        } else {
            result = false;
            int i = 0;
            while (!result && i < pluginIds.length) {
                if (pluginId.equals(pluginIds[i])) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    private ExtensionUtil() {
    }
}

