/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.rap.ui.internal.launch.tab.AbstractExtension;
import org.eclipse.rap.ui.internal.launch.tab.ExtensionUtil;

public final class EntryPointExtension
extends AbstractExtension {
    private static final String EXTENSION_ID = "org.eclipse.rap.ui.entrypoint";
    private static final String ATTR_PARAMETER = "parameter";
    private static final String ATTR_ID = "id";
    private final String id;
    private final String parameter;

    public static EntryPointExtension findById(String id) throws CoreException {
        EntryPointExtension result = null;
        if (id != null) {
            EntryPointExtension[] extensions = EntryPointExtension.findInWorkspace(null);
            int i = 0;
            while (result == null && i < extensions.length) {
                if (id.equals(extensions[i].getId())) {
                    result = extensions[i];
                }
                ++i;
            }
        }
        return result;
    }

    public static EntryPointExtension[] findInPlugins(String[] pluginIds, IProgressMonitor monitor) throws CoreException {
        IPluginExtension[] extensions = ExtensionUtil.getPluginExtensions(pluginIds, EXTENSION_ID, monitor);
        return EntryPointExtension.findInPluginExtensions(extensions);
    }

    public static EntryPointExtension[] findInWorkspace(IProgressMonitor monitor) throws CoreException {
        IPluginExtension[] extensions = ExtensionUtil.getWorkspaceExtensions(EXTENSION_ID, monitor);
        return EntryPointExtension.findInPluginExtensions(extensions);
    }

    private static EntryPointExtension[] findInPluginExtensions(IPluginExtension[] extensions) {
        ArrayList<EntryPointExtension> list = new ArrayList<EntryPointExtension>();
        int i = 0;
        while (i < extensions.length) {
            EntryPointExtension[] entryPoints = EntryPointExtension.getEntryPointExtensions(extensions[i]);
            list.addAll(Arrays.asList(entryPoints));
            ++i;
        }
        EntryPointExtension[] result = new EntryPointExtension[list.size()];
        list.toArray(result);
        return result;
    }

    private static final EntryPointExtension[] getEntryPointExtensions(IPluginExtension pluginExtension) {
        IPluginObject[] children = pluginExtension.getChildren();
        EntryPointExtension[] result = new EntryPointExtension[children.length];
        int i = 0;
        while (i < children.length) {
            String project = ExtensionUtil.getProjectName(pluginExtension);
            IPluginElement element = (IPluginElement)children[i];
            String parameter = ExtensionUtil.getAttribute(element, ATTR_PARAMETER);
            String id = ExtensionUtil.getAttribute(element, ATTR_ID);
            result[i] = new EntryPointExtension(project, id, parameter);
            ++i;
        }
        return result;
    }

    public EntryPointExtension(String project, String id, String parameter) {
        super(project);
        this.id = id;
        this.parameter = parameter;
    }

    public final String getId() {
        return this.id;
    }

    public final String getParameter() {
        return this.parameter;
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        int valueHashCode = this.parameter == null ? 0 : this.parameter.hashCode();
        result = prime * result + valueHashCode;
        int projectHashCode = this.project == null ? 0 : this.project.hashCode();
        result = prime * result + projectHashCode;
        return result;
    }

    public final boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null) {
            result = false;
        } else if (this.getClass() != obj.getClass()) {
            result = false;
        } else {
            result = true;
            EntryPointExtension other = (EntryPointExtension)obj;
            if (this.parameter == null) {
                if (other.parameter != null) {
                    result = false;
                }
            } else if (!this.parameter.equals(other.parameter)) {
                result = false;
            }
            if (this.project == null) {
                if (other.project != null) {
                    result = false;
                }
            } else if (!this.project.equals(other.project)) {
                result = false;
            }
        }
        return result;
    }
}

