/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class TextSizeTab
extends ExampleTab {
    private static String[] testStrings;
    private boolean propFixedSize;
    private int nextIndex = 0;
    private String labelText = "";

    public TextSizeTab(CTabFolder parent) {
        super(parent, "TextSize");
        testStrings = TextSizeTab.createTestStrings();
        this.switchText();
    }

    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createStyleButton("WRAP", 64);
        this.createFontChooser();
        final Button fixedSizeButton = this.createPropertyButton("Fixed Size");
        fixedSizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TextSizeTab.this.propFixedSize = fixedSizeButton.getSelection();
                TextSizeTab.this.createNew();
            }
        });
        Button nextButton = this.createPropertyButton("Next Text", 8);
        nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextSizeTab.this.switchText();
                TextSizeTab.this.createNew();
            }
        });
    }

    protected void createExampleControls(Composite parent) {
        int style = this.getStyle();
        Label label1 = new Label(parent, style);
        label1.setBackground(Graphics.getColor((int)204, (int)183, (int)145));
        label1.setText(this.labelText);
        label1.setLocation(10, 10);
        if (this.propFixedSize) {
            label1.setSize(label1.computeSize(200, -1));
        } else {
            label1.pack();
        }
        Text text1 = new Text(parent, style);
        text1.setBackground(Graphics.getColor((int)204, (int)183, (int)145));
        text1.setText(this.labelText);
        text1.setLocation(220, 10);
        if (this.propFixedSize) {
            text1.setSize(text1.computeSize(200, -1));
        } else {
            text1.pack();
        }
        this.registerControl((Control)label1);
    }

    private void switchText() {
        this.labelText = testStrings[this.nextIndex];
        this.nextIndex = (this.nextIndex + 1) % testStrings.length;
    }

    private static String[] createTestStrings() {
        String[] result = new String[]{"Lorem ipsum", "Lorem ipsum dolor sit amet", "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.", "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.\nUt enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.\n", "Lorem ipsum dolor sit amet, consectetur adipisici elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. ", ""};
        return result;
    }
}

