/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.fancy;

import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.internal.provisional.action.ICoolBarManager2;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.rap.internal.design.example.builder.DummyBuilder;
import org.eclipse.rap.internal.design.example.builder.FooterBuilder;
import org.eclipse.rap.internal.design.example.builder.PerspectiveSwitcherBuilder;
import org.eclipse.rap.internal.design.example.fancy.builder.HeaderBuilder;
import org.eclipse.rap.internal.design.example.managers.CoolBarManager;
import org.eclipse.rap.ui.interactiondesign.IWindowComposer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;

public class FancyWindowComposer
implements IWindowComposer {
    private static final int MARGIN = 0;
    protected Shell shell;
    private IWorkbenchWindowConfigurer configurer;
    private ApplicationWindow window;
    private Composite headerArea;
    private Composite page;
    private Composite footer;
    private Composite overflowParent;
    static /* synthetic */ Class class$0;

    public Composite createWindowContents(Shell shell, IWorkbenchWindowConfigurer configurer) {
        this.setupComponents(shell, configurer);
        this.createHeader();
        Composite menuBarComp = new Composite((Composite)shell, 0);
        menuBarComp.setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        DummyBuilder dummyBuilder = new DummyBuilder(null, "org.eclipse.rap.design.example.layoutset.menubar");
        Image bg = dummyBuilder.getImage("menubar.bg");
        menuBarComp.setBackgroundImage(bg);
        FormData fdMenuBarComp = new FormData();
        menuBarComp.setLayoutData((Object)fdMenuBarComp);
        fdMenuBarComp.top = new FormAttachment((Control)this.headerArea);
        fdMenuBarComp.left = new FormAttachment(0, 0);
        fdMenuBarComp.right = new FormAttachment(100, 0);
        if (configurer.getShowMenuBar()) {
            this.createMenuBar(menuBarComp);
        }
        Composite pageBg = new Composite((Composite)shell, 0);
        pageBg.setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        FormData fdPageBg = new FormData();
        pageBg.setLayoutData((Object)fdPageBg);
        fdPageBg.left = new FormAttachment(0, 0);
        fdPageBg.right = new FormAttachment(100, 0);
        this.attachPageBg(fdPageBg, menuBarComp);
        fdPageBg.bottom = new FormAttachment(100, 0);
        pageBg.setLayout((Layout)new FormLayout());
        this.page = new Composite(pageBg, 0);
        this.page.setLayout((Layout)new FillLayout());
        this.page.setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        FormData fdPage = new FormData();
        this.page.setLayoutData((Object)fdPage);
        fdPage.left = new FormAttachment(0, 7);
        fdPage.top = new FormAttachment(0, -5);
        fdPage.right = new FormAttachment(100, -7);
        this.createFooter(pageBg);
        fdPage.bottom = this.footer != null ? new FormAttachment((Control)this.footer, -6) : new FormAttachment(100, -6);
        shell.layout(true, true);
        return this.page;
    }

    private void createStatusLine(Composite parent) {
        parent.setLayout((Layout)new FillLayout(256));
        Control statusLineControl = this.configurer.createStatusLineControl(parent);
        final Composite statusLineComp = (Composite)statusLineControl;
        statusLineComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                FancyWindowComposer.this.styleButtons(statusLineComp.getChildren());
            }
        });
        parent.setBackgroundMode(2);
        this.styleButtons(statusLineComp.getChildren());
        statusLineControl.moveAbove((Control)parent);
    }

    private void setupComponents(Shell shell, IWorkbenchWindowConfigurer configurer) {
        this.shell = shell;
        shell.setData("org.eclipse.rwt.themeVariant", (Object)"shellGray");
        this.configurer = configurer;
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWbWindow = workbench.getActiveWorkbenchWindow();
        this.window = (ApplicationWindow)activeWbWindow;
        shell.setLayout((Layout)new FormLayout());
    }

    private void attachPageBg(FormData fdPageBg, Composite menuBarComp) {
        if (this.configurer.getShowMenuBar()) {
            fdPageBg.top = new FormAttachment((Control)menuBarComp, 10);
        } else {
            fdPageBg.top = new FormAttachment((Control)this.headerArea, 10);
            menuBarComp.setVisible(false);
        }
    }

    void createMenuBar(Composite menuBarComp) {
        MenuManager manager = this.window.getMenuBarManager();
        RowLayout layout = new RowLayout();
        layout.marginLeft = 30;
        layout.marginRight = 0;
        layout.marginTop = 3;
        menuBarComp.setLayout((Layout)layout);
        manager.fill(menuBarComp);
    }

    private void createFooter(Composite pageBg) {
        if (this.configurer.getShowStatusLine()) {
            this.footer = new Composite(pageBg, 0);
            FormData fdFooter = new FormData();
            this.footer.setLayoutData((Object)fdFooter);
            fdFooter.left = new FormAttachment(0, 9);
            fdFooter.right = new FormAttachment(100, -9);
            FooterBuilder footerBuilder = new FooterBuilder(this.footer, "org.eclipse.rap.design.example.layoutset.footer");
            footerBuilder.build();
            Composite statusLineParent = (Composite)footerBuilder.getControl();
            int offset = statusLineParent.getSize().y + 13;
            fdFooter.bottom = new FormAttachment(100, -offset);
            this.createStatusLine(statusLineParent);
        }
    }

    private void createHeader() {
        this.headerArea = new Composite((Composite)this.shell, 0);
        FormData fdHeaderArea = new FormData();
        this.headerArea.setLayoutData((Object)fdHeaderArea);
        fdHeaderArea.left = new FormAttachment(0, 0);
        fdHeaderArea.right = new FormAttachment(100, 1);
        HeaderBuilder headerBuilder = new HeaderBuilder(this.headerArea, "org.eclipse.rap.design.example.layoutset.header");
        headerBuilder.build();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Composite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.overflowParent = (Composite)headerBuilder.getAdapter(clazz);
        if (this.configurer.getShowPerspectiveBar()) {
            this.createPerspectiveBar((Composite)headerBuilder.getControl());
        }
        if (this.configurer.getShowCoolBar()) {
            this.createCoolbarArea((Composite)headerBuilder.getControl());
        }
    }

    private void createPerspectiveBar(Composite header) {
        Composite perspBar = new Composite(header, 0);
        perspBar.setLayout((Layout)new FormLayout());
        FormData fdPerspBar = new FormData();
        perspBar.setLayoutData((Object)fdPerspBar);
        fdPerspBar.left = new FormAttachment(0, 18);
        fdPerspBar.right = new FormAttachment(100, 0);
        fdPerspBar.top = new FormAttachment(0, 0);
        fdPerspBar.height = 22;
        perspBar.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        PerspectiveSwitcherBuilder perspBuilder = new PerspectiveSwitcherBuilder(perspBar, "org.eclipse.rap.design.example.layoutset.perspective");
        perspBuilder.build();
    }

    private void createCoolbarArea(Composite header) {
        ICoolBarManager manager = this.window.getCoolBarManager2();
        this.createCoolBar(manager, header);
    }

    private void createCoolBar(ICoolBarManager manager, Composite header) {
        if (manager != null) {
            Composite coolBar = new Composite(header, 0);
            coolBar.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
            FormData fdCoolBar = new FormData();
            coolBar.setLayoutData((Object)fdCoolBar);
            fdCoolBar.top = new FormAttachment(0, 70);
            fdCoolBar.left = new FormAttachment(0, 0);
            fdCoolBar.bottom = new FormAttachment(100, -22);
            fdCoolBar.right = new FormAttachment(100);
            coolBar.setLayout((Layout)new FillLayout());
            if (manager instanceof ICoolBarManager2) {
                ICoolBarManager2 coolbarManager2 = (ICoolBarManager2)manager;
                coolbarManager2.createControl2(coolBar);
                if (manager instanceof CoolBarManager) {
                    CoolBarManager coolbarManager = (CoolBarManager)manager;
                    coolbarManager.setOverflowParent(this.overflowParent);
                }
            }
        }
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
        Shell windowShell = configurer.getWindow().getShell();
        windowShell.setMaximized(true);
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
        configurer.setShellStyle(8);
    }

    private void styleButtons(Control[] buttons) {
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i] instanceof Button) {
                buttons[i].setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
            }
            ++i;
        }
    }
}

