/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.internal.design.example.stacks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.rap.internal.design.example.builder.StackPresentationBuider;
import org.eclipse.rap.internal.design.example.stacks.ConfigAction;
import org.eclipse.rap.internal.design.example.stacks.ViewToolBarRegistry;
import org.eclipse.rap.ui.interactiondesign.ConfigurableStack;
import org.eclipse.rap.ui.interactiondesign.ConfigurationAction;
import org.eclipse.rap.ui.interactiondesign.IConfigurationChangeListener;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.PartPane;
import org.eclipse.ui.internal.presentations.PresentablePart;
import org.eclipse.ui.presentations.IPartMenu;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;
import org.eclipse.ui.presentations.StackDropResult;

public class ViewStackPresentation
extends ConfigurableStack {
    private static final String VARIANT_PART_INACTIVE = "partInactive";
    private static final String VARIANT_PART_ACTIVE = "partActive";
    private static final String VARIANT_PART_INACTIVE_ACTIVE = "partInActiveActive";
    private static final int BUTTON_SPACING = 6;
    private static final String ID_CLOSE = "close";
    private static final String BUTTON_ID = "buttonId";
    private static final int WIDTH_SPACING = 65;
    private static final int HEIGHT_SPACING = 15;
    private Control presentationControl;
    private IPresentablePart currentPart;
    private ElementBuilder stackBuilder;
    private Composite tabBg;
    private Composite confArea;
    private Button confButton;
    private Label confCorner;
    private Map partButtonMap = new HashMap();
    private List partList = new ArrayList();
    private List buttonList = new ArrayList();
    private Composite toolbarBg;
    private Shell toolBarLayer;
    private int activeState = 0;
    private int state;
    protected boolean deactivated = false;
    private Button viewMenuButton;
    private Map dirtyListenerMap = new HashMap();
    private Button overflowButton;
    private List overflowButtons = new ArrayList();
    private Map buttonPartMap = new HashMap();
    private IPresentablePart oldPart;
    private boolean allActionsVisible = ConfigAction.allActionsVisible();
    static /* synthetic */ Class class$0;

    public void init() {
        ConfigurationAction action = this.getConfigAction();
        if (action != null) {
            action.addConfigurationChangeListener(new IConfigurationChangeListener(){

                public void toolBarChanged() {
                    ViewToolBarRegistry registry = ViewToolBarRegistry.getInstance();
                    registry.fireToolBarChanged();
                }

                public void presentationChanged(String newStackPresentationId) {
                }
            });
        }
        this.presentationControl = this.createStyledControl();
        ViewToolBarRegistry registry = ViewToolBarRegistry.getInstance();
        registry.addViewPartPresentation(this);
    }

    void catchToolbarChange() {
        this.layoutToolBar();
        this.setBounds(this.presentationControl.getBounds());
    }

    private void createToolBarBg() {
        Composite tabBar = this.getTabBar();
        this.toolbarBg = new Composite(tabBar.getParent(), 0);
        this.toolbarBg.setLayout((Layout)new FormLayout());
        Image bg = this.stackBuilder.getImage("stack.viewtoolbar.bg");
        this.toolbarBg.setBackgroundImage(bg);
        FormData fdToolBar = new FormData();
        this.toolbarBg.setLayoutData((Object)fdToolBar);
        fdToolBar.left = new FormAttachment(0);
        fdToolBar.right = new FormAttachment(100);
        fdToolBar.top = new FormAttachment((Control)tabBar);
        fdToolBar.height = bg.getBounds().height;
        this.toolbarBg.moveAbove((Control)tabBar);
    }

    private Control createStyledControl() {
        this.getParent().setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        final Composite parent = new Composite(this.getParent(), 0);
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ViewStackPresentation.this.setBounds(parent.getBounds());
            }
        });
        parent.setData("org.eclipse.rwt.themeVariant", (Object)"compGray");
        String setID = "org.eclipse.rap.design.example.layoutset.stack";
        this.stackBuilder = new StackPresentationBuider(parent, setID);
        this.stackBuilder.build();
        return parent;
    }

    private boolean isStandalone() {
        return this.getType().equals("standaloneview");
    }

    public void addPart(IPresentablePart newPart, Object cookie) {
        this.checkTabBg();
        if (!this.isStandalone()) {
            this.createPartButton(newPart);
            this.partList.add(newPart);
            Control partControl = newPart.getControl();
            if (partControl != null) {
                partControl.getParent().setBackgroundMode(0);
                partControl.setData("org.eclipse.rwt.themeVariant", (Object)"partBorder");
            }
            this.tabBg.layout(true);
        } else {
            this.decorateStandaloneView(newPart);
        }
        DirtyListener listener = new DirtyListener(newPart);
        this.dirtyListenerMap.put(newPart, listener);
        newPart.addPropertyListener((IPropertyListener)listener);
    }

    private void decorateStandaloneView(IPresentablePart newPart) {
        this.checkTabBg();
        if (this.getShowTitle()) {
            this.getTabBar().setVisible(true);
            this.tabBg.setVisible(true);
            Label title = new Label(this.tabBg, 0);
            title.setData("org.eclipse.rwt.themeVariant", (Object)"standaloneView");
            title.setText(newPart.getName());
            this.hideFrameLabel("topBorder");
        } else {
            this.getTabBar().setVisible(false);
            this.hideFrameLabel("left");
            this.hideFrameLabel("right");
        }
    }

    private void hideFrameLabel(String id) {
        Map map;
        Object object;
        Object labelMap;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((labelMap = this.stackBuilder.getAdapter((Class)clazz)) != null && labelMap instanceof Map && (object = (map = (Map)labelMap).get(id)) != null) {
            Label frameLabel = (Label)object;
            frameLabel.setVisible(false);
        }
    }

    private void layoutToolBar() {
        if (this.toolbarBg == null && this.tabBg != null) {
            this.createToolBarBg();
        }
        if (this.currentPart != null && this.getPartPane(this.currentPart) != null) {
            Control toolBar = this.currentPart.getToolBar();
            final IPartMenu viewMenu = this.currentPart.getMenu();
            if (viewMenu != null) {
                if (this.viewMenuButton == null) {
                    this.viewMenuButton = new Button(this.toolbarBg, 8);
                    this.viewMenuButton.setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
                    Image icon = this.stackBuilder.getImage("stack.viewmenu.icon");
                    this.viewMenuButton.setImage(icon);
                    FormData fdViewMenuButton = new FormData();
                    this.viewMenuButton.setLayoutData((Object)fdViewMenuButton);
                    fdViewMenuButton.right = new FormAttachment(100, -4);
                    fdViewMenuButton.top = new FormAttachment(0, 8);
                    this.viewMenuButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            Display display = ViewStackPresentation.this.viewMenuButton.getDisplay();
                            int height = ((ViewStackPresentation)ViewStackPresentation.this).viewMenuButton.getSize().y;
                            Point newLoc = display.map((Control)ViewStackPresentation.this.viewMenuButton, null, 0, height);
                            viewMenu.showMenu(newLoc);
                        }
                    });
                }
            } else if (this.viewMenuButton != null) {
                this.viewMenuButton.setVisible(false);
                this.viewMenuButton.dispose();
                this.viewMenuButton = null;
            }
            Point size = this.toolbarBg.getSize();
            if (toolBar != null) {
                Point point = this.currentPart.getControl().getLocation();
                point.y -= size.y + 2;
                point.x += size.x - toolBar.getSize().x;
                if (viewMenu != null) {
                    point.x -= 20;
                }
                toolBar.setLocation(point);
                this.toolbarBg.moveBelow(toolBar);
                this.presentationControl.moveBelow(toolBar);
                this.currentPart.getControl().moveBelow(toolBar);
            }
            if (toolBar != null || viewMenu != null) {
                this.toolbarBg.setVisible(true);
                if (!this.deactivated) {
                    this.getToolBarLayer();
                    if (this.toolBarLayer != null) {
                        this.toolBarLayer.setVisible(false);
                        if (this.activeState != 1) {
                            Display display = this.toolBarLayer.getDisplay();
                            Point newLocation = display.map((Control)this.toolbarBg, null, 0, 0);
                            this.toolBarLayer.setBounds(newLocation.x, newLocation.y, size.x, size.y - 1);
                            this.toolBarLayer.moveAbove(toolBar);
                            this.toolBarLayer.setVisible(true);
                        }
                    }
                }
            } else {
                this.toolbarBg.setVisible(false);
            }
            this.toolbarBg.layout(true);
        }
        this.handleConfigurationButton();
    }

    private void handleConfigurationButton() {
        PresentablePart part;
        boolean hasViewMenu = false;
        if (this.currentPart != null && this.currentPart instanceof PresentablePart && (part = (PresentablePart)this.currentPart).getPane() != null) {
            boolean hasViewActions;
            hasViewMenu = part.getPane().hasViewMenu();
            IToolBarManager manager = this.getPartToolBarManager();
            boolean bl = hasViewActions = manager != null && manager.getItems().length > 0;
            if ((hasViewActions || hasViewMenu) && !this.allActionsVisible) {
                if (this.confButton != null) {
                    this.confButton.setEnabled(true);
                    String toolTip = "Configure the actions and viewmenu from " + this.currentPart.getName();
                    this.confButton.setToolTipText(toolTip);
                }
            } else if (this.confButton != null) {
                this.confButton.setEnabled(false);
                String toolTip = String.valueOf(this.currentPart.getName()) + " has no actions or viewmenu to configure";
                this.confButton.setToolTipText(toolTip);
            }
        }
    }

    private void createPartButton(final IPresentablePart part) {
        Composite buttonArea = new Composite(this.tabBg, 0);
        buttonArea.setData("org.eclipse.rwt.themeVariant", (Object)"inactiveButton");
        buttonArea.setLayout((Layout)new FormLayout());
        final Button partButton = new Button(buttonArea, 8);
        partButton.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_PART_INACTIVE);
        partButton.setText(part.getName());
        partButton.setToolTipText(part.getTitleToolTip());
        final IPropertyListener nameListener = new IPropertyListener(){

            public void propertyChanged(Object source, int propId) {
                if (propId == 260) {
                    partButton.setText(part.getName());
                    ViewStackPresentation.this.tabBg.layout();
                } else if (propId == 1) {
                    partButton.setToolTipText(part.getTitleToolTip());
                }
            }
        };
        part.addPropertyListener(nameListener);
        partButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                partButton.removeDisposeListener((DisposeListener)this);
                part.removePropertyListener(nameListener);
            }
        });
        FormData fdPartButton = new FormData();
        partButton.setLayoutData((Object)fdPartButton);
        fdPartButton.left = new FormAttachment(0);
        fdPartButton.top = new FormAttachment(0, 4);
        fdPartButton.bottom = new FormAttachment(100);
        partButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ViewStackPresentation.this.currentPart.equals(part)) {
                    ViewStackPresentation.this.selectPart(part);
                }
                ViewStackPresentation.this.activatePart(part);
                if (ViewStackPresentation.this.toolBarLayer != null) {
                    ViewStackPresentation.this.toolBarLayer.setVisible(false);
                }
                ViewStackPresentation.this.currentPart.getControl().moveAbove(null);
                Control toolBar = ViewStackPresentation.this.currentPart.getToolBar();
                if (toolBar != null) {
                    toolBar.moveAbove(null);
                }
            }
        });
        partButton.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ViewStackPresentation.this.handleToggleZoom(part);
            }
        });
        Composite corner = new Composite(buttonArea, 0);
        corner.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
        corner.setLayout((Layout)new FormLayout());
        String separatorActive = "stack.tab.inactive.separator.active";
        Image cornerImage = this.stackBuilder.getImage(separatorActive);
        FormData fdCorner = new FormData();
        corner.setLayoutData((Object)fdCorner);
        fdCorner.right = new FormAttachment(100);
        fdCorner.bottom = new FormAttachment(100);
        fdCorner.width = cornerImage.getBounds().width;
        fdCorner.height = cornerImage.getBounds().height;
        fdPartButton.height = cornerImage.getBounds().height;
        fdPartButton.right = new FormAttachment((Control)corner, -8);
        this.partButtonMap.put(part, buttonArea);
        this.buttonPartMap.put(buttonArea, part);
        this.buttonList.add(buttonArea);
    }

    private void handleToggleZoom(IPresentablePart part) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        page.toggleZoom(this.getReference(part));
        this.handleToolbarsOnToggleZoom();
    }

    private void handleToolbarsOnToggleZoom() {
        ViewToolBarRegistry registry = ViewToolBarRegistry.getInstance();
        if (this.state == 1) {
            registry.moveAllToolbarsBellow(null);
        } else if (this.state == 2) {
            registry.fireToolBarChanged();
        }
        if (this.toolBarLayer != null) {
            this.toolBarLayer.setVisible(false);
        }
        if (this.currentPart != null) {
            this.currentPart.getControl().moveAbove(null);
            Control toolBar = this.currentPart.getToolBar();
            if (toolBar != null) {
                toolBar.moveAbove(null);
            }
        }
    }

    public void hideAllToolBars(Control control) {
        int i = 0;
        while (i < this.partList.size()) {
            IPresentablePart part = (IPresentablePart)this.partList.get(i);
            Control toolBar = part.getToolBar();
            if (toolBar != null) {
                toolBar.moveBelow(control);
            }
            ++i;
        }
    }

    protected void activatePart(IPresentablePart part) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = window.getActivePage();
        IWorkbenchPart workbenchPart = this.getReference(part).getPart(true);
        if (workbenchPart != null) {
            Control toolBar;
            if (this.oldPart != null && (toolBar = this.oldPart.getToolBar()) != null) {
                toolBar.setVisible(false);
            }
            activePage.activate(workbenchPart);
        }
    }

    private IWorkbenchPartReference getReference(IPresentablePart part) {
        IWorkbenchPartReference result = null;
        if (part instanceof PresentablePart) {
            PresentablePart presentablePart = (PresentablePart)part;
            PartPane pane = presentablePart.getPane();
            result = pane.getPartReference();
        }
        return result;
    }

    private void makePartButtonActive(final IPresentablePart part) {
        Object object = this.partButtonMap.get(part);
        if (object instanceof Composite) {
            Composite buttonArea = (Composite)object;
            buttonArea.setData("org.eclipse.rwt.themeVariant", (Object)"tabInactive");
            this.checkHideSeparator(buttonArea);
            Color bg = this.stackBuilder.getColor("stack.button.inactive");
            buttonArea.setBackground(bg);
            Control[] children = buttonArea.getChildren();
            buttonArea.setLayout((Layout)new FormLayout());
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child instanceof Button) {
                    Button partButton = (Button)child;
                    partButton.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_PART_ACTIVE);
                    FormData fdButton = (FormData)partButton.getLayoutData();
                    FormData pos = this.stackBuilder.getPosition("stack.button.top");
                    fdButton.top = pos.top;
                } else if (child instanceof Composite) {
                    Composite corner = (Composite)child;
                    corner.setVisible(true);
                    String cornerDesc = "stack.inactive.corner.inactive";
                    Image cornerImage = this.stackBuilder.getImage(cornerDesc);
                    corner.setBackgroundImage(null);
                    FormData fdCorner = (FormData)corner.getLayoutData();
                    fdCorner.top = new FormAttachment(0);
                    fdCorner.width = cornerImage.getBounds().width;
                    fdCorner.height = cornerImage.getBounds().height;
                    if (part.isCloseable()) {
                        Button close = new Button(buttonArea, 8);
                        close.setData(BUTTON_ID, (Object)ID_CLOSE);
                        close.setData("org.eclipse.rwt.themeVariant", (Object)"viewCloseInactive");
                        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                IStackPresentationSite site = ViewStackPresentation.this.getSite();
                                if (site.isCloseable(part)) {
                                    site.close(new IPresentablePart[]{part});
                                    ViewStackPresentation.this.showPartButton(ViewStackPresentation.this.currentPart);
                                }
                            }
                        });
                        FormData fdClose = new FormData();
                        close.setLayoutData((Object)fdClose);
                        fdClose.right = new FormAttachment(100, -5);
                        fdClose.top = new FormAttachment(0, 6);
                        fdClose.width = 7;
                        fdClose.height = 8;
                        close.setLayoutData((Object)fdClose);
                        close.moveAbove((Control)corner);
                    }
                }
                ++i;
            }
            buttonArea.getParent().layout();
            this.preventButtonOfOverflow();
        }
    }

    private void preventButtonOfOverflow() {
        if (this.isOverflowNecessary()) {
            this.showPartButton(this.currentPart);
        }
    }

    private void checkHideSeparator(Composite buttonArea) {
        int indexOf = this.buttonList.indexOf(buttonArea);
        int i = 0;
        while (i < this.buttonList.size()) {
            Composite area = (Composite)this.buttonList.get(i);
            Control[] children = area.getChildren();
            int j = 0;
            while (j < children.length) {
                if (children[j] instanceof Composite) {
                    if (i == indexOf || i == indexOf - 1) {
                        ((Composite)children[j]).setVisible(false);
                    } else {
                        ((Composite)children[j]).setVisible(true);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void makePartButtonInactive(IPresentablePart part) {
        Object object = this.partButtonMap.get(part);
        if (object instanceof Composite) {
            Composite buttonArea = (Composite)object;
            buttonArea.setData("org.eclipse.rwt.themeVariant", (Object)"inactiveButton");
            buttonArea.setBackground(null);
            Control[] children = buttonArea.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child instanceof Button) {
                    Button button = (Button)child;
                    if (button.getData(BUTTON_ID) != null) {
                        button.setVisible(false);
                        button.dispose();
                    } else {
                        button.setData("org.eclipse.rwt.themeVariant", (Object)VARIANT_PART_INACTIVE);
                        FormData fdButton = (FormData)button.getLayoutData();
                        fdButton.top = new FormAttachment(0, 0);
                    }
                } else if (child instanceof Composite) {
                    Composite corner = (Composite)child;
                    corner.setVisible(true);
                    String sepConst = "stack.tab.inactive.separator.active";
                    Image cornerImage = this.stackBuilder.getImage(sepConst);
                    corner.setBackgroundImage(cornerImage);
                    FormData fdCorner = (FormData)corner.getLayoutData();
                    fdCorner.width = cornerImage.getBounds().width;
                    fdCorner.height = cornerImage.getBounds().height;
                    fdCorner.top = new FormAttachment(0, 6);
                }
                ++i;
            }
            buttonArea.getParent().layout();
        }
    }

    private void checkTabBg() {
        Composite tabBar = this.getTabBar();
        if (this.tabBg == null && tabBar != null) {
            this.tabBg = new Composite(tabBar, 0);
            this.tabBg.setData("org.eclipse.rwt.themeVariant", (Object)"compTrans");
            FormData fdTabBg = new FormData();
            this.tabBg.setLayoutData((Object)fdTabBg);
            fdTabBg.left = new FormAttachment(0);
            fdTabBg.top = new FormAttachment(0);
            fdTabBg.bottom = new FormAttachment(100);
            this.createConfArea(fdTabBg);
            FormData fdLayout = this.stackBuilder.getPosition("stack.tabbg.pos");
            RowLayout layout = new RowLayout(256);
            layout.spacing = 0;
            layout.marginBottom = 0;
            if (!this.isStandalone()) {
                layout.marginHeight = 0;
                layout.marginLeft = fdLayout.width;
            } else {
                layout.marginHeight = 4;
                layout.marginLeft = 6;
            }
            layout.marginRight = 16;
            layout.marginTop = fdLayout.height;
            layout.marginWidth = 0;
            layout.wrap = false;
            this.tabBg.setLayout((Layout)layout);
            this.presentationControl.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    ViewStackPresentation.this.manageOverflow();
                }
            });
        }
    }

    private void manageOverflow() {
        if (this.isOverflowNecessary()) {
            this.hideLastVisibleButton();
            this.manageOverflow();
        } else {
            this.showLastChildIfNecessary(0);
        }
        this.handleOverflowButton();
    }

    private boolean isOverflowNecessary() {
        boolean childrenBiggerThanParent;
        int tabChildrenSize = this.getTabChildrenSize();
        boolean bl = childrenBiggerThanParent = tabChildrenSize > this.tabBg.getBounds().width;
        return childrenBiggerThanParent && this.moreThanOneChildVisible();
    }

    private boolean moreThanOneChildVisible() {
        boolean result = false;
        Control[] children = this.tabBg.getChildren();
        int visibleChilds = 0;
        int i = 0;
        while (i < children.length && !result) {
            if (children[i].isVisible() && ++visibleChilds > 1) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private void handleOverflowButton() {
        if (this.overflowButton == null) {
            this.overflowButton = new Button(this.tabBg.getParent(), 8);
            String stackOverflowPosition = "stack.overflow.pos";
            FormData fdOverflowButton = this.stackBuilder.getPosition(stackOverflowPosition);
            this.overflowButton.setLayoutData((Object)fdOverflowButton);
            String stackTabOverflowActive = "stack.tab.overflow.active";
            Image icon = this.stackBuilder.getImage(stackTabOverflowActive);
            fdOverflowButton.height = icon.getBounds().height;
            fdOverflowButton.width = icon.getBounds().width;
            String variant = "tabOverflowInactive";
            if (this.activeState == 1) {
                variant = "tabOverflowActive";
            }
            this.overflowButton.setData("org.eclipse.rwt.themeVariant", (Object)variant);
            this.overflowButton.moveAbove((Control)this.tabBg);
            this.overflowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewStackPresentation.this.performOverflow();
                }
            });
        }
        if (this.tabBgHasInvisibleButtons()) {
            this.overflowButton.setVisible(true);
        } else {
            this.overflowButton.setVisible(false);
        }
    }

    private void performOverflow() {
        this.activatePart(this.currentPart);
        Menu overflowMenu = new Menu((Control)this.overflowButton);
        int i = 0;
        while (i < this.overflowButtons.size()) {
            Object obj = this.buttonPartMap.get(this.overflowButtons.get(i));
            final IPresentablePart part = (IPresentablePart)obj;
            MenuItem item = new MenuItem(overflowMenu, 8);
            if (part != null) {
                item.setText(part.getName());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        ViewStackPresentation.this.activatePart(part);
                        ViewStackPresentation.this.showPartButton(part);
                    }
                });
            }
            ++i;
        }
        this.overflowButton.setMenu(overflowMenu);
        overflowMenu.setVisible(true);
        Display display = this.overflowButton.getDisplay();
        Point newLocation = display.map((Control)this.overflowButton, null, 0, 10);
        overflowMenu.setLocation(newLocation);
    }

    private void showPartButton(IPresentablePart part) {
        Control button = (Control)this.partButtonMap.get(part);
        Control hiddenButton = this.hideLastVisibleButton();
        if (button != null && !button.isDisposed()) {
            button.setVisible(true);
            this.overflowButtons.remove(button);
            button.moveAbove(hiddenButton);
            this.tabBg.layout(true, true);
            this.manageOverflow();
        }
    }

    private void showLastChildIfNecessary(int recursionCount) {
        Control childToShow = this.getLastInvisibleButton();
        if (childToShow != null && this.futureTabChildrenSize(childToShow) < this.tabBg.getBounds().width && this.tabBgHasInvisibleButtons()) {
            childToShow.setVisible(true);
            IPresentablePart part = (IPresentablePart)this.buttonPartMap.get(childToShow);
            this.makePartButtonInactive(part);
            this.overflowButtons.remove(childToShow);
            this.tabBg.layout(true, true);
            if (recursionCount <= this.tabBg.getChildren().length) {
                int newCount = recursionCount + 1;
                this.showLastChildIfNecessary(newCount);
            }
        }
    }

    private boolean tabBgHasInvisibleButtons() {
        boolean result = false;
        Control[] children = this.tabBg.getChildren();
        int i = 0;
        while (i < children.length && !result) {
            if (!children[i].isVisible()) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private int futureTabChildrenSize(Control childToShow) {
        int result = 0;
        result = this.getTabChildrenSize();
        return result += childToShow.getBounds().width;
    }

    private Control getLastInvisibleButton() {
        Control result = null;
        Control[] children = this.tabBg.getChildren();
        boolean childShowedUp = false;
        int i = children.length - 1;
        while (i >= 0 && !childShowedUp) {
            if (children[i].isVisible()) {
                result = children.length >= i + 2 ? children[i + 1] : children[i];
                childShowedUp = true;
            }
            --i;
        }
        return result;
    }

    private Control hideLastVisibleButton() {
        Control result = null;
        if (this.tabBg != null && !this.tabBg.isDisposed()) {
            Control[] children = this.tabBg.getChildren();
            boolean lastChildHidden = false;
            int i = children.length - 1;
            while (i >= 0 && !lastChildHidden) {
                if (children[i].isVisible()) {
                    if (this.isButtonActive(children[i])) {
                        if (i > 0) {
                            children[i - 1].setVisible(false);
                            result = children[i - 1];
                            if (!this.overflowButtons.contains(children[i - 1])) {
                                this.overflowButtons.add(children[i - 1]);
                            }
                            children[i].moveAbove(children[i - 1]);
                        }
                    } else {
                        children[i].setVisible(false);
                        result = children[i];
                        this.overflowButtons.add(children[i]);
                    }
                    lastChildHidden = true;
                    this.tabBg.layout(true, true);
                }
                --i;
            }
        }
        return result;
    }

    private boolean isButtonActive(Control control) {
        boolean result = false;
        if (control instanceof Composite) {
            Composite buttonArea = (Composite)control;
            Control[] children = buttonArea.getChildren();
            int i = 0;
            while (i < children.length && !result) {
                Object data;
                if (children[i] instanceof Button && ((data = children[i].getData("org.eclipse.rwt.themeVariant")).equals(VARIANT_PART_INACTIVE_ACTIVE) || data.equals(VARIANT_PART_ACTIVE))) {
                    result = true;
                }
                ++i;
            }
        }
        return result;
    }

    private int getTabChildrenSize() {
        int result = 0;
        Control[] children = this.tabBg.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].isVisible() && !children[i].isDisposed()) {
                result += children[i].getSize().x + 6;
            }
            ++i;
        }
        return result;
    }

    private void createConfArea(FormData fdTabBg) {
        final ConfigurationAction configAction = this.getConfigAction();
        if (configAction != null) {
            this.confArea = new Composite(this.getTabBar(), 0);
            Image confBg = this.stackBuilder.getImage("stack.conf.bg.inactive");
            this.confArea.setBackgroundImage(confBg);
            this.confArea.setLayout((Layout)new FormLayout());
            this.confArea.setBackgroundMode(2);
            FormData fdConfArea = new FormData();
            this.confArea.setLayoutData((Object)fdConfArea);
            fdConfArea.top = new FormAttachment(0);
            fdConfArea.bottom = new FormAttachment(100);
            fdConfArea.right = new FormAttachment(100);
            fdConfArea.width = 28;
            fdTabBg.right = new FormAttachment((Control)this.confArea);
            this.confCorner = new Label(this.confArea, 0);
            Image cornerImage = this.stackBuilder.getImage("stack.corner.inactive");
            this.confCorner.setImage(cornerImage);
            FormData fdCorner = new FormData();
            this.confCorner.setLayoutData((Object)fdCorner);
            fdCorner.left = new FormAttachment(0);
            fdCorner.top = new FormAttachment(0);
            fdCorner.bottom = new FormAttachment(100);
            this.confButton = new Button(this.confArea, 8);
            Image confImage = this.stackBuilder.getImage("stack.conf.inactive");
            this.confButton.setImage(confImage);
            this.confButton.setData("org.eclipse.rwt.themeVariant", (Object)"clearButton");
            FormData fdConfButton = this.stackBuilder.getPosition("stack.conf.position");
            this.confButton.setLayoutData((Object)fdConfButton);
            FormData fdConfPos = this.stackBuilder.getPosition("stack.conf.pos");
            fdConfButton.right = fdConfPos.right;
            this.confButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ViewStackPresentation.this.activatePart(ViewStackPresentation.this.getSite().getSelectedPart());
                    configAction.run();
                }
            });
        } else {
            fdTabBg.right = new FormAttachment(100);
        }
    }

    public void dispose() {
        ViewToolBarRegistry registry = ViewToolBarRegistry.getInstance();
        registry.removeViewPartPresentation(this);
        if (this.toolBarLayer != null) {
            this.toolBarLayer.dispose();
        }
        this.presentationControl.dispose();
    }

    public Control getControl() {
        return this.presentationControl;
    }

    public Control[] getTabList(IPresentablePart part) {
        ArrayList<Control> list = new ArrayList<Control>();
        if (this.getControl() != null) {
            list.add(this.getControl());
        }
        if (part.getToolBar() != null) {
            list.add(part.getToolBar());
        }
        if (part.getControl() != null) {
            list.add(part.getControl());
        }
        return list.toArray(new Control[list.size()]);
    }

    public void removePart(IPresentablePart oldPart) {
        Object listener;
        Object object = this.partButtonMap.get(oldPart);
        this.buttonPartMap.remove(object);
        if (this.toolBarLayer != null) {
            this.toolBarLayer.setVisible(false);
        }
        if ((listener = this.dirtyListenerMap.get(oldPart)) != null && listener instanceof IPropertyListener) {
            oldPart.removePropertyListener((IPropertyListener)listener);
        }
        this.partButtonMap.remove(oldPart);
        this.buttonList.remove(object);
        this.handleButtonDispose(object);
        this.partList.remove(oldPart);
        oldPart.setVisible(false);
        this.tabBg.layout();
    }

    private void handleButtonDispose(Object buttonArea) {
        if (buttonArea != null && !this.isStandalone()) {
            ((Composite)buttonArea).dispose();
        }
    }

    public void selectPart(IPresentablePart toSelect) {
        if (toSelect != null) {
            toSelect.setVisible(true);
        }
        if (this.currentPart != null) {
            this.oldPart = this.currentPart;
            if (this.currentPart instanceof PresentablePart && ((PresentablePart)this.currentPart).getPane() != null) {
                this.currentPart.setVisible(false);
            }
        }
        this.makePartButtonInactive(this.currentPart);
        this.currentPart = toSelect;
        this.currentPart.getControl().moveAbove(null);
        this.makePartButtonActive(this.currentPart);
        this.setBounds(this.presentationControl.getBounds());
        if (this.toolBarLayer != null) {
            this.toolBarLayer.setVisible(false);
        }
    }

    public StackDropResult dragOver(Control currentControl, Point location) {
        return null;
    }

    public void setActive(int newState) {
        this.activeState = newState;
        Image confBg = null;
        Image cornerImage = null;
        Image confImage = null;
        Image tabBgImage = null;
        String tabOverflow = "tabOverflowInactive";
        if (newState == 1) {
            if (!this.isStandalone()) {
                this.changeSelectedActiveButton(true);
            }
            confBg = this.stackBuilder.getImage("stack.conf.bg.active");
            String rightActive = "stack.tab.inactive.right.active";
            cornerImage = this.stackBuilder.getImage(rightActive);
            confImage = this.stackBuilder.getImage("stack.conf.active");
            tabOverflow = "tabOverflowActive";
            tabBgImage = this.stackBuilder.getImage("stack.tab.bg.active");
            this.changeStack(true);
        } else {
            if (!this.isStandalone()) {
                this.changeSelectedActiveButton(false);
            }
            confBg = this.stackBuilder.getImage("stack.conf.bg.inactive");
            cornerImage = this.stackBuilder.getImage("stack.corner.inactive");
            confImage = this.stackBuilder.getImage("stack.conf.inactive");
            String stackTabInactiveBgActive = "stack.tab.inactive.bg.act";
            tabBgImage = this.stackBuilder.getImage(stackTabInactiveBgActive);
            this.changeStack(false);
        }
        if (this.tabBg != null) {
            this.tabBg.getParent().setBackgroundImage(tabBgImage);
        }
        if (this.confArea != null) {
            this.confArea.setBackgroundImage(confBg);
            if (this.confCorner != null) {
                this.confCorner.setImage(cornerImage);
            }
            if (this.confButton != null) {
                this.confButton.setImage(confImage);
            }
            this.confArea.getParent().layout(true);
            if (this.currentPart != null && this.getPartPane(this.currentPart) != null) {
                this.currentPart.setVisible(true);
            }
            this.confArea.layout(true);
        }
        if (this.overflowButton != null) {
            this.overflowButton.setData("org.eclipse.rwt.themeVariant", (Object)tabOverflow);
        }
        this.setBounds(this.presentationControl.getBounds());
    }

    private void changeStack(boolean active) {
        Object adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.Map");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = this.stackBuilder.getAdapter((Class)clazz)) != null && adapter instanceof Map) {
            Image topBorderImg;
            Image rightBorderImg;
            Image leftBorderImg;
            Image bottomBorderImg;
            Image right;
            Image left;
            Map labelMap = (Map)adapter;
            Label leftLabel = (Label)labelMap.get("left");
            Label rightLabel = (Label)labelMap.get("right");
            Label leftBorder = (Label)labelMap.get("leftBorder");
            Label rightBorder = (Label)labelMap.get("rightBorder");
            Label bottomBorder = (Label)labelMap.get("bottomBorder");
            Label topBorder = (Label)labelMap.get("topBorder");
            if (active) {
                String leftActive = "stack.tabbar.left.active";
                left = this.stackBuilder.getImage(leftActive);
                String rightActive = "stack.tabbar.right.active";
                right = this.stackBuilder.getImage(rightActive);
                String bottomActive = "stack.border.bottom.active";
                bottomBorderImg = this.stackBuilder.getImage(bottomActive);
                String leftBorderActive = "stack.border.left.active";
                leftBorderImg = this.stackBuilder.getImage(leftBorderActive);
                String rightBorderActive = "stack.border.right.active";
                rightBorderImg = this.stackBuilder.getImage(rightBorderActive);
                String stackTopStandaloneActive = "stack.top.standalone.active";
                topBorderImg = this.stackBuilder.getImage(stackTopStandaloneActive);
            } else {
                String leftInactive = "stack.tabbar.left.inactive";
                left = this.stackBuilder.getImage(leftInactive);
                String rightInactive = "stack.tabbar.right.inactive";
                right = this.stackBuilder.getImage(rightInactive);
                bottomBorderImg = this.stackBuilder.getImage("stack.border.bottom");
                leftBorderImg = this.stackBuilder.getImage("stack.border.left");
                rightBorderImg = this.stackBuilder.getImage("stack.border.right");
                String stackTopStandaloneInactive = "stack.top.standalone.inactive";
                topBorderImg = this.stackBuilder.getImage(stackTopStandaloneInactive);
            }
            leftLabel.setImage(left);
            rightLabel.setImage(right);
            leftBorder.setBackgroundImage(leftBorderImg);
            rightBorder.setBackgroundImage(rightBorderImg);
            bottomBorder.setBackgroundImage(bottomBorderImg);
            if (this.isStandalone() && topBorderImg != null) {
                topBorder.setBackgroundImage(topBorderImg);
                int height = topBorderImg.getBounds().height;
                FormData fdTopBorder = (FormData)topBorder.getLayoutData();
                fdTopBorder.height = height;
                fdTopBorder.top = new FormAttachment(0, 7);
                FormData fdLeftBorder = (FormData)leftBorder.getLayoutData();
                FormData fdRightBorder = (FormData)rightBorder.getLayoutData();
                fdLeftBorder.top = new FormAttachment(0, height + 6);
                fdRightBorder.top = new FormAttachment(0, height + 6);
                topBorder.getParent().layout(true);
                topBorder.moveAbove(null);
            }
        }
    }

    private PartPane getPartPane(IPresentablePart part) {
        PartPane result = null;
        if (part instanceof PresentablePart) {
            result = ((PresentablePart)part).getPane();
        }
        return result;
    }

    private void changeSelectedActiveButton(boolean selected) {
        Color buttonAreaBg;
        String close = "";
        String font = "";
        String tab = "";
        if (selected) {
            buttonAreaBg = this.stackBuilder.getColor("stack.button.active");
            close = "viewClose";
            font = VARIANT_PART_INACTIVE_ACTIVE;
            tab = "tabActive";
        } else {
            buttonAreaBg = this.stackBuilder.getColor("stack.button.inactive");
            close = "viewCloseInactive";
            font = VARIANT_PART_ACTIVE;
            tab = "tabInactive";
        }
        Object object = this.partButtonMap.get(this.currentPart);
        if (object != null && object instanceof Composite) {
            Composite buttonArea = (Composite)object;
            buttonArea.setData("org.eclipse.rwt.themeVariant", (Object)tab);
            buttonArea.setBackground(buttonAreaBg);
            Control[] children = buttonArea.getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                if (child instanceof Button) {
                    Button button = (Button)child;
                    if (button.getData(BUTTON_ID) != null) {
                        button.setData("org.eclipse.rwt.themeVariant", (Object)close);
                    } else {
                        button.setData("org.eclipse.rwt.themeVariant", (Object)font);
                    }
                }
                ++i;
            }
        }
    }

    public void setBounds(Rectangle bounds) {
        this.presentationControl.setBounds(bounds);
        Composite tabBar = this.getTabBar();
        if (this.currentPart != null && tabBar != null && this.getPartPane(this.currentPart) != null) {
            String stackTopStandaloneActive;
            Image stackTop;
            int newHeight = bounds.height - 16;
            int partBoundsY = bounds.y + 8;
            if (this.getTabBar().isVisible()) {
                newHeight -= tabBar.getBounds().height;
                partBoundsY += tabBar.getBounds().height;
            }
            Control toolBar = this.currentPart.getToolBar();
            if (this.toolbarBg != null && (this.toolbarBg.isVisible() || toolBar != null)) {
                int toolbarHeight = this.toolbarBg.getBounds().height;
                newHeight -= toolbarHeight;
                partBoundsY += toolbarHeight;
            }
            if ((stackTop = this.stackBuilder.getImage(stackTopStandaloneActive = "stack.top.standalone.active")) != null) {
                ++partBoundsY;
                --newHeight;
            }
            Rectangle partBounds = new Rectangle(bounds.x + 8, partBoundsY, bounds.width - 16, newHeight);
            this.currentPart.setBounds(partBounds);
        }
        this.layoutToolBar();
    }

    private Shell getToolBarLayer() {
        if (this.toolBarLayer == null && this.toolbarBg != null) {
            this.toolBarLayer = new Shell(this.toolbarBg.getShell(), 8);
            this.toolBarLayer.setData("org.eclipse.rwt.themeVariant", (Object)"toolbarLayer");
            this.toolBarLayer.setAlpha(200);
            this.toolBarLayer.addListener(3, new Listener(){

                public void handleEvent(Event event) {
                    ViewStackPresentation.this.activatePart(ViewStackPresentation.this.currentPart);
                }
            });
        }
        return this.toolBarLayer;
    }

    private Composite getTabBar() {
        Composite result = null;
        Object adapter = this.stackBuilder.getAdapter(((Object)((Object)this)).getClass());
        if (adapter != null && adapter instanceof Composite) {
            result = (Composite)adapter;
        }
        return result;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setVisible(boolean isVisible) {
        if (this.currentPart != null && this.getPartPane(this.currentPart) != null) {
            this.currentPart.setVisible(isVisible);
            this.deactivated = !isVisible;
            this.layoutToolBar();
            if (this.toolBarLayer != null && !isVisible) {
                this.toolBarLayer.setVisible(false);
            }
            this.setBounds(this.presentationControl.getBounds());
        }
    }

    public void showPaneMenu() {
    }

    public void showSystemMenu() {
    }

    public int computePreferredSize(boolean width, int availableParallel, int availablePerpendicular, int preferredResult) {
        int result = preferredResult;
        if (width) {
            int minWidth = this.calculateMinimumWidth();
            if (this.getSite().getState() == 0 || preferredResult < minWidth) {
                result = minWidth;
            }
        } else {
            result = this.calculateMinimumHeight();
        }
        return result;
    }

    private int calculateMinimumHeight() {
        int result = 0;
        if (this.tabBg != null) {
            this.tabBg.pack();
            result = this.tabBg.getSize().y;
        }
        return result + 15;
    }

    private int calculateMinimumWidth() {
        int result = 0;
        if (this.tabBg != null) {
            Control[] children = this.tabBg.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i].getSize().x >= result) {
                    result = children[i].getSize().x;
                }
                ++i;
            }
        }
        return result + 65;
    }

    private class DirtyListener
    implements IPropertyListener {
        private IPresentablePart part;

        public DirtyListener(IPresentablePart part) {
            this.part = part;
        }

        public void propertyChanged(Object source, int propId) {
            Button partButton;
            if (propId == 257 && (partButton = this.getPartButton(this.part)) != null) {
                String text = partButton.getText();
                char lastCharacter = this.getLastCharacter(text);
                if (this.part.isDirty()) {
                    if (lastCharacter != '*') {
                        text = String.valueOf(text) + "*";
                    }
                } else if (lastCharacter == '*') {
                    text = text.substring(0, text.length() - 1);
                }
                partButton.setText(text);
            }
        }

        private Button getPartButton(IPresentablePart part) {
            Control[] children;
            Button result = null;
            Object object = ViewStackPresentation.this.partButtonMap.get(part);
            if (object instanceof Composite && (children = ((Composite)object).getChildren()).length > 0 && children[0] instanceof Button) {
                result = (Button)children[0];
            }
            return result;
        }

        private char getLastCharacter(String text) {
            char[] starArray = new char[1];
            text.getChars(text.length() - 1, text.length(), starArray, 0);
            return starArray[0];
        }
    }
}

