/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.scrolledcompositekit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Widget;

public final class ScrolledCompositeLCA
extends AbstractWidgetLCA {
    private static final String QX_TYPE = "org.eclipse.swt.custom.ScrolledComposite";
    private static final Integer ZERO = new Integer(0);
    private static final String PARAM_H_BAR_SELECTION = "horizontalBar.selection";
    private static final String PARAM_V_BAR_SELECTION = "verticalBar.selection";
    static final String PROP_BOUNDS = "clientArea";
    static final String PROP_OVERFLOW = "overflow";
    private static final String PROP_H_BAR_SELECTION = "hBarSelection";
    private static final String PROP_V_BAR_SELECTION = "vBarSelection";
    private static final String PROP_SHOW_FOCUSED_CONTROL = "showFocusedControl";

    public void preserveValues(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.preserveValues((Control)composite);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)composite);
        adapter.preserve(PROP_BOUNDS, (Object)composite.getBounds());
        adapter.preserve(PROP_OVERFLOW, (Object)ScrolledCompositeLCA.getOverflow(composite));
        adapter.preserve(PROP_H_BAR_SELECTION, (Object)ScrolledCompositeLCA.getBarSelection(composite.getHorizontalBar()));
        adapter.preserve(PROP_V_BAR_SELECTION, (Object)ScrolledCompositeLCA.getBarSelection(composite.getVerticalBar()));
        adapter.preserve("selectionListeners", (Object)ScrolledCompositeLCA.hasSelectionListener(composite));
        adapter.preserve(PROP_SHOW_FOCUSED_CONTROL, (Object)composite.getShowFocusedControl());
        WidgetLCAUtil.preserveCustomVariant((Widget)composite);
    }

    public void readData(Widget widget) {
        ScrolledComposite composite = (ScrolledComposite)widget;
        Point origin = composite.getOrigin();
        String value = WidgetLCAUtil.readPropertyValue(widget, PARAM_H_BAR_SELECTION);
        ScrollBar hScroll = composite.getHorizontalBar();
        if (value != null && hScroll != null) {
            origin.x = Integer.parseInt(value);
            ScrolledCompositeLCA.processSelection(hScroll);
        }
        value = WidgetLCAUtil.readPropertyValue(widget, PARAM_V_BAR_SELECTION);
        ScrollBar vScroll = composite.getVerticalBar();
        if (value != null && vScroll != null) {
            origin.y = Integer.parseInt(value);
            ScrolledCompositeLCA.processSelection(vScroll);
        }
        composite.setOrigin(origin);
        ControlLCAUtil.processMouseEvents((Control)composite);
        ControlLCAUtil.processKeyEvents((Control)composite);
        ControlLCAUtil.processMenuDetect((Control)composite);
        WidgetLCAUtil.processHelp((Widget)composite);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ScrolledComposite scrolledComposite = (ScrolledComposite)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)scrolledComposite);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)scrolledComposite);
    }

    public void renderChanges(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        ControlLCAUtil.writeChanges((Control)composite);
        ScrolledCompositeLCA.writeClipBounds(composite);
        ScrolledCompositeLCA.writeBarSelection(composite);
        ScrolledCompositeLCA.writeScrollBars(composite);
        ScrolledCompositeLCA.writeSelectionListener(composite);
        ScrolledCompositeLCA.writeShowFocusedControl(composite);
        WidgetLCAUtil.writeCustomVariant((Widget)composite);
    }

    public void renderDispose(Widget widget) throws IOException {
        ScrolledComposite composite = (ScrolledComposite)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)composite);
        writer.dispose();
    }

    private static void writeScrollBars(ScrolledComposite composite) throws IOException {
        String overflow = ScrolledCompositeLCA.getOverflow(composite);
        JSWriter writer = JSWriter.getWriterFor((Widget)composite);
        writer.set(PROP_OVERFLOW, PROP_OVERFLOW, overflow, null);
    }

    private static void writeBarSelection(ScrolledComposite composite) throws IOException {
        Integer vBarSelection;
        JSWriter writer = JSWriter.getWriterFor((Widget)composite);
        Integer hBarSelection = ScrolledCompositeLCA.getBarSelection(composite.getHorizontalBar());
        if (hBarSelection != null) {
            writer.set(PROP_H_BAR_SELECTION, PROP_H_BAR_SELECTION, hBarSelection, ZERO);
        }
        if ((vBarSelection = ScrolledCompositeLCA.getBarSelection(composite.getVerticalBar())) != null) {
            writer.set(PROP_V_BAR_SELECTION, PROP_V_BAR_SELECTION, vBarSelection, ZERO);
        }
    }

    private static void writeClipBounds(ScrolledComposite composite) throws IOException {
        Rectangle bounds = composite.getBounds();
        if (WidgetLCAUtil.hasChanged((Widget)composite, PROP_BOUNDS, bounds, null)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)composite);
            writer.set("clipWidth", bounds.width);
            writer.set("clipHeight", bounds.height);
        }
    }

    private static void writeSelectionListener(ScrolledComposite composite) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = ScrolledCompositeLCA.hasSelectionListener(composite);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)composite, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)composite);
            writer.set("hasSelectionListener", newValue);
        }
    }

    private static void writeShowFocusedControl(ScrolledComposite composite) throws IOException {
        String prop = PROP_SHOW_FOCUSED_CONTROL;
        Boolean newValue = composite.getShowFocusedControl();
        if (WidgetLCAUtil.hasChanged((Widget)composite, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)composite);
            writer.set(PROP_SHOW_FOCUSED_CONTROL, newValue);
        }
    }

    private static String getOverflow(ScrolledComposite composite) {
        boolean scrollY;
        ScrollBar horizontalBar = composite.getHorizontalBar();
        boolean scrollX = horizontalBar != null && horizontalBar.getVisible();
        ScrollBar verticalBar = composite.getVerticalBar();
        boolean bl = scrollY = verticalBar != null && verticalBar.getVisible();
        String result = scrollX && scrollY ? "scroll" : (scrollX ? "scrollX" : (scrollY ? "scrollY" : "hidden"));
        return result;
    }

    private static Integer getBarSelection(ScrollBar scrollBar) {
        Integer result = scrollBar != null ? new Integer(scrollBar.getSelection()) : null;
        return result;
    }

    private static boolean hasSelectionListener(ScrolledComposite composite) {
        ScrollBar verticalBar;
        boolean result = false;
        ScrollBar horizontalBar = composite.getHorizontalBar();
        if (horizontalBar != null) {
            boolean bl = result = result || SelectionEvent.hasListener((Adaptable)horizontalBar);
        }
        if ((verticalBar = composite.getVerticalBar()) != null) {
            result = result || SelectionEvent.hasListener((Adaptable)verticalBar);
        }
        return result;
    }

    private static void processSelection(ScrollBar scrollBar) {
        SelectionEvent evt = new SelectionEvent((Widget)scrollBar, null, 13);
        evt.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
        evt.processEvent();
    }
}

