/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.linkkit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ILinkAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Widget;

public class LinkLCA
extends AbstractWidgetLCA {
    private static final String JS_FUNC_ADDTEXT = "addText";
    private static final String JS_FUNC_ADDLINK = "addLink";
    private static final String JS_FUNC_APPLYTEXT = "applyText";
    private static final String JS_FUNC_CLEAR = "clear";
    private static final String PROP_TEXT = "text";
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        Link link = (Link)widget;
        ControlLCAUtil.preserveValues((Control)link);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_TEXT, (Object)link.getText());
        boolean hasListeners = SelectionEvent.hasListener((Adaptable)link);
        adapter.preserve("selectionListeners", (Object)hasListeners);
        WidgetLCAUtil.preserveCustomVariant((Widget)link);
    }

    public void readData(Widget widget) {
        Link link = (Link)widget;
        LinkLCA.processSelectionEvent(link);
        ControlLCAUtil.processMouseEvents((Control)link);
        ControlLCAUtil.processKeyEvents((Control)link);
        ControlLCAUtil.processMenuDetect((Control)link);
        WidgetLCAUtil.processHelp((Widget)link);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Link link = (Link)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)link);
        writer.newWidget("org.eclipse.swt.widgets.Link");
        ControlLCAUtil.writeStyleFlags((Control)link);
    }

    public void renderChanges(Widget widget) throws IOException {
        Link link = (Link)widget;
        ControlLCAUtil.writeChanges((Control)link);
        LinkLCA.writeSelectionListener(link);
        LinkLCA.writeText(link);
        WidgetLCAUtil.writeCustomVariant((Widget)link);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeSelectionListener(Link link) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = SelectionEvent.hasListener((Adaptable)link);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)link, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)link);
            writer.set("hasSelectionListener", newValue);
        }
    }

    private static void writeText(Link link) throws IOException {
        String newValue = link.getText();
        if (WidgetLCAUtil.hasChanged((Widget)link, PROP_TEXT, newValue, "")) {
            JSWriter writer = JSWriter.getWriterFor((Widget)link);
            writer.call(JS_FUNC_CLEAR, null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ILinkAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ILinkAdapter adapter = (ILinkAdapter)link.getAdapter((Class)clazz);
            String displayText = adapter.getDisplayText();
            Point[] offsets = adapter.getOffsets();
            int length = displayText.length();
            int pos = 0;
            int i = 0;
            while (i < offsets.length) {
                int start = offsets[i].x;
                int end = offsets[i].y + 1;
                if (pos < start) {
                    LinkLCA.writeNormalText(link, displayText.substring(pos, start));
                }
                if (start < end) {
                    LinkLCA.writeLinkText(link, displayText.substring(start, end), i);
                }
                pos = end;
                ++i;
            }
            if (pos < length) {
                LinkLCA.writeNormalText(link, displayText.substring(pos, length));
            }
            LinkLCA.writeApplyText(link);
        }
    }

    private static void writeNormalText(Link link, String text) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)link);
        Object[] args = new Object[]{WidgetLCAUtil.escapeText(text, false)};
        writer.call(JS_FUNC_ADDTEXT, args);
    }

    private static void writeLinkText(Link link, String text, int index) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)link);
        Object[] args = new Object[]{WidgetLCAUtil.escapeText(text, false), new Integer(index)};
        writer.call(JS_FUNC_ADDLINK, args);
    }

    private static void writeApplyText(Link link) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)link);
        writer.call(JS_FUNC_APPLYTEXT, null);
    }

    private static void processSelectionEvent(Link link) {
        String eventId = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)link, eventId)) {
            ILinkAdapter adapter;
            String[] ids;
            HttpServletRequest request = ContextProvider.getRequest();
            String indexStr = request.getParameter("org.eclipse.swt.events.widgetSelected.index");
            int index = Integer.parseInt(indexStr);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ILinkAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (index < (ids = (adapter = (ILinkAdapter)link.getAdapter((Class)clazz)).getIds()).length) {
                SelectionEvent event = new SelectionEvent((Widget)link, null, 13);
                event.text = ids[index];
                event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
                event.processEvent();
            }
        }
    }
}

