/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.tablekit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.widgets.ITableAdapter;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public final class TableLCAUtil {
    public static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_ITEM_METRICS = "itemMetrics";
    static final String PROP_FOCUS_INDEX = "focusIndex";
    private static final Integer DEFAULT_ALIGNMENT = new Integer(16384);
    private static final Integer DEFAULT_FOCUS_INDEX = new Integer(-1);
    static /* synthetic */ Class class$0;

    public static void preserveAlignment(TableColumn column) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)column);
        adapter.preserve(PROP_ALIGNMENT, (Object)new Integer(column.getAlignment()));
    }

    public static boolean hasAlignmentChanged(Table table) {
        boolean result = false;
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (!result && i < columns.length) {
            if (TableLCAUtil.hasAlignmentChanged(columns[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public static boolean hasAlignmentChanged(TableColumn column) {
        return WidgetLCAUtil.hasChanged((Widget)column, PROP_ALIGNMENT, new Integer(column.getAlignment()), DEFAULT_ALIGNMENT);
    }

    public static void preserveItemMetrics(Table table) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)table);
        adapter.preserve(PROP_ITEM_METRICS, (Object)TableLCAUtil.getItemMetrics(table));
    }

    public static boolean hasItemMetricsChanged(Table table) {
        ItemMetrics[] itemMetrics = TableLCAUtil.getItemMetrics(table);
        return TableLCAUtil.hasItemMetricsChanged(table, itemMetrics);
    }

    public static void writeItemMetrics(Table table) throws IOException {
        ItemMetrics[] itemMetrics = TableLCAUtil.getItemMetrics(table);
        if (TableLCAUtil.hasItemMetricsChanged(table, itemMetrics)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)table);
            int i = 0;
            while (i < itemMetrics.length) {
                Object[] args = new Object[]{new Integer(i), new Integer(itemMetrics[i].left), new Integer(itemMetrics[i].width), new Integer(itemMetrics[i].imageLeft), new Integer(itemMetrics[i].imageWidth), new Integer(itemMetrics[i].textLeft), new Integer(itemMetrics[i].textWidth)};
                writer.set(PROP_ITEM_METRICS, args);
                ++i;
            }
            writer.call("updateRows", null);
        }
    }

    public static void preserveFocusIndex(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITableAdapter tableAdapter = (ITableAdapter)table.getAdapter((Class)clazz);
        int focusIndex = tableAdapter.getFocusIndex();
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)table);
        adapter.preserve(PROP_FOCUS_INDEX, (Object)new Integer(focusIndex));
    }

    public static boolean hasFocusIndexChanged(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITableAdapter tableAdapter = (ITableAdapter)table.getAdapter((Class)clazz);
        Integer focusIndex = new Integer(tableAdapter.getFocusIndex());
        return WidgetLCAUtil.hasChanged((Widget)table, PROP_FOCUS_INDEX, focusIndex, DEFAULT_FOCUS_INDEX);
    }

    private static boolean hasItemMetricsChanged(Table table, ItemMetrics[] metrics) {
        return WidgetLCAUtil.hasChanged((Widget)table, PROP_ITEM_METRICS, metrics);
    }

    static ItemMetrics[] getItemMetrics(Table table) {
        int columnCount = Math.max(1, table.getColumnCount());
        ItemMetrics[] result = new ItemMetrics[columnCount];
        int i = 0;
        while (i < columnCount) {
            result[i] = new ItemMetrics();
            ++i;
        }
        ITableAdapter tableAdapter = TableLCAUtil.getTableAdapter(table);
        TableItem measureItem = tableAdapter.getMeasureItem();
        if (measureItem != null) {
            int checkWidth = tableAdapter.getCheckWidth();
            int leftOffset = tableAdapter.getLeftOffset();
            int i2 = 0;
            while (i2 < columnCount) {
                int maxImageWidth;
                Rectangle bounds = measureItem.getBounds(i2);
                Rectangle imageBounds = measureItem.getImageBounds(i2);
                Rectangle textBounds = measureItem.getTextBounds(i2);
                int imageWidth = tableAdapter.getItemImageWidth(i2);
                if (table.getColumnCount() > 0 && imageWidth > (maxImageWidth = bounds.width - (imageBounds.x - checkWidth - bounds.x))) {
                    imageWidth = maxImageWidth;
                }
                result[i2].left = bounds.x + leftOffset;
                result[i2].width = bounds.width;
                result[i2].imageLeft = imageBounds.x + leftOffset;
                result[i2].imageWidth = imageWidth;
                result[i2].textLeft = textBounds.x + leftOffset;
                result[i2].textWidth = textBounds.width;
                ++i2;
            }
        }
        return result;
    }

    private static ITableAdapter getTableAdapter(Table table) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITableAdapter)table.getAdapter((Class)clazz);
    }

    private TableLCAUtil() {
    }

    static final class ItemMetrics {
        int left;
        int width;
        int imageLeft;
        int imageWidth;
        int textLeft;
        int textWidth;

        ItemMetrics() {
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj instanceof ItemMetrics) {
                ItemMetrics other = (ItemMetrics)obj;
                result = other.left == this.left && other.width == this.width && other.imageLeft == this.imageLeft && other.imageWidth == this.imageWidth && other.textLeft == this.textLeft && other.textWidth == this.textWidth;
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            String msg = "ItemMetrics#hashCode() not implemented";
            throw new UnsupportedOperationException(msg);
        }
    }
}

