/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.datetimekit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.widgets.datetimekit.AbstractDateTimeLCADelegate;
import org.eclipse.swt.internal.widgets.datetimekit.DateTimeLCAUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Widget;

final class DateTimeTimeLCA
extends AbstractDateTimeLCADelegate {
    static final String PROP_HOURS = "hours";
    static final String PROP_MINUTES = "minutes";
    static final String PROP_SECONDS = "seconds";

    DateTimeTimeLCA() {
    }

    void preserveValues(DateTime dateTime) {
        ControlLCAUtil.preserveValues((Control)dateTime);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)dateTime);
        boolean hasListeners = SelectionEvent.hasListener((Adaptable)dateTime);
        adapter.preserve("selectionListeners", (Object)hasListeners);
        adapter.preserve(PROP_HOURS, (Object)new Integer(dateTime.getHours()));
        adapter.preserve(PROP_MINUTES, (Object)new Integer(dateTime.getMinutes()));
        adapter.preserve(PROP_SECONDS, (Object)new Integer(dateTime.getSeconds()));
        this.preserveSubWidgetsBounds(dateTime);
        WidgetLCAUtil.preserveCustomVariant((Widget)dateTime);
    }

    void readData(DateTime dateTime) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)dateTime, PROP_HOURS);
        if (value != null) {
            dateTime.setHours(Integer.parseInt(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue((Widget)dateTime, PROP_MINUTES)) != null) {
            dateTime.setMinutes(Integer.parseInt(value));
        }
        if ((value = WidgetLCAUtil.readPropertyValue((Widget)dateTime, PROP_SECONDS)) != null) {
            dateTime.setSeconds(Integer.parseInt(value));
        }
        ControlLCAUtil.processSelection((Widget)dateTime, null, true);
        ControlLCAUtil.processMouseEvents((Control)dateTime);
        ControlLCAUtil.processKeyEvents((Control)dateTime);
        ControlLCAUtil.processMenuDetect((Control)dateTime);
        WidgetLCAUtil.processHelp((Widget)dateTime);
    }

    void renderInitialization(DateTime dateTime) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)dateTime);
        String style = "";
        if ((dateTime.getStyle() & 0x8000) != 0) {
            style = "short";
        } else if ((dateTime.getStyle() & 0x10000) != 0) {
            style = "medium";
        } else if ((dateTime.getStyle() & 0x10000000) != 0) {
            style = "long";
        }
        Object[] args = new Object[]{style};
        writer.newWidget("org.eclipse.swt.widgets.DateTimeTime", args);
        ControlLCAUtil.writeStyleFlags((Control)dateTime);
    }

    void renderChanges(DateTime dateTime) throws IOException {
        ControlLCAUtil.writeChanges((Control)dateTime);
        this.writeHours(dateTime);
        this.writeMinutes(dateTime);
        this.writeSeconds(dateTime);
        DateTimeLCAUtil.writeListener(dateTime);
        this.writeSubWidgetsBounds(dateTime);
        WidgetLCAUtil.writeCustomVariant((Widget)dateTime);
    }

    private void writeHours(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getHours());
        if (WidgetLCAUtil.hasChanged((Widget)dateTime, PROP_HOURS, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)dateTime);
            writer.set(PROP_HOURS, newValue);
        }
    }

    private void writeMinutes(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getMinutes());
        if (WidgetLCAUtil.hasChanged((Widget)dateTime, PROP_MINUTES, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)dateTime);
            writer.set(PROP_MINUTES, newValue);
        }
    }

    private void writeSeconds(DateTime dateTime) throws IOException {
        Integer newValue = new Integer(dateTime.getSeconds());
        if (WidgetLCAUtil.hasChanged((Widget)dateTime, PROP_SECONDS, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)dateTime);
            writer.set(PROP_SECONDS, newValue);
        }
    }

    private void writeSubWidgetsBounds(DateTime dateTime) throws IOException {
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 8);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 11);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 9);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 12);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 10);
        DateTimeLCAUtil.writeSubWidgetBounds(dateTime, 7);
    }

    private void preserveSubWidgetsBounds(DateTime dateTime) {
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 8);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 11);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 9);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 12);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 10);
        DateTimeLCAUtil.preserveSubWidgetBounds(dateTime, 7);
    }
}

