/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.scalekit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Widget;

public final class ScaleLCA
extends AbstractWidgetLCA {
    static final String PROP_SELECTION = "selection";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_INCREMENT = "increment";
    static final Integer DEFAULT_SELECTION = new Integer(0);
    static final Integer DEFAULT_MAXIMUM = new Integer(100);
    static final Integer DEFAULT_MINIMUM = new Integer(0);
    static final Integer DEFAULT_PAGE_INCREMENT = new Integer(10);
    static final Integer DEFAULT_INCREMENT = new Integer(1);

    public void preserveValues(Widget widget) {
        Scale scale = (Scale)widget;
        ControlLCAUtil.preserveValues((Control)scale);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)scale);
        boolean hasListeners = SelectionEvent.hasListener((Adaptable)scale);
        adapter.preserve("selectionListeners", (Object)hasListeners);
        adapter.preserve(PROP_SELECTION, (Object)new Integer(scale.getSelection()));
        adapter.preserve(PROP_MAXIMUM, (Object)new Integer(scale.getMaximum()));
        adapter.preserve(PROP_MINIMUM, (Object)new Integer(scale.getMinimum()));
        adapter.preserve(PROP_PAGE_INCREMENT, (Object)new Integer(scale.getPageIncrement()));
        adapter.preserve(PROP_INCREMENT, (Object)new Integer(scale.getIncrement()));
        WidgetLCAUtil.preserveCustomVariant((Widget)scale);
    }

    public void readData(Widget widget) {
        Scale scale = (Scale)widget;
        String value = WidgetLCAUtil.readPropertyValue((Widget)scale, PROP_SELECTION);
        if (value != null) {
            scale.setSelection(Integer.parseInt(value));
        }
        ControlLCAUtil.processSelection((Widget)scale, null, true);
        ControlLCAUtil.processKeyEvents((Control)scale);
        ControlLCAUtil.processMenuDetect((Control)scale);
        WidgetLCAUtil.processHelp((Widget)scale);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Scale scale = (Scale)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)scale);
        String style = (scale.getStyle() & 0x100) != 0 ? "horizontal" : "vertical";
        Object[] args = new Object[]{style};
        writer.newWidget("org.eclipse.swt.widgets.Scale", args);
        ControlLCAUtil.writeStyleFlags((Control)scale);
    }

    public void renderChanges(Widget widget) throws IOException {
        Scale scale = (Scale)widget;
        ControlLCAUtil.writeChanges((Control)scale);
        this.writeMaximum(scale);
        this.writeMinimum(scale);
        this.writePageIncrement(scale);
        this.writeSelection(scale);
        this.writeIncrement(scale);
        this.writeListener(scale);
        WidgetLCAUtil.writeCustomVariant((Widget)scale);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private void writeMaximum(Scale scale) throws IOException {
        Integer defValue;
        String prop = PROP_MAXIMUM;
        Integer newValue = new Integer(scale.getMaximum());
        if (WidgetLCAUtil.hasChanged((Widget)scale, prop, newValue, defValue = DEFAULT_MAXIMUM)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)scale);
            writer.set(prop, newValue);
        }
    }

    private void writeMinimum(Scale scale) throws IOException {
        Integer defValue;
        String prop = PROP_MINIMUM;
        Integer newValue = new Integer(scale.getMinimum());
        if (WidgetLCAUtil.hasChanged((Widget)scale, prop, newValue, defValue = DEFAULT_MINIMUM)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)scale);
            writer.set(prop, newValue);
        }
    }

    private void writeSelection(Scale scale) throws IOException {
        Integer defValue;
        String prop = PROP_SELECTION;
        Integer newValue = new Integer(scale.getSelection());
        if (WidgetLCAUtil.hasChanged((Widget)scale, prop, newValue, defValue = DEFAULT_SELECTION)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)scale);
            writer.set(prop, newValue);
        }
    }

    private void writeIncrement(Scale scale) throws IOException {
        Integer defValue;
        String prop = PROP_INCREMENT;
        Integer newValue = new Integer(scale.getIncrement());
        if (WidgetLCAUtil.hasChanged((Widget)scale, prop, newValue, defValue = DEFAULT_INCREMENT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)scale);
            writer.set(prop, newValue);
        }
    }

    private void writePageIncrement(Scale scale) throws IOException {
        Integer defValue;
        String prop = PROP_PAGE_INCREMENT;
        Integer newValue = new Integer(scale.getPageIncrement());
        if (WidgetLCAUtil.hasChanged((Widget)scale, prop, newValue, defValue = DEFAULT_PAGE_INCREMENT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)scale);
            writer.set(prop, newValue);
        }
    }

    private void writeListener(Scale scale) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = SelectionEvent.hasListener((Adaptable)scale);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)scale, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)scale);
            writer.set("hasSelectionListener", newValue);
        }
    }
}

