/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class ItemLCAUtil {
    private ItemLCAUtil() {
    }

    public static void preserve(Item item) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)item);
        adapter.preserve("text", (Object)item.getText());
        adapter.preserve("image", (Object)item.getImage());
    }

    public static void writeText(Item item, boolean escapeMnemonics) throws IOException {
        String text = item.getText();
        if (WidgetLCAUtil.hasChanged((Widget)item, "text", text)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            text = WidgetLCAUtil.escapeText(text, escapeMnemonics);
            writer.set("label", text);
        }
    }

    public static void writeImage(Item item) throws IOException {
        WidgetLCAUtil.writeImage((Widget)item, "image", "icon", item.getImage());
    }

    public static void writeChanges(Item item) throws IOException {
        ItemLCAUtil.writeText(item, false);
        ItemLCAUtil.writeImage(item);
    }
}

