/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.canvaskit;

import java.io.IOException;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

final class GCOperationWriter {
    private static final JSVar GC_VAR = new JSVar("gc");
    private final Control control;
    private boolean initialized;

    GCOperationWriter(Control control) {
        this.control = control;
    }

    void write(GCOperation operation) throws IOException {
        this.initialize();
        if (operation instanceof GCOperation.DrawLine) {
            this.drawLine((GCOperation.DrawLine)operation);
        } else if (operation instanceof GCOperation.DrawPoint) {
            this.drawPoint((GCOperation.DrawPoint)operation);
        } else if (operation instanceof GCOperation.DrawRoundRectangle) {
            this.drawRoundRectangle((GCOperation.DrawRoundRectangle)operation);
        } else if (operation instanceof GCOperation.FillGradientRectangle) {
            this.fillGradientRectangle((GCOperation.FillGradientRectangle)operation);
        } else if (operation instanceof GCOperation.DrawRectangle) {
            this.drawRectangle((GCOperation.DrawRectangle)operation);
        } else if (operation instanceof GCOperation.DrawArc) {
            this.drawArc((GCOperation.DrawArc)operation);
        } else if (operation instanceof GCOperation.DrawPolyline) {
            this.drawPolyline((GCOperation.DrawPolyline)operation);
        } else if (operation instanceof GCOperation.DrawImage) {
            this.drawImage((GCOperation.DrawImage)operation);
        } else if (operation instanceof GCOperation.DrawText) {
            this.drawText((GCOperation.DrawText)operation);
        } else if (operation instanceof GCOperation.SetProperty) {
            this.setProperty((GCOperation.SetProperty)operation);
        } else if (operation instanceof GCOperation.SetFont) {
            this.setFont((GCOperation.SetFont)operation);
        } else {
            String name = operation.getClass().getName();
            throw new IllegalArgumentException("Unsupported GCOperation: " + name);
        }
    }

    private void drawLine(GCOperation.DrawLine operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Integer[]{new Integer(operation.x1), new Integer(operation.y1), new Integer(operation.x2), new Integer(operation.y2)};
        writer.call(GC_VAR, "drawLine", args);
    }

    private void drawPoint(GCOperation.DrawPoint operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Integer[]{new Integer(operation.x), new Integer(operation.y)};
        writer.call(GC_VAR, "drawPoint", args);
    }

    private void drawRectangle(GCOperation.DrawRectangle operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Object[]{new Integer(operation.x), new Integer(operation.y), new Integer(operation.width), new Integer(operation.height), new Boolean(operation.fill)};
        writer.call(GC_VAR, "drawRectangle", args);
    }

    private void fillGradientRectangle(GCOperation.FillGradientRectangle operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Object[]{new Integer(operation.x), new Integer(operation.y), new Integer(operation.width), new Integer(operation.height), new Boolean(operation.vertical)};
        writer.call(GC_VAR, "fillGradientRectangle", args);
    }

    private void drawRoundRectangle(GCOperation.DrawRoundRectangle operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Object[]{new Integer(operation.x), new Integer(operation.y), new Integer(operation.width), new Integer(operation.height), new Integer(operation.arcWidth), new Integer(operation.arcHeight), new Boolean(operation.fill)};
        writer.call(GC_VAR, "drawRoundRectangle", args);
    }

    private void drawArc(GCOperation.DrawArc operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Object[]{new Integer(operation.x), new Integer(operation.y), new Integer(operation.width), new Integer(operation.height), new Integer(operation.startAngle), new Integer(operation.arcAngle), new Boolean(operation.fill)};
        writer.call(GC_VAR, "drawArc", args);
    }

    private void drawPolyline(GCOperation.DrawPolyline operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Integer[] points = new Integer[operation.points.length];
        int i = 0;
        while (i < operation.points.length) {
            points[i] = new Integer(operation.points[i]);
            ++i;
        }
        Object[] args = new Object[]{points, new Boolean(operation.close), new Boolean(operation.fill)};
        writer.call(GC_VAR, "drawPolyline", args);
    }

    private void drawImage(GCOperation.DrawImage operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Object[]{ResourceFactory.getImagePath((Image)operation.image), new Integer(operation.srcX), new Integer(operation.srcY), new Integer(operation.srcWidth), new Integer(operation.srcHeight), new Integer(operation.destX), new Integer(operation.destY), new Integer(operation.destWidth), new Integer(operation.destHeight), new Boolean(operation.simple)};
        writer.call(GC_VAR, "drawImage", args);
    }

    private void drawText(GCOperation.DrawText operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Object[]{GCOperationWriter.processText(operation.text, operation.flags), new Integer(operation.x), new Integer(operation.y), new Boolean((operation.flags & 1) == 0)};
        writer.call(GC_VAR, "drawText", args);
    }

    private static String processText(String text, int flags) {
        String result = WidgetLCAUtil.escapeText(text, false);
        String replacement = " ";
        if ((flags & 2) != 0) {
            replacement = "</br>";
        }
        result = EncodingUtil.replaceNewLines((String)result, (String)replacement);
        replacement = " ";
        if ((flags & 4) != 0) {
            replacement = "&nbsp;&nbsp;&nbsp;&nbsp;";
        }
        result = result.replaceAll("\t", replacement);
        return result;
    }

    private void setProperty(GCOperation.SetProperty operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        String jsProperty = null;
        switch (operation.id) {
            case 0: {
                jsProperty = "foreground";
                break;
            }
            case 1: {
                jsProperty = "background";
                break;
            }
            case 2: {
                jsProperty = "alpha";
                break;
            }
            case 3: {
                jsProperty = "lineWidth";
                break;
            }
            case 4: {
                jsProperty = "lineCap";
                break;
            }
            case 5: {
                jsProperty = "lineJoin";
            }
        }
        if (jsProperty != null) {
            Object[] args = new Object[]{jsProperty, operation.value};
            writer.call(GC_VAR, "setProperty", args);
        }
    }

    private void setFont(GCOperation.SetFont operation) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
        Object[] args = new Object[]{"font", GCOperationWriter.toCSSFont(operation.font)};
        writer.call(GC_VAR, "setProperty", args);
    }

    private static String toCSSFont(Font font) {
        StringBuffer result = new StringBuffer();
        FontData fontData = font.getFontData()[0];
        if ((fontData.getStyle() & 2) != 0) {
            result.append("italic ");
        }
        if ((fontData.getStyle() & 1) != 0) {
            result.append("bold ");
        }
        result.append(fontData.getHeight());
        result.append("px ");
        String name = fontData.getName().replaceAll("\"", "'");
        result.append(name);
        return result.toString();
    }

    private void initialize() throws IOException {
        if (!this.initialized) {
            JSWriter writer = JSWriter.getWriterFor((Widget)this.control);
            writer.varAssignment(GC_VAR, "getGC");
            Point size = this.control.getSize();
            Object[] args = new Object[]{new Integer(size.x), new Integer(size.y), GCOperationWriter.toCSSFont(this.control.getFont()), this.control.getBackground(), this.control.getForeground()};
            writer.call(GC_VAR, "init", args);
            this.initialized = true;
        }
    }
}

