/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.progressbarkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.IControlAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;

public class ProgressBarLCA
extends AbstractWidgetLCA {
    private static final String PROP_MINIMUM = "minimum";
    private static final String PROP_MAXIMUM = "maximum";
    private static final String PROP_SELECTION = "selection";
    static final String PROP_STATE = "state";
    static final String PROP_BACKGROUND_IMAGE_SIZED = "backgroundImageSized";
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        ProgressBar progressBar = (ProgressBar)widget;
        ControlLCAUtil.preserveValues((Control)progressBar);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)progressBar);
        adapter.preserve(PROP_MINIMUM, (Object)new Integer(progressBar.getMinimum()));
        adapter.preserve(PROP_MAXIMUM, (Object)new Integer(progressBar.getMaximum()));
        adapter.preserve(PROP_SELECTION, (Object)new Integer(progressBar.getSelection()));
        adapter.preserve(PROP_STATE, (Object)ProgressBarLCA.getState(progressBar));
        ProgressBarLCA.preserveBackgroundImage(progressBar);
        WidgetLCAUtil.preserveCustomVariant((Widget)progressBar);
    }

    public void readData(Widget widget) {
        ProgressBar progressBar = (ProgressBar)widget;
        ControlLCAUtil.processMouseEvents((Control)progressBar);
        ControlLCAUtil.processKeyEvents((Control)progressBar);
        ControlLCAUtil.processMenuDetect((Control)progressBar);
        WidgetLCAUtil.processHelp((Widget)progressBar);
    }

    public void renderInitialization(Widget widget) throws IOException {
        ProgressBar progressBar = (ProgressBar)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)progressBar);
        writer.newWidget("org.eclipse.swt.widgets.ProgressBar");
        ControlLCAUtil.writeStyleFlags((Control)progressBar);
        writer.set("flag", progressBar.getStyle());
    }

    public void renderChanges(Widget widget) throws IOException {
        ProgressBar pBar = (ProgressBar)widget;
        ControlLCAUtil.writeChanges((Control)pBar);
        ProgressBarLCA.writeSetInt(pBar, PROP_MINIMUM, PROP_MINIMUM, pBar.getMinimum(), 0);
        ProgressBarLCA.writeSetInt(pBar, PROP_MAXIMUM, PROP_MAXIMUM, pBar.getMaximum(), 100);
        ProgressBarLCA.writeSetInt(pBar, PROP_SELECTION, PROP_SELECTION, pBar.getSelection(), 0);
        ProgressBarLCA.writeState(pBar);
        ProgressBarLCA.writeBackgroundImage(pBar);
        WidgetLCAUtil.writeCustomVariant((Widget)pBar);
    }

    private static void preserveBackgroundImage(ProgressBar progressBar) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IControlAdapter controlAdapter = (IControlAdapter)progressBar.getAdapter((Class)clazz);
        Image image = controlAdapter.getUserBackgroundImage();
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)progressBar);
        adapter.preserve(PROP_BACKGROUND_IMAGE_SIZED, (Object)image);
    }

    private static void writeBackgroundImage(ProgressBar progressBar) throws IOException {
        IControlAdapter controlAdapter;
        Image image;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IControlAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (WidgetLCAUtil.hasChanged((Widget)progressBar, PROP_BACKGROUND_IMAGE_SIZED, image = (controlAdapter = (IControlAdapter)progressBar.getAdapter((Class)clazz)).getUserBackgroundImage(), null)) {
            String imagePath = ResourceFactory.getImagePath((Image)image);
            JSWriter writer = JSWriter.getWriterFor((Widget)progressBar);
            Rectangle bounds = image != null ? image.getBounds() : null;
            Object[] args = new Object[]{imagePath, new Integer(bounds != null ? bounds.width : 0), new Integer(bounds != null ? bounds.height : 0)};
            writer.set(PROP_BACKGROUND_IMAGE_SIZED, new Object[]{args});
        }
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeState(ProgressBar progressBar) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)progressBar);
        String currentState = ProgressBarLCA.getState(progressBar);
        writer.set(PROP_STATE, PROP_STATE, currentState, null);
    }

    private static String getState(ProgressBar progressBar) {
        String result = null;
        int state = progressBar.getState();
        if (state == 1) {
            result = "error";
        } else if (state == 4) {
            result = "paused";
        }
        return result;
    }

    private static void writeSetInt(ProgressBar progressBar, String javaProperty, String jsProperty, int newValue, int defValue) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)progressBar);
        writer.set(javaProperty, jsProperty, new Integer(newValue), new Integer(defValue));
    }
}

