/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.combokit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ComboLCA
extends AbstractWidgetLCA {
    private static final String[] DEFAUT_ITEMS = new String[0];
    private static final Integer DEFAULT_SELECTION = new Integer(-1);
    private static final Point DEFAULT_TEXT_SELECTION = new Point(0, 0);
    private static final Integer DEFAULT_TEXT_LIMIT = new Integer(Integer.MAX_VALUE);
    private static final int LIST_ITEM_PADDING = 3;
    private static final String JS_FUNC_SELECT = "select";
    private static final String JS_FUNC_SET_SELECTION_TEXT = "setTextSelection";
    static final String PROP_ITEMS = "items";
    static final String PROP_TEXT = "text";
    static final String PROP_SELECTION = "selection";
    static final String PROP_TEXT_SELECTION = "textSelection";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_LIST_VISIBLE = "listVisible";
    static final String PROP_EDITABLE = "editable";
    static final String PROP_VERIFY_MODIFY_LISTENER = "verifyModifyListener";
    static final String PROP_MAX_LIST_HEIGHT = "maxListHeight";
    static final String PROP_LIST_ITEM_HEIGHT = "listItemHeight";

    public void preserveValues(Widget widget) {
        Combo combo = (Combo)widget;
        ControlLCAUtil.preserveValues((Control)combo);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        String[] items = combo.getItems();
        adapter.preserve(PROP_ITEMS, (Object)items);
        Integer selection = new Integer(combo.getSelectionIndex());
        adapter.preserve(PROP_SELECTION, (Object)selection);
        adapter.preserve(PROP_TEXT_SELECTION, (Object)combo.getSelection());
        adapter.preserve(PROP_TEXT_LIMIT, (Object)new Integer(combo.getTextLimit()));
        adapter.preserve(PROP_MAX_LIST_HEIGHT, (Object)new Integer(ComboLCA.getMaxListHeight(combo)));
        adapter.preserve(PROP_LIST_ITEM_HEIGHT, (Object)new Integer(ComboLCA.getListItemHeight(combo)));
        adapter.preserve(PROP_TEXT, (Object)combo.getText());
        adapter.preserve("selectionListeners", (Object)SelectionEvent.hasListener((Adaptable)combo));
        adapter.preserve(PROP_LIST_VISIBLE, (Object)new Boolean(combo.getListVisible()));
        adapter.preserve(PROP_EDITABLE, (Object)ComboLCA.isEditable(combo));
        boolean hasVerifyListener = VerifyEvent.hasListener((Adaptable)combo);
        boolean hasModifyListener = ModifyEvent.hasListener((Adaptable)combo);
        boolean hasListener = hasVerifyListener || hasModifyListener;
        adapter.preserve(PROP_VERIFY_MODIFY_LISTENER, (Object)hasListener);
        WidgetLCAUtil.preserveCustomVariant((Widget)combo);
    }

    public void readData(Widget widget) {
        String listVisible;
        Combo combo = (Combo)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, "selectedItem");
        if (value != null) {
            combo.select(Integer.parseInt(value));
        }
        if ((listVisible = WidgetLCAUtil.readPropertyValue((Widget)combo, PROP_LIST_VISIBLE)) != null) {
            combo.setListVisible(Boolean.valueOf(listVisible).booleanValue());
        }
        ComboLCA.readTextAndSelection(combo);
        ControlLCAUtil.processSelection((Widget)combo, null, true);
        ControlLCAUtil.processMouseEvents((Control)combo);
        ControlLCAUtil.processKeyEvents((Control)combo);
        ControlLCAUtil.processMenuDetect((Control)combo);
        WidgetLCAUtil.processHelp((Widget)combo);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Combo combo = (Combo)widget;
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.newWidget("org.eclipse.swt.widgets.Combo");
        ControlLCAUtil.writeStyleFlags((Control)combo);
    }

    public void renderChanges(Widget widget) throws IOException {
        Combo combo = (Combo)widget;
        ControlLCAUtil.writeChanges((Control)combo);
        ComboLCA.writeListItemHeight(combo);
        ComboLCA.writeItems(combo);
        ComboLCA.writeSelectionListener(combo);
        ComboLCA.writeSelection(combo);
        ComboLCA.writeMaxListHeight(combo);
        ComboLCA.writeEditable(combo);
        ComboLCA.writeText(combo);
        ComboLCA.writeTextSelection(combo);
        ComboLCA.writeListVisible(combo);
        ComboLCA.writeTextLimit(combo);
        ComboLCA.writeVerifyAndModifyListener(combo);
        WidgetLCAUtil.writeCustomVariant((Widget)combo);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void readTextAndSelection(final Combo combo) {
        final Point selection = ComboLCA.readSelection(combo);
        final String value = WidgetLCAUtil.readPropertyValue((Widget)combo, PROP_TEXT);
        if (value != null) {
            if (VerifyEvent.hasListener((Adaptable)combo)) {
                ProcessActionRunner.add((Runnable)new Runnable(){

                    public void run() {
                        combo.setText(value);
                        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)combo);
                        adapter.preserve(ComboLCA.PROP_TEXT, (Object)value);
                        if (selection != null) {
                            combo.setSelection(selection);
                            adapter.preserve(ComboLCA.PROP_TEXT_SELECTION, (Object)selection);
                        }
                    }
                });
            } else {
                combo.setText(value);
                if (selection != null) {
                    combo.setSelection(selection);
                }
            }
        } else if (selection != null) {
            combo.setSelection(selection);
        }
    }

    private static Point readSelection(Combo combo) {
        Point result = null;
        String selStart = WidgetLCAUtil.readPropertyValue((Widget)combo, "selectionStart");
        String selLength = WidgetLCAUtil.readPropertyValue((Widget)combo, "selectionLength");
        if (selStart != null || selLength != null) {
            result = new Point(0, 0);
            if (selStart != null) {
                result.x = Integer.parseInt(selStart);
            }
            if (selLength != null) {
                result.y = result.x + Integer.parseInt(selLength);
            }
        }
        return result;
    }

    private static void writeItems(Combo combo) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)combo);
        String[] items = combo.getItems();
        if (WidgetLCAUtil.hasChanged((Widget)combo, PROP_ITEMS, items, DEFAUT_ITEMS)) {
            int i = 0;
            while (i < items.length) {
                items[i] = WidgetLCAUtil.replaceNewLines(items[i], " ");
                items[i] = WidgetLCAUtil.escapeText(items[i], false);
                items[i] = EncodingUtil.replaceWhiteSpaces((String)items[i]);
                ++i;
            }
            writer.set(PROP_ITEMS, new Object[]{items});
        }
    }

    private static void writeSelection(Combo combo) throws IOException {
        boolean textChanged;
        Integer newValue = new Integer(combo.getSelectionIndex());
        Integer defValue = DEFAULT_SELECTION;
        boolean selectionChanged = WidgetLCAUtil.hasChanged((Widget)combo, PROP_SELECTION, newValue, defValue);
        boolean bl = textChanged = !ComboLCA.isEditable(combo) && WidgetLCAUtil.hasChanged((Widget)combo, PROP_TEXT, combo.getText(), "");
        if (selectionChanged || textChanged) {
            JSWriter writer = JSWriter.getWriterFor((Widget)combo);
            writer.call(JS_FUNC_SELECT, new Object[]{newValue});
        }
    }

    private static void writeTextSelection(Combo combo) throws IOException {
        Point newValue = combo.getSelection();
        Point defValue = DEFAULT_TEXT_SELECTION;
        Integer start = new Integer(newValue.x);
        Integer end = new Integer(newValue.y);
        Integer count = new Integer(end - start);
        if (WidgetLCAUtil.hasChanged((Widget)combo, PROP_TEXT_SELECTION, newValue, defValue) && combo.isVisible()) {
            JSWriter writer = JSWriter.getWriterFor((Widget)combo);
            writer.call(JS_FUNC_SET_SELECTION_TEXT, new Object[]{start, count});
        }
    }

    private static void writeTextLimit(Combo combo) throws IOException {
        Integer defValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)combo);
        Integer newValue = new Integer(combo.getTextLimit());
        if (WidgetLCAUtil.hasChanged((Widget)combo, PROP_TEXT_LIMIT, newValue, defValue = DEFAULT_TEXT_LIMIT)) {
            if (newValue == Integer.MAX_VALUE) {
                newValue = null;
            }
            writer.set(PROP_TEXT_LIMIT, newValue);
        }
    }

    private static void writeListItemHeight(Combo combo) throws IOException {
        Integer newValue = new Integer(ComboLCA.getListItemHeight(combo));
        if (WidgetLCAUtil.hasChanged((Widget)combo, PROP_LIST_ITEM_HEIGHT, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)combo);
            writer.set(PROP_LIST_ITEM_HEIGHT, PROP_LIST_ITEM_HEIGHT, newValue);
        }
    }

    private static void writeMaxListHeight(Combo combo) throws IOException {
        Integer newValue = new Integer(ComboLCA.getMaxListHeight(combo));
        if (WidgetLCAUtil.hasChanged((Widget)combo, PROP_MAX_LIST_HEIGHT, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)combo);
            writer.set(PROP_MAX_LIST_HEIGHT, PROP_MAX_LIST_HEIGHT, newValue);
        }
    }

    private static void writeListVisible(Combo combo) throws IOException {
        Boolean newValue = combo.getListVisible();
        JSWriter writer = JSWriter.getWriterFor((Widget)combo);
        writer.set(PROP_LIST_VISIBLE, PROP_LIST_VISIBLE, newValue, Boolean.FALSE);
    }

    private static void writeEditable(Combo combo) throws IOException {
        boolean editable = ComboLCA.isEditable(combo);
        Boolean newValue = editable;
        JSWriter writer = JSWriter.getWriterFor((Widget)combo);
        writer.set(PROP_EDITABLE, PROP_EDITABLE, newValue, Boolean.TRUE);
    }

    private static void writeText(Combo combo) throws IOException {
        if (ComboLCA.isEditable(combo)) {
            String newValue = combo.getText();
            JSWriter writer = JSWriter.getWriterFor((Widget)combo);
            if (WidgetLCAUtil.hasChanged((Widget)combo, PROP_TEXT, newValue, "")) {
                String value = EncodingUtil.removeNonDisplayableChars((String)newValue);
                writer.set("value", value);
            }
        }
    }

    private static void writeSelectionListener(Combo combo) throws IOException {
        String prop = "selectionListeners";
        boolean hasListener = SelectionEvent.hasListener((Adaptable)combo);
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)combo, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)combo);
            writer.set("hasSelectionListener", newValue);
        }
    }

    private static void writeVerifyAndModifyListener(Combo combo) throws IOException {
        boolean hasVerifyListener = VerifyEvent.hasListener((Adaptable)combo);
        boolean hasModifyListener = ModifyEvent.hasListener((Adaptable)combo);
        String prop = PROP_VERIFY_MODIFY_LISTENER;
        boolean hasListener = hasVerifyListener || hasModifyListener;
        Boolean newValue = hasListener;
        if (WidgetLCAUtil.hasChanged((Widget)combo, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)combo);
            writer.set("hasVerifyModifyListener", newValue);
        }
    }

    private static boolean isEditable(Combo combo) {
        return (combo.getStyle() & 8) == 0;
    }

    static int getMaxListHeight(Combo combo) {
        int visibleItemCount = combo.getVisibleItemCount();
        int itemHeight = ComboLCA.getListItemHeight(combo);
        return visibleItemCount * itemHeight;
    }

    static int getListItemHeight(Combo combo) {
        int charHeight = Graphics.getCharHeight((Font)combo.getFont());
        int padding = 6;
        return charHeight + padding;
    }
}

