/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.displaykit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.lifecycle.IDisplayLifeCycleAdapter;
import org.eclipse.rwt.internal.lifecycle.RWTRequestVersionControl;
import org.eclipse.rwt.internal.lifecycle.UICallBackServiceHandler;
import org.eclipse.rwt.internal.resources.ResourceRegistry;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.JSLibraryServiceHandler;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.rwt.resources.IResource;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.graphics.TextSizeDeterminationFacadeImpl;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.internal.widgets.IDisplayAdapter;
import org.eclipse.swt.internal.widgets.IShellAdapter;
import org.eclipse.swt.internal.widgets.WidgetAdapter;
import org.eclipse.swt.internal.widgets.WidgetTreeVisitor;
import org.eclipse.swt.internal.widgets.displaykit.DNDSupport;
import org.eclipse.swt.internal.widgets.displaykit.QooxdooResourcesUtil;
import org.eclipse.swt.internal.widgets.shellkit.ShellLCA;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DisplayLCA
implements IDisplayLifeCycleAdapter {
    private static final String PATTERN_APP_STARTUP = "var req = org.eclipse.swt.Request.getInstance();req.setUrl( \"{0}\" );req.setUIRootId( \"{1}\" );var app = new org.eclipse.swt.Application();qx.core.Init.getInstance().setApplication( app );";
    private static final String PATTERN_REQUEST_COUNTER = "var req = org.eclipse.swt.Request.getInstance();req.setRequestCounter( \"{0,number,#}\" );";
    private static final String CLIENT_LOG_LEVEL = "org.eclipse.rwt.clientLogLevel";
    private static final Map LOG_LEVEL_MAP = new HashMap(9, 1.0f);
    static final String PROP_FOCUS_CONTROL = "focusControl";
    static final String PROP_CURR_THEME = "currTheme";
    static final String PROP_EXIT_CONFIRMATION = "exitConfirmation";
    static final String PROP_TIMEOUT_PAGE = "timeoutPage";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        LOG_LEVEL_MAP.put(Level.OFF, "qx.log.Logger.LEVEL_OFF");
        LOG_LEVEL_MAP.put(Level.ALL, "qx.log.Logger.LEVEL_ALL");
        LOG_LEVEL_MAP.put(Level.WARNING, "qx.log.Logger.LEVEL_WARN");
        LOG_LEVEL_MAP.put(Level.INFO, "qx.log.Logger.LEVEL_INFO");
        LOG_LEVEL_MAP.put(Level.SEVERE, "qx.log.Logger.LEVEL_ERROR");
        LOG_LEVEL_MAP.put(Level.FINE, "qx.log.Logger.LEVEL_DEBUG");
        LOG_LEVEL_MAP.put(Level.FINER, "qx.log.Logger.LEVEL_DEBUG");
        LOG_LEVEL_MAP.put(Level.FINEST, "qx.log.Logger.LEVEL_DEBUG");
    }

    public void preserveValues(Display display) {
        IWidgetAdapter adapter = DisplayUtil.getAdapter((Display)display);
        adapter.preserve(PROP_FOCUS_CONTROL, (Object)display.getFocusControl());
        adapter.preserve(PROP_CURR_THEME, (Object)ThemeUtil.getCurrentThemeId());
        adapter.preserve(PROP_TIMEOUT_PAGE, (Object)DisplayLCA.getTimeoutPage());
        adapter.preserve(PROP_EXIT_CONFIRMATION, (Object)DisplayLCA.getExitConfirmation());
    }

    public void render(Display display) throws IOException {
        HttpServletRequest request = ContextProvider.getRequest();
        if (request.getParameter("uiRoot") == null) {
            DisplayLCA.writeClientDocument(display);
        } else {
            HttpServletResponse response = ContextProvider.getResponse();
            response.setContentType("text/javascript; charset=UTF-8");
            DisplayLCA.disposeWidgets();
            DisplayLCA.writeRequestCounter();
            DisplayLCA.writeTheme(display);
            DisplayLCA.writeErrorPages(display);
            DisplayLCA.writeExitConfirmation(display);
            DisplayLCA.renderShells(display);
            DisplayLCA.writeActiveControls(display);
            DisplayLCA.writeFocus(display);
            DisplayLCA.writeUICallBackActivation(display);
            DisplayLCA.markInitialized(display);
        }
    }

    private static void renderShells(Display display) throws IOException {
        RenderVisitor visitor = new RenderVisitor();
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            WidgetTreeVisitor.accept((Widget)shells[i], (WidgetTreeVisitor)visitor);
            visitor.reThrowProblem();
            ++i;
        }
    }

    private static void writeRequestCounter() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter out = stateInfo.getResponseWriter();
        Object[] args = new Object[]{RWTRequestVersionControl.nextRequestId()};
        out.write(MessageFormat.format(PATTERN_REQUEST_COUNTER, args));
    }

    private static void writeTheme(Display display) throws IOException {
        IWidgetAdapter adapter;
        Object oldThemeId;
        String currThemeId = ThemeUtil.getCurrentThemeId();
        if (!currThemeId.equals(oldThemeId = (adapter = DisplayUtil.getAdapter((Display)display)).getPreserved(PROP_CURR_THEME))) {
            Theme theme = ThemeManager.getInstance().getTheme(currThemeId);
            StringBuffer buffer = new StringBuffer();
            buffer.append("qx.theme.manager.Meta.getInstance().setTheme( ");
            buffer.append(theme.getJsId());
            buffer.append(" );");
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            HtmlResponseWriter out = stateInfo.getResponseWriter();
            out.write(buffer.toString());
        }
    }

    private static void writeErrorPages(Display display) throws IOException {
        IWidgetAdapter adapter;
        Object oldTimeoutPage;
        String timeoutPage = DisplayLCA.getTimeoutPage();
        if (!timeoutPage.equals(oldTimeoutPage = (adapter = DisplayUtil.getAdapter((Display)display)).getPreserved(PROP_TIMEOUT_PAGE))) {
            String pattern = "org.eclipse.swt.Request.getInstance().setTimeoutPage( \"{0}\" );";
            Object[] param = new Object[]{timeoutPage};
            String jsCode = MessageFormat.format(pattern, param);
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            HtmlResponseWriter out = stateInfo.getResponseWriter();
            out.write(jsCode);
        }
    }

    private static String getTimeoutPage() {
        String timeoutTitle = RWTMessages.getMessage((String)"RWT_SessionTimeoutPageTitle");
        String timeoutHeadline = RWTMessages.getMessage((String)"RWT_SessionTimeoutPageHeadline");
        String pattern = RWTMessages.getMessage((String)"RWT_SessionTimeoutPageMessage");
        Object[] arguments = new Object[]{"<a {HREF_URL}>", "</a>"};
        String timeoutMessage = MessageFormat.format(pattern, arguments);
        String timeoutPage = "<html><head><title>" + timeoutTitle + "</title></head><body><p>" + timeoutHeadline + "</p><p>" + timeoutMessage + "</p></body></html>";
        return timeoutPage;
    }

    private static void writeExitConfirmation(Display display) throws IOException {
        boolean hasChanged;
        String exitConfirmation = DisplayLCA.getExitConfirmation();
        IWidgetAdapter adapter = DisplayUtil.getAdapter((Display)display);
        Object oldExitConfirmation = adapter.getPreserved(PROP_EXIT_CONFIRMATION);
        boolean bl = exitConfirmation == null ? oldExitConfirmation != null : (hasChanged = !exitConfirmation.equals(oldExitConfirmation));
        if (hasChanged) {
            String exitConfirmationStr = exitConfirmation == null ? "null" : "\"" + exitConfirmation + "\"";
            String code = "qx.core.Init.getInstance().getApplication().setExitConfirmation( " + exitConfirmationStr + " );";
            IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
            HtmlResponseWriter out = stateInfo.getResponseWriter();
            out.write(code);
        }
    }

    private static String getExitConfirmation() {
        AbstractBranding branding = BrandingUtil.findBranding();
        String result = null;
        if (branding.showExitConfirmation() && (result = branding.getExitConfirmationText()) == null) {
            result = "";
        }
        return result;
    }

    private static void writeClientDocument(Display display) throws IOException {
        HttpServletResponse response = ContextProvider.getResponse();
        response.setContentType("text/html; charset=UTF-8");
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter out = stateInfo.getResponseWriter();
        out.startElement("html", null);
        out.startElement("head", null);
        out.startElement("meta", null);
        out.writeAttribute("http-equiv", (Object)"Content-Type", null);
        out.writeAttribute("content", (Object)"text/html; charset=UTF-8", null);
        out.startElement("title", null);
        out.endElement("title");
        DisplayLCA.writeLibraries();
        out.endElement("head");
        out.startElement("body", null);
        IWidgetAdapter adapter = DisplayUtil.getAdapter((Display)display);
        String id = adapter.getId();
        out.startElement("script", null);
        out.writeAttribute("type", (Object)"text/javascript", null);
        DisplayLCA.writeAppScript(id);
        DisplayLCA.writeErrorPages(display);
        DisplayLCA.writeExitConfirmation(display);
        out.endElement("script");
        out.endElement("body");
        out.endElement("html");
    }

    public static void writeAppScript(String id) throws IOException {
        StringBuffer initScript = new StringBuffer();
        initScript.append(DisplayLCA.jsConfigureLogger(DisplayLCA.getClientLogLevel()));
        initScript.append(DisplayLCA.jsAppInitialization(id));
        HtmlResponseWriter out = ContextProvider.getStateInfo().getResponseWriter();
        out.writeText((Object)initScript.toString(), null);
    }

    public static void writeLibraries() throws IOException {
        QooxdooResourcesUtil.registerResources();
        ThemeManager.getInstance().registerResources();
        DisplayLCA.writeScrollBarStyle();
        DisplayLCA.writeJSLibraries();
    }

    private static void writeJSLibraries() throws IOException {
        HtmlResponseWriter out = ContextProvider.getStateInfo().getResponseWriter();
        IResource[] resources = ResourceRegistry.get();
        int i = 0;
        while (i < resources.length) {
            if (resources[i].isExternal() && resources[i].isJSLibrary()) {
                DisplayLCA.writeScriptTag(out, resources[i].getLocation());
            }
            ++i;
        }
        DisplayLCA.writeScriptTag(out, JSLibraryServiceHandler.getRequestURL());
    }

    public void readData(Display display) {
        DisplayLCA.readBounds(display);
        DisplayLCA.readCursorLocation(display);
        DisplayLCA.readFocusControl(display);
        WidgetTreeVisitor.AllWidgetTreeVisitor visitor = new WidgetTreeVisitor.AllWidgetTreeVisitor(){

            public boolean doVisit(Widget widget) {
                AbstractWidgetLCA adapter = WidgetUtil.getLCA((Widget)widget);
                adapter.readData(widget);
                return true;
            }
        };
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            WidgetTreeVisitor.accept((Widget)shell, (WidgetTreeVisitor)visitor);
            ++i;
        }
        i = 0;
        while (i < shells.length) {
            if (shells[i].getMaximized() || shells[i].getFullScreen()) {
                Shell shell = shells[i];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.swt.internal.widgets.IShellAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Object adapter = shell.getAdapter((Class)clazz);
                IShellAdapter shellAdapter = (IShellAdapter)adapter;
                shellAdapter.setBounds(display.getBounds());
            }
            ++i;
        }
        DNDSupport.processEvents();
    }

    public void processAction(Device display) {
        ProcessActionRunner.execute();
        TypedEvent.processScheduledEvents();
    }

    private static String jsConfigureLogger(Level level) {
        String jsLevel = (String)LOG_LEVEL_MAP.get(level);
        String code = "qx.log.Logger.ROOT_LOGGER.setMinLevel( {0} );";
        return MessageFormat.format(code, jsLevel);
    }

    private static String jsAppInitialization(String displayId) {
        StringBuffer code = new StringBuffer();
        code.append(TextSizeDeterminationFacadeImpl.getStartupProbeCode());
        HttpServletRequest request = ContextProvider.getRequest();
        String url = request.getServletPath().substring(1);
        Object[] param = new Object[]{ContextProvider.getResponse().encodeURL(url), displayId};
        code.append(MessageFormat.format(PATTERN_APP_STARTUP, param));
        return code.toString();
    }

    private static void disposeWidgets() throws IOException {
        AbstractWidgetLCA lca;
        Widget toDispose;
        Widget[] disposedWidgets = DisposedWidgets.getAll();
        int i = disposedWidgets.length - 1;
        while (i >= 0) {
            toDispose = disposedWidgets[i];
            if (toDispose instanceof DragSource || toDispose instanceof DropTarget) {
                lca = WidgetUtil.getLCA((Widget)toDispose);
                lca.renderDispose(toDispose);
            }
            --i;
        }
        i = disposedWidgets.length - 1;
        while (i >= 0) {
            toDispose = disposedWidgets[i];
            if (!(toDispose instanceof DragSource) && !(toDispose instanceof DropTarget)) {
                lca = WidgetUtil.getLCA((Widget)toDispose);
                lca.renderDispose(toDispose);
            }
            --i;
        }
    }

    private static void writeScriptTag(HtmlResponseWriter out, String library) throws IOException {
        out.startElement("script", null);
        out.writeAttribute("type", (Object)"text/javascript", null);
        out.writeAttribute("src", (Object)library, null);
        out.writeAttribute("charset", (Object)"UTF-8", null);
        out.endElement("script");
    }

    private static void writeScrollBarStyle() throws IOException {
        HtmlResponseWriter out = ContextProvider.getStateInfo().getResponseWriter();
        out.write("<!--[if IE]>");
        out.startElement("style", (Object)out);
        out.writeAttribute("type", (Object)"text/css", null);
        StringBuffer css = new StringBuffer();
        css.append("html, body, iframe { ");
        css.append("scrollbar-base-color:#c0c0c0;");
        css.append("scrollbar-3d-light-color:#f8f8ff;");
        css.append("scrollbar-arrow-color:#0080c0;");
        css.append("scrollbar-darkshadow-color:#f0f0f8;");
        css.append("scrollbar-face-color:#f8f8ff;");
        css.append("scrollbar-highlight-color:white;");
        css.append("scrollbar-shadow-color:gray;");
        css.append("scrollbar-track-color:#f0f0f8;");
        css.append("}");
        out.write(css.toString());
        out.endElement("style");
        out.write("<![endif]-->");
    }

    private static void writeFocus(Display display) throws IOException {
        if (!display.isDisposed()) {
            Control focusControl;
            IDisplayAdapter displayAdapter = DisplayLCA.getDisplayAdapter(display);
            IWidgetAdapter widgetAdapter = DisplayUtil.getAdapter((Display)display);
            Object oldValue = widgetAdapter.getPreserved(PROP_FOCUS_CONTROL);
            if ((!widgetAdapter.isInitialized() || oldValue != display.getFocusControl() || displayAdapter.isFocusInvalidated()) && (focusControl = display.getFocusControl()) != null) {
                IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                HtmlResponseWriter out = stateInfo.getResponseWriter();
                String id = WidgetUtil.getId((Widget)display.getFocusControl());
                out.write("org.eclipse.swt.WidgetManager.getInstance().");
                out.write("focus( \"");
                out.write(id);
                out.write("\" );");
            }
        }
    }

    private static void writeUICallBackActivation(Display display) throws IOException {
        if (!display.isDisposed()) {
            UICallBackServiceHandler.writeActivation();
        }
    }

    private static void writeActiveControls(Display display) throws IOException {
        Shell[] shells = DisplayLCA.getShells(display);
        int i = 0;
        while (i < shells.length) {
            ShellLCA.writeActiveControl(shells[i]);
            ++i;
        }
    }

    private static void markInitialized(Display display) {
        WidgetAdapter adapter = (WidgetAdapter)DisplayUtil.getAdapter((Display)display);
        adapter.setInitialized(true);
    }

    private static Level getClientLogLevel() {
        Level result = Level.OFF;
        String logLevel = System.getProperty(CLIENT_LOG_LEVEL);
        if (logLevel != null) {
            logLevel = logLevel.toUpperCase();
            Level[] knownLogLevels = new Level[LOG_LEVEL_MAP.size()];
            LOG_LEVEL_MAP.keySet().toArray(knownLogLevels);
            int i = 0;
            while (i < knownLogLevels.length) {
                if (knownLogLevels[i].getName().equals(logLevel)) {
                    result = knownLogLevels[i];
                }
                ++i;
            }
        }
        return result;
    }

    static void readBounds(Display display) {
        Rectangle oldBounds = display.getBounds();
        int width = DisplayLCA.readIntPropertyValue(display, "bounds.width", oldBounds.width);
        int height = DisplayLCA.readIntPropertyValue(display, "bounds.height", oldBounds.height);
        Rectangle bounds = new Rectangle(0, 0, width, height);
        DisplayLCA.getDisplayAdapter(display).setBounds(bounds);
    }

    private static void readCursorLocation(Display display) {
        int x = DisplayLCA.readIntPropertyValue(display, "cursorLocation.x", 0);
        int y = DisplayLCA.readIntPropertyValue(display, "cursorLocation.y", 0);
        DisplayLCA.getDisplayAdapter(display).setCursorLocation(x, y);
    }

    static void readFocusControl(Display display) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer focusControlParam = new StringBuffer();
        focusControlParam.append(DisplayUtil.getId((Display)display));
        focusControlParam.append(".focusControl");
        String id = request.getParameter(focusControlParam.toString());
        if (id != null) {
            Control focusControl = null;
            if (!"null".equals(id)) {
                Shell[] shells = DisplayLCA.getDisplayAdapter(display).getShells();
                int i = 0;
                while (focusControl == null && i < shells.length) {
                    Widget widget = WidgetUtil.find((Composite)shells[i], (String)id);
                    if (widget instanceof Control) {
                        focusControl = (Control)widget;
                    }
                    ++i;
                }
            }
            if (focusControl != null && EventUtil.isAccessible(focusControl)) {
                DisplayLCA.getDisplayAdapter(display).setFocusControl(focusControl);
            }
        }
    }

    private static String readPropertyValue(Display display, String propertyName) {
        HttpServletRequest request = ContextProvider.getRequest();
        StringBuffer key = new StringBuffer();
        key.append(DisplayUtil.getId((Display)display));
        key.append(".");
        key.append(propertyName);
        return request.getParameter(key.toString());
    }

    private static int readIntPropertyValue(Display display, String propertyName, int defaultValue) {
        String value = DisplayLCA.readPropertyValue(display, propertyName);
        int result = value == null ? defaultValue : Integer.parseInt(value);
        return result;
    }

    private static IDisplayAdapter getDisplayAdapter(Display display) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.internal.widgets.IDisplayAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = display.getAdapter((Class)clazz);
        return (IDisplayAdapter)adapter;
    }

    private static Shell[] getShells(Display display) {
        return DisplayLCA.getDisplayAdapter(display).getShells();
    }

    private static final class RenderVisitor
    extends WidgetTreeVisitor.AllWidgetTreeVisitor {
        private IOException ioProblem;

        private RenderVisitor() {
        }

        public boolean doVisit(Widget widget) {
            this.ioProblem = null;
            boolean result = true;
            try {
                RenderVisitor.render(widget);
                RenderVisitor.runRenderRunnable(widget);
            }
            catch (IOException ioe) {
                this.ioProblem = ioe;
                result = false;
            }
            return result;
        }

        private void reThrowProblem() throws IOException {
            if (this.ioProblem != null) {
                throw this.ioProblem;
            }
        }

        private static void render(Widget widget) throws IOException {
            WidgetUtil.getLCA((Widget)widget).render(widget);
        }

        private static void runRenderRunnable(Widget widget) throws IOException {
            WidgetAdapter adapter = (WidgetAdapter)WidgetUtil.getAdapter((Widget)widget);
            if (adapter.getRenderRunnable() != null) {
                adapter.getRenderRunnable().afterRender();
                adapter.clearRenderRunnable();
            }
        }
    }
}

