/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.textkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.widgets.ITextAdapter;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

final class TextLCAUtil {
    static final String PROP_TEXT = "text";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_SELECTION = "selection";
    static final String PROP_READONLY = "readonly";
    static final String PROP_VERIFY_MODIFY_LISTENER = "verifyModifyListener";
    static final String PROP_SELECTION_LISTENER = "selectionListener";
    static final String PROP_PASSWORD_MODE = "passwordMode";
    private static final Integer DEFAULT_TEXT_LIMIT = new Integer(Integer.MAX_VALUE);
    private static final Point DEFAULT_SELECTION = new Point(0, 0);
    private static final String JS_PROP_MAX_LENGTH = "maxLength";
    private static final String JS_PROP_READ_ONLY = "readOnly";
    private static final String JS_PROP_VALUE = "value";
    private static final String JS_PROP_TEXT_ALIGN = "textAlign";
    private static final String JS_PROP_PASSWORD_MODE = "passwordMode";
    static /* synthetic */ Class class$0;

    private TextLCAUtil() {
    }

    static void preserveValues(Text text) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)text);
        adapter.preserve(PROP_TEXT, (Object)text.getText());
        adapter.preserve(PROP_SELECTION, (Object)text.getSelection());
        adapter.preserve(PROP_TEXT_LIMIT, (Object)new Integer(text.getTextLimit()));
        adapter.preserve(PROP_READONLY, (Object)(!text.getEditable() ? 1 : 0));
    }

    static void readTextAndSelection(final Text text) {
        final Point selection = TextLCAUtil.readSelection(text);
        final String txt = WidgetLCAUtil.readPropertyValue((Widget)text, PROP_TEXT);
        if (txt != null) {
            if (VerifyEvent.hasListener((Adaptable)text)) {
                ProcessActionRunner.add((Runnable)new Runnable(){

                    public void run() {
                        ITextAdapter textAdapter = TextLCAUtil.getTextAdapter(text);
                        textAdapter.setText(txt, selection);
                        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)text);
                        adapter.preserve(TextLCAUtil.PROP_TEXT, (Object)txt);
                        if (selection != null) {
                            adapter.preserve(TextLCAUtil.PROP_SELECTION, (Object)selection);
                        }
                    }
                });
            } else {
                text.setText(txt);
                if (selection != null) {
                    text.setSelection(selection);
                }
            }
        } else if (selection != null) {
            text.setSelection(selection);
        }
    }

    private static Point readSelection(Text text) {
        Point result = null;
        String selStart = WidgetLCAUtil.readPropertyValue((Widget)text, "selectionStart");
        String selLength = WidgetLCAUtil.readPropertyValue((Widget)text, "selectionLength");
        if (selStart != null || selLength != null) {
            result = new Point(0, 0);
            if (selStart != null) {
                result.x = Integer.parseInt(selStart);
            }
            if (selLength != null) {
                result.y = result.x + Integer.parseInt(selLength);
            }
        }
        return result;
    }

    static void writeInitialize(Text text) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)text);
        writer.callStatic("org.eclipse.swt.TextUtil.initialize", new Object[]{text});
    }

    static void writeText(Text text) throws IOException {
        String newValue = text.getText();
        JSWriter writer = JSWriter.getWriterFor((Widget)text);
        if (WidgetLCAUtil.hasChanged((Widget)text, PROP_TEXT, newValue, "")) {
            String value = WidgetLCAUtil.replaceNewLines(newValue, " ");
            value = EncodingUtil.removeNonDisplayableChars((String)value);
            writer.set(JS_PROP_VALUE, value);
        }
    }

    static void writeReadOnly(Text text) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)text);
        Boolean newValue = !text.getEditable();
        writer.set(PROP_READONLY, JS_PROP_READ_ONLY, newValue, Boolean.FALSE);
    }

    static void writeTextLimit(Text text) throws IOException {
        Integer defValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)text);
        Integer newValue = new Integer(text.getTextLimit());
        if (WidgetLCAUtil.hasChanged((Widget)text, PROP_TEXT_LIMIT, newValue, defValue = DEFAULT_TEXT_LIMIT)) {
            if (newValue < 0) {
                newValue = null;
            }
            writer.set(JS_PROP_MAX_LENGTH, newValue);
        }
    }

    static void writeWrap(Text text) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)text);
        Boolean value = (text.getStyle() & 0x40) != 0;
        writer.set("wrap", value);
    }

    static void writeSelection(Text text) throws IOException {
        Point defValue;
        Point newValue = text.getSelection();
        if (WidgetLCAUtil.hasChanged((Widget)text, PROP_SELECTION, newValue, defValue = DEFAULT_SELECTION) && text.isVisible()) {
            JSWriter writer = JSWriter.getWriterFor((Widget)text);
            Integer start = new Integer(newValue.x);
            Integer count = new Integer(text.getSelectionCount());
            writer.callStatic("org.eclipse.swt.TextUtil.setSelection", new Object[]{text, start, count});
        }
    }

    static void writeAlignment(Text text) throws IOException {
        int style = text.getStyle();
        if ((style & 0x20000) != 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)text);
            writer.set(JS_PROP_TEXT_ALIGN, "right");
        } else if ((style & 0x1000000) != 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)text);
            writer.set(JS_PROP_TEXT_ALIGN, "center");
        }
    }

    static void preserveSelectionListener(Text text) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)text);
        adapter.preserve(PROP_SELECTION_LISTENER, (Object)TextLCAUtil.hasSelectionListener(text));
    }

    static void writeSelectionListener(Text text) throws IOException {
        Boolean newValue = TextLCAUtil.hasSelectionListener(text);
        if (WidgetLCAUtil.hasChanged((Widget)text, PROP_SELECTION_LISTENER, newValue)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)text);
            writer.callStatic("org.eclipse.swt.TextUtil.setHasSelectionListener", new Object[]{text, newValue});
        }
    }

    static void preserveVerifyAndModifyListener(Text text) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)text);
        adapter.preserve(PROP_VERIFY_MODIFY_LISTENER, (Object)TextLCAUtil.hasVerifyOrModifyListener(text));
    }

    static void writeVerifyAndModifyListener(Text text) throws IOException {
        Boolean newValue;
        if ((text.getStyle() & 8) == 0 && WidgetLCAUtil.hasChanged((Widget)text, PROP_VERIFY_MODIFY_LISTENER, newValue = Boolean.valueOf(TextLCAUtil.hasVerifyOrModifyListener(text)))) {
            JSWriter writer = JSWriter.getWriterFor((Widget)text);
            writer.callStatic("org.eclipse.swt.TextUtil.setHasVerifyOrModifyListener", new Object[]{text, newValue});
        }
    }

    static void preservePasswordMode(Text text) {
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)text);
        Boolean value = new Boolean(text.getEchoChar() != '\u0000');
        adapter.preserve("passwordMode", (Object)value);
    }

    static void writePasswordMode(Text text) throws IOException {
        String prop = "passwordMode";
        Boolean newValue = new Boolean(text.getEchoChar() != '\u0000');
        if (WidgetLCAUtil.hasChanged((Widget)text, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)text);
            writer.set("passwordMode", newValue);
        }
    }

    private static boolean hasSelectionListener(Text text) {
        boolean hasDefaultButton;
        Button defButton = text.getShell().getDefaultButton();
        boolean bl = hasDefaultButton = defButton != null && defButton.isVisible();
        return !hasDefaultButton && SelectionEvent.hasListener((Adaptable)text);
    }

    private static boolean hasVerifyOrModifyListener(Text text) {
        boolean hasVerifyListener = VerifyEvent.hasListener((Adaptable)text);
        boolean hasModifyListener = ModifyEvent.hasListener((Adaptable)text);
        return hasModifyListener || hasVerifyListener;
    }

    private static ITextAdapter getTextAdapter(Text text) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITextAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextAdapter)text.getAdapter((Class)clazz);
    }
}

