/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.toolitemkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.events.DeselectionEvent;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemDelegateLCA;
import org.eclipse.swt.internal.widgets.toolitemkit.ToolItemLCAUtil;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

final class RadioToolItemLCA
extends ToolItemDelegateLCA {
    private static final String PARAM_RADIO = "radio";
    private static final String PARAM_SELECTION = "selection";

    RadioToolItemLCA() {
    }

    void preserveValues(ToolItem toolItem) {
        ToolItemLCAUtil.preserveValues(toolItem);
        ToolItemLCAUtil.preserveImages(toolItem);
        ToolItemLCAUtil.preserveSelection(toolItem);
    }

    void readData(ToolItem toolItem) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)toolItem, PARAM_SELECTION);
        if (value != null) {
            toolItem.setSelection(Boolean.valueOf(value).booleanValue());
            RadioToolItemLCA.processSelectionEvent(toolItem);
        }
    }

    void renderInitialization(ToolItem toolItem) throws IOException {
        ToolItemLCAUtil.renderInitialization(toolItem, PARAM_RADIO);
    }

    void renderChanges(ToolItem toolItem) throws IOException {
        ToolItemLCAUtil.renderChanges(toolItem);
        ToolItemLCAUtil.writeSelection(toolItem);
    }

    private static void processSelectionEvent(ToolItem toolItem) {
        if (SelectionEvent.hasListener((Adaptable)toolItem)) {
            int type = 13;
            Object event = toolItem.getSelection() ? new SelectionEvent((Widget)toolItem, null, type) : new DeselectionEvent((Widget)toolItem, null, type);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }
}

