/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.custom.clabelkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.custom.clabelkit.CLabelThemeAdapter;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public final class CLabelLCA
extends AbstractWidgetLCA {
    static final String PROP_TEXT = "text";
    static final String PROP_ALIGNMENT = "alignment";
    static final String PROP_IMAGE = "image";
    static final String PROP_LEFT_MARGIN = "leftMargin";
    static final String PROP_TOP_MARGIN = "topMargin";
    static final String PROP_RIGHT_MARGIN = "rightMargin";
    static final String PROP_BOTTOM_MARGIN = "bottomMargin";
    private static final Integer DEFAULT_ALIGNMENT = new Integer(16384);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.preserveValues((Control)label);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)label);
        adapter.preserve(PROP_TEXT, (Object)label.getText());
        adapter.preserve(PROP_IMAGE, (Object)label.getImage());
        adapter.preserve(PROP_ALIGNMENT, (Object)new Integer(label.getAlignment()));
        adapter.preserve(PROP_LEFT_MARGIN, (Object)new Integer(label.getLeftMargin()));
        adapter.preserve(PROP_TOP_MARGIN, (Object)new Integer(label.getTopMargin()));
        adapter.preserve(PROP_RIGHT_MARGIN, (Object)new Integer(label.getRightMargin()));
        adapter.preserve(PROP_BOTTOM_MARGIN, (Object)new Integer(label.getBottomMargin()));
        WidgetLCAUtil.preserveCustomVariant((Widget)label);
    }

    public void readData(Widget widget) {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.processMouseEvents((Control)label);
        ControlLCAUtil.processKeyEvents((Control)label);
        ControlLCAUtil.processMenuDetect((Control)label);
        WidgetLCAUtil.processHelp((Widget)label);
    }

    public void renderInitialization(Widget widget) throws IOException {
        CLabel label = (CLabel)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)label);
        writer.newWidget("qx.ui.basic.Atom");
        if ((widget.getStyle() & 4) != 0) {
            writer.call("addState", new Object[]{"rwt_SHADOW_IN"});
        } else if ((widget.getStyle() & 8) != 0) {
            writer.call("addState", new Object[]{"rwt_SHADOW_OUT"});
        }
        ControlLCAUtil.writeStyleFlags((Control)label);
        Object[] args = new Object[]{label};
        writer.callStatic("org.eclipse.swt.CLabelUtil.initialize", args);
    }

    public void renderChanges(Widget widget) throws IOException {
        CLabel label = (CLabel)widget;
        ControlLCAUtil.writeChanges((Control)label);
        CLabelLCA.writeText(label);
        CLabelLCA.writeImage(label);
        CLabelLCA.writeAlignment(label);
        CLabelLCA.writeMargins(label);
        WidgetLCAUtil.writeCustomVariant((Widget)label);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeText(CLabel label) throws IOException {
        String text = label.getText();
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_TEXT, text, "")) {
            if (text == null) {
                text = "";
            }
            text = WidgetLCAUtil.escapeText(text, true);
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            text = WidgetLCAUtil.replaceNewLines(text, "<br/>");
            writer.set("label", text);
        }
    }

    private static void writeImage(CLabel label) throws IOException {
        Image image = label.getImage();
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_IMAGE, image, null)) {
            String imagePath = image == null ? null : ResourceFactory.getImagePath((Image)image);
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            writer.set("icon", imagePath);
        }
    }

    private static void writeAlignment(CLabel label) throws IOException {
        Integer defValue;
        Integer alignment = new Integer(label.getAlignment());
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_ALIGNMENT, alignment, defValue = DEFAULT_ALIGNMENT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            Object[] args = new Object[]{label, CLabelLCA.getAlignment(label.getAlignment())};
            writer.callStatic("org.eclipse.swt.LabelUtil.setAlignment", args);
        }
    }

    private static String getAlignment(int alignment) {
        String result = (alignment & 0x4000) != 0 ? "left" : ((alignment & 0x1000000) != 0 ? "center" : ((alignment & 0x20000) != 0 ? "right" : "left"));
        return result;
    }

    private static void writeMargins(CLabel label) throws IOException {
        Integer leftMargin = new Integer(label.getLeftMargin());
        Integer topMargin = new Integer(label.getTopMargin());
        Integer rightMargin = new Integer(label.getRightMargin());
        Integer bottomMargin = new Integer(label.getBottomMargin());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.IThemeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CLabelThemeAdapter themeAdapter = (CLabelThemeAdapter)label.getAdapter((Class)clazz);
        Rectangle padding = themeAdapter.getPadding((Control)label);
        Integer defLeftMargin = new Integer(padding.x);
        Integer defTopMargin = new Integer(padding.y);
        Integer defRightMargin = new Integer(padding.width - padding.x);
        Integer defBottomMargin = new Integer(padding.height - padding.y);
        if (WidgetLCAUtil.hasChanged((Widget)label, PROP_LEFT_MARGIN, leftMargin, defLeftMargin) || WidgetLCAUtil.hasChanged((Widget)label, PROP_TOP_MARGIN, topMargin, defTopMargin) || WidgetLCAUtil.hasChanged((Widget)label, PROP_RIGHT_MARGIN, rightMargin, defRightMargin) || WidgetLCAUtil.hasChanged((Widget)label, PROP_BOTTOM_MARGIN, bottomMargin, defBottomMargin)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)label);
            Object[] args = new Object[]{topMargin, rightMargin, bottomMargin, leftMargin};
            writer.set("padding", args);
        }
    }
}

