/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.IOException;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.lifecycle.JSVar;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.internal.graphics.TextSizeDeterminationFacade;
import org.eclipse.swt.internal.graphics.TextSizeProbeStore;

public final class TextSizeDeterminationFacadeImpl
extends TextSizeDeterminationFacade {
    public static String getStartupProbeCode() {
        StringBuffer result = new StringBuffer();
        TextSizeProbeStore.IProbe[] probeList = TextSizeProbeStore.getProbeList();
        if (probeList.length > 0) {
            result.append("org.eclipse.swt.FontSizeCalculation.probe(");
            result.append("[ ");
            int i = 0;
            while (i < probeList.length) {
                TextSizeProbeStore.IProbe probe = probeList[i];
                result.append(probe.getJSProbeParam());
                if (i < probeList.length - 1) {
                    result.append(", ");
                }
                ++i;
            }
            result.append(" ] );");
        }
        return result.toString();
    }

    public String createMeasureStringInternal(String string, boolean expandNewLines) {
        String result = WidgetLCAUtil.escapeText(string, true);
        String newLineReplacement = expandNewLines ? "<br/>" : " ";
        result = WidgetLCAUtil.replaceNewLines(result, newLineReplacement);
        return result;
    }

    public TextSizeDetermination.ICalculationItem[] writeStringMeasurementsInternal() throws IOException {
        TextSizeDetermination.ICalculationItem[] items = TextSizeDetermination.getCalculationItems();
        if (items.length > 0) {
            JSWriter writer = JSWriter.getWriterForResetHandler();
            StringBuffer param = new StringBuffer();
            param.append("[ ");
            int i = 0;
            while (i < items.length) {
                param.append("[ ");
                TextSizeDetermination.ICalculationItem item = items[i];
                param.append(item.hashCode());
                param.append(", ");
                param.append("\"");
                String itemString = item.getString();
                itemString = EncodingUtil.escapeDoubleQuoted((String)itemString);
                itemString = EncodingUtil.escapeLeadingTrailingSpaces((String)itemString);
                param.append(itemString);
                param.append("\", ");
                param.append(TextSizeDeterminationFacadeImpl.createFontParam((FontData)item.getFontData()));
                param.append(", ");
                param.append(item.getWrapWidth());
                param.append(" ]");
                if (i < items.length - 1) {
                    param.append(", ");
                }
                ++i;
            }
            param.append(" ]");
            String funcName = "org.eclipse.swt.FontSizeCalculation.measureStrings";
            writer.callStatic(funcName, new Object[]{new JSVar(param.toString())});
        }
        return items;
    }

    public TextSizeProbeStore.IProbe[] writeFontProbingInternal() throws IOException {
        TextSizeProbeStore.IProbe[] requests = TextSizeProbeStore.getProbeRequests();
        if (requests.length > 0) {
            JSWriter writer = JSWriter.getWriterForResetHandler();
            StringBuffer param = new StringBuffer();
            param.append("[ ");
            int i = 0;
            while (i < requests.length) {
                TextSizeProbeStore.IProbe probe = requests[i];
                param.append(probe.getJSProbeParam());
                if (i < requests.length - 1) {
                    param.append(", ");
                }
                ++i;
            }
            param.append(" ]");
            String funcName = "org.eclipse.swt.FontSizeCalculation.probe";
            writer.callStatic(funcName, new Object[]{new JSVar(param.toString())});
        }
        return requests;
    }

    public String createFontParamInternal(FontData fontData) {
        StringBuffer result = new StringBuffer();
        String[] names = WidgetLCAUtil.parseFontName(fontData.getName());
        result.append("[ ");
        int i = 0;
        while (i < names.length) {
            result.append("\"");
            result.append(names[i]);
            result.append("\"");
            if (i < names.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        result.append(" ], ");
        result.append(fontData.getHeight());
        result.append(", ");
        result.append((fontData.getStyle() & 1) != 0);
        result.append(", ");
        result.append((fontData.getStyle() & 2) != 0);
        return result.toString();
    }
}

