/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.expanditemkit;

import java.io.IOException;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.graphics.ResourceFactory;
import org.eclipse.swt.internal.widgets.IExpandBarAdapter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Widget;

public final class ExpandItemLCA
extends AbstractWidgetLCA {
    public static final String EVENT_ITEM_EXPANDED = "org.eclipse.swt.events.expandItemExpanded";
    public static final String EVENT_ITEM_COLLAPSED = "org.eclipse.swt.events.expandItemCollapsed";
    public static final String PROP_TEXT = "text";
    public static final String PROP_IMAGE = "image";
    public static final String PROP_EXPANDED = "expanded";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_HEADER_HEIGHT = "headerHeight";
    public static final Integer DEFAULT_HEADER_HEIGHT = new Integer(24);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        ExpandItem expandItem = (ExpandItem)widget;
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_TEXT, (Object)expandItem.getText());
        adapter.preserve(PROP_IMAGE, (Object)expandItem.getImage());
        adapter.preserve(PROP_EXPANDED, (Object)expandItem.getExpanded());
        adapter.preserve(PROP_ENABLED, (Object)expandItem.getParent().isEnabled());
        adapter.preserve(PROP_HEADER_HEIGHT, (Object)new Integer(expandItem.getHeaderHeight()));
        IExpandBarAdapter expandBarAdapter = ExpandItemLCA.getExpandBarAdapter(expandItem.getParent());
        WidgetLCAUtil.preserveBounds((Widget)expandItem, expandBarAdapter.getBounds(expandItem));
    }

    public void readData(Widget widget) {
        final ExpandItem expandItem = (ExpandItem)widget;
        if (WidgetLCAUtil.wasEventSent((Widget)expandItem, EVENT_ITEM_EXPANDED)) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    expandItem.setExpanded(true);
                    ExpandEvent event = ExpandItemLCA.createExpandEvent(expandItem);
                    event.processEvent();
                }
            });
        }
        if (WidgetLCAUtil.wasEventSent((Widget)expandItem, EVENT_ITEM_COLLAPSED)) {
            ProcessActionRunner.add((Runnable)new Runnable(){

                public void run() {
                    expandItem.setExpanded(false);
                    ExpandEvent event = ExpandItemLCA.createCollapseEvent(expandItem);
                    event.processEvent();
                }
            });
        }
    }

    public void renderInitialization(Widget widget) throws IOException {
        ExpandItem expandItem = (ExpandItem)widget;
        ExpandBar parent = expandItem.getParent();
        JSWriter writer = JSWriter.getWriterFor((Widget)expandItem);
        Object[] args = new Object[]{parent};
        writer.newWidget("org.eclipse.swt.widgets.ExpandItem", args);
        writer.call((Widget)parent, "add", new Object[]{expandItem});
        WidgetLCAUtil.writeCustomVariant(widget);
    }

    public void renderChanges(Widget widget) throws IOException {
        ExpandItem expandItem = (ExpandItem)widget;
        ExpandItemLCA.writeText(expandItem);
        ExpandItemLCA.writeImage(expandItem);
        ExpandItemLCA.writeExpanded(expandItem);
        ExpandItemLCA.writeEnabled(expandItem);
        ExpandItemLCA.writeHeaderHeight(expandItem);
        IExpandBarAdapter adapter = ExpandItemLCA.getExpandBarAdapter(expandItem.getParent());
        WidgetLCAUtil.writeBounds((Widget)expandItem, (Control)expandItem.getParent(), adapter.getBounds(expandItem));
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static ExpandEvent createExpandEvent(ExpandItem expandItem) {
        ExpandEvent event = new ExpandEvent((Widget)expandItem.getParent(), (Widget)expandItem, 17);
        event.item = expandItem;
        return event;
    }

    private static ExpandEvent createCollapseEvent(ExpandItem expandItem) {
        ExpandEvent event = new ExpandEvent((Widget)expandItem.getParent(), (Widget)expandItem, 18);
        event.item = expandItem;
        return event;
    }

    private static void writeText(ExpandItem item) throws IOException {
        String text = item.getText();
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_TEXT, text)) {
            text = WidgetLCAUtil.escapeText(text, false);
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_TEXT, text);
        }
    }

    private static void writeImage(ExpandItem item) throws IOException {
        Image image = item.getImage();
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_IMAGE, image, null)) {
            String imagePath = image == null ? null : ResourceFactory.getImagePath((Image)image);
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_IMAGE, imagePath);
        }
    }

    private static void writeExpanded(ExpandItem item) throws IOException {
        Boolean newValue = item.getExpanded();
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_EXPANDED, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_EXPANDED, newValue);
        }
    }

    private static void writeEnabled(ExpandItem item) throws IOException {
        Boolean newValue = item.getParent().isEnabled();
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_ENABLED, newValue, Boolean.TRUE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            if (newValue.booleanValue()) {
                writer.call("addState", new Object[]{PROP_ENABLED});
            } else {
                writer.call("removeState", new Object[]{PROP_ENABLED});
            }
        }
    }

    private static void writeHeaderHeight(ExpandItem item) throws IOException {
        Integer newValue = new Integer(item.getHeaderHeight());
        if (WidgetLCAUtil.hasChanged((Widget)item, PROP_HEADER_HEIGHT, newValue, DEFAULT_HEADER_HEIGHT)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)item);
            writer.set(PROP_HEADER_HEIGHT, newValue);
        }
    }

    private static IExpandBarAdapter getExpandBarAdapter(ExpandBar bar) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.IExpandBarAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IExpandBarAdapter)bar.getAdapter((Class)clazz);
    }
}

