/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.menuitemkit;

import java.io.IOException;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.internal.events.DeselectionEvent;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ItemLCAUtil;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemDelegateLCA;
import org.eclipse.swt.internal.widgets.menuitemkit.MenuItemLCAUtil;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

final class RadioMenuItemLCA
extends MenuItemDelegateLCA {
    private static final String ITEM_TYPE_RADIO = "radio";

    RadioMenuItemLCA() {
    }

    void preserveValues(MenuItem menuItem) {
        ItemLCAUtil.preserve((Item)menuItem);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)menuItem);
        boolean hasListener = SelectionEvent.hasListener((Adaptable)menuItem);
        adapter.preserve("selectionListeners", (Object)hasListener);
        adapter.preserve("selection", (Object)menuItem.getSelection());
        MenuItemLCAUtil.preserveEnabled(menuItem);
        WidgetLCAUtil.preserveCustomVariant((Widget)menuItem);
        WidgetLCAUtil.preserveHelpListener((Widget)menuItem);
    }

    void readData(MenuItem menuItem) {
        if (this.readSelection(menuItem)) {
            RadioMenuItemLCA.processSelectionEvent(menuItem);
        }
        ControlLCAUtil.processSelection((Widget)menuItem, null, false);
        WidgetLCAUtil.processHelp((Widget)menuItem);
        MenuItemLCAUtil.processArmEvent(menuItem);
    }

    void renderInitialization(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.newItem(menuItem, "org.eclipse.rwt.widgets.MenuItem", ITEM_TYPE_RADIO);
    }

    void renderChanges(MenuItem menuItem) throws IOException {
        MenuItemLCAUtil.writeImageAndText(menuItem);
        MenuItemLCAUtil.writeSelectionListener(menuItem);
        MenuItemLCAUtil.writeSelection(menuItem);
        MenuItemLCAUtil.writeEnabled(menuItem);
        WidgetLCAUtil.writeCustomVariant((Widget)menuItem);
        WidgetLCAUtil.writeHelpListener((Widget)menuItem);
    }

    private boolean readSelection(MenuItem item) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)item, "selection");
        if (value != null) {
            item.setSelection(Boolean.valueOf(value).booleanValue());
        }
        return value != null;
    }

    private static void processSelectionEvent(MenuItem item) {
        if (SelectionEvent.hasListener((Adaptable)item)) {
            int type = 13;
            Object event = item.getSelection() ? new SelectionEvent((Widget)item, null, type) : new DeselectionEvent((Widget)item, null, type);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }
}

