/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.treekit;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.ProcessActionRunner;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.ITreeAdapter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public final class TreeLCA
extends AbstractWidgetLCA {
    private static final String PROP_SELECTION_LISTENERS = "selectionListeners";
    static final String PROP_HEADER_HEIGHT = "headerHeight";
    static final String PROP_HEADER_VISIBLE = "headerVisible";
    static final String PROP_COLUMN_ORDER = "columnOrder";
    static final String PROP_SCROLL_LEFT = "scrollLeft";
    static final String PROP_HAS_H_SCROLL_BAR = "hasHScrollBar";
    static final String PROP_HAS_V_SCROLL_BAR = "hasVScrollBar";
    private static final Integer DEFAULT_SCROLL_LEFT = new Integer(0);
    static /* synthetic */ Class class$0;

    public void preserveValues(Widget widget) {
        Tree tree = (Tree)widget;
        ControlLCAUtil.preserveValues((Control)widget);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)tree);
        adapter.preserve(PROP_SELECTION_LISTENERS, (Object)SelectionEvent.hasListener((Adaptable)tree));
        adapter.preserve(PROP_HEADER_HEIGHT, (Object)new Integer(tree.getHeaderHeight()));
        adapter.preserve(PROP_HEADER_VISIBLE, (Object)tree.getHeaderVisible());
        int[] values = tree.getColumnOrder();
        Integer[] columnOrder = new Integer[values.length];
        int i = 0;
        while (i < values.length) {
            columnOrder[i] = new Integer(values[i]);
            ++i;
        }
        adapter.preserve(PROP_COLUMN_ORDER, (Object)columnOrder);
        adapter.preserve(PROP_SCROLL_LEFT, (Object)TreeLCA.getScrollLeft(tree));
        adapter.preserve(PROP_HAS_H_SCROLL_BAR, (Object)TreeLCA.hasHScrollBar(tree));
        adapter.preserve(PROP_HAS_V_SCROLL_BAR, (Object)TreeLCA.hasVScrollBar(tree));
        WidgetLCAUtil.preserveCustomVariant((Widget)tree);
    }

    public void readData(Widget widget) {
        Tree tree = (Tree)widget;
        TreeLCA.readSelection(tree);
        TreeLCA.readScrollPosition(tree);
        TreeLCA.processWidgetSelectedEvent(tree);
        TreeLCA.processWidgetDefaultSelectedEvent(tree);
        ControlLCAUtil.processMouseEvents((Control)tree);
        ControlLCAUtil.processKeyEvents((Control)tree);
        ControlLCAUtil.processMenuDetect((Control)tree);
        WidgetLCAUtil.processHelp((Widget)tree);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Tree tree = (Tree)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        StringBuffer style = new StringBuffer();
        if ((tree.getStyle() & 2) != 0) {
            style.append("multi|");
        }
        if ((tree.getStyle() & 0x20) != 0) {
            style.append("check|");
        }
        if ((tree.getStyle() & 0x10000000) != 0) {
            style.append("virtual|");
        }
        writer.newWidget("org.eclipse.swt.widgets.Tree", new Object[]{style.toString()});
        ControlLCAUtil.writeStyleFlags((Control)tree);
    }

    public void renderChanges(Widget widget) throws IOException {
        Tree tree = (Tree)widget;
        ControlLCAUtil.writeChanges((Control)tree);
        TreeLCA.updateSelectionListener(tree);
        TreeLCA.writeHeaderHeight(tree);
        TreeLCA.writeHeaderVisible(tree);
        this.writeColumnOrder(tree);
        this.writeScrollLeft(tree);
        TreeLCA.writeOverflow(tree);
        WidgetLCAUtil.writeCustomVariant((Widget)tree);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    public void doRedrawFake(Control control) {
        int evtId = 11;
        ControlEvent evt = new ControlEvent((Object)control, evtId);
        evt.processEvent();
    }

    private static void processWidgetSelectedEvent(Tree tree) {
        HttpServletRequest request = ContextProvider.getRequest();
        String eventName = "org.eclipse.swt.events.widgetSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)tree, eventName)) {
            Rectangle bounds = new Rectangle(0, 0, 0, 0);
            String itemId = request.getParameter(String.valueOf(eventName) + ".item");
            Item treeItem = (Item)WidgetUtil.find((Composite)tree, (String)itemId);
            String detailStr = request.getParameter(String.valueOf(eventName) + ".detail");
            int detail = "check".equals(detailStr) ? 32 : 0;
            int eventType = 13;
            int stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            SelectionEvent event = new SelectionEvent((Widget)tree, (Widget)treeItem, eventType, bounds, stateMask, null, true, detail);
            event.processEvent();
        }
    }

    private static void processWidgetDefaultSelectedEvent(Tree tree) {
        HttpServletRequest request = ContextProvider.getRequest();
        String eventName = "org.eclipse.swt.events.widgetDefaultSelected";
        if (WidgetLCAUtil.wasEventSent((Widget)tree, eventName)) {
            String itemId = request.getParameter(String.valueOf(eventName) + ".item");
            Item treeItem = (Item)WidgetUtil.find((Composite)tree, (String)itemId);
            int eventType = 14;
            SelectionEvent event = new SelectionEvent((Widget)tree, (Widget)treeItem, eventType);
            event.stateMask = EventLCAUtil.readStateMask("org.eclipse.swt.events.widgetSelected.modifier");
            event.processEvent();
        }
    }

    private static void readSelection(Tree tree) {
        String value = WidgetLCAUtil.readPropertyValue((Widget)tree, "selection");
        if (value != null) {
            String[] values = value.split(",");
            TreeItem[] selectedItems = new TreeItem[values.length];
            boolean validItemFound = false;
            int i = 0;
            while (i < values.length) {
                selectedItems[i] = (TreeItem)WidgetUtil.find((Composite)tree, (String)values[i]);
                if (selectedItems[i] != null) {
                    validItemFound = true;
                }
                ++i;
            }
            if (!validItemFound) {
                selectedItems = new TreeItem[]{};
            }
            tree.setSelection(selectedItems);
        }
    }

    private static void readScrollPosition(final Tree tree) {
        String left = WidgetLCAUtil.readPropertyValue((Widget)tree, PROP_SCROLL_LEFT);
        String top = WidgetLCAUtil.readPropertyValue((Widget)tree, "scrollTop");
        if (left != null && top != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object adapter = tree.getAdapter((Class)clazz);
            final ITreeAdapter treeAdapter = (ITreeAdapter)adapter;
            int newScrollLeft = TreeLCA.parsePosition(left);
            int newScrollTop = TreeLCA.parsePosition(top);
            int oldScrollTop = treeAdapter.getScrollTop();
            treeAdapter.setScrollLeft(newScrollLeft);
            treeAdapter.setScrollTop(newScrollTop);
            if (oldScrollTop != newScrollTop) {
                ProcessActionRunner.add((Runnable)new Runnable(){

                    public void run() {
                        treeAdapter.checkAllData(tree);
                    }
                });
            }
        }
    }

    private static int parsePosition(String position) {
        int result = 0;
        try {
            result = Integer.valueOf(position);
        }
        catch (NumberFormatException numberFormatException) {}
        return result;
    }

    private static void writeHeaderHeight(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = new Integer(tree.getHeaderHeight());
        writer.set(PROP_HEADER_HEIGHT, PROP_HEADER_HEIGHT, newValue, null);
    }

    private void writeColumnOrder(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        int[] values = tree.getColumnOrder();
        if (values.length > 0) {
            Integer[] newValue = new Integer[values.length];
            int i = 0;
            while (i < values.length) {
                newValue[i] = new Integer(values[i]);
                ++i;
            }
            if (WidgetLCAUtil.hasChanged((Widget)tree, PROP_COLUMN_ORDER, newValue, new Integer[0])) {
                writer.set(PROP_COLUMN_ORDER, PROP_COLUMN_ORDER, newValue, null);
            }
        }
    }

    private static void writeHeaderVisible(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Boolean newValue = tree.getHeaderVisible();
        writer.set(PROP_HEADER_VISIBLE, PROP_HEADER_VISIBLE, newValue, Boolean.FALSE);
    }

    private void writeScrollLeft(Tree tree) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)tree);
        Integer newValue = TreeLCA.getScrollLeft(tree);
        writer.set(PROP_SCROLL_LEFT, PROP_SCROLL_LEFT, newValue, DEFAULT_SCROLL_LEFT);
    }

    private static void writeOverflow(Tree tree) throws IOException {
        boolean hasHChanged = WidgetLCAUtil.hasChanged((Widget)tree, PROP_HAS_H_SCROLL_BAR, TreeLCA.hasHScrollBar(tree), Boolean.TRUE);
        boolean hasVChanged = WidgetLCAUtil.hasChanged((Widget)tree, PROP_HAS_V_SCROLL_BAR, TreeLCA.hasVScrollBar(tree), Boolean.TRUE);
        if (hasHChanged || hasVChanged) {
            boolean scrollX = TreeLCA.hasHScrollBar(tree);
            boolean scrollY = TreeLCA.hasVScrollBar(tree);
            String overflow = scrollX && scrollY ? "scroll" : (scrollX ? "scrollX" : (scrollY ? "scrollY" : "hidden"));
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            writer.set("treeOverflow", overflow);
        }
    }

    private static void updateSelectionListener(Tree tree) throws IOException {
        String prop = PROP_SELECTION_LISTENERS;
        Boolean newValue = SelectionEvent.hasListener((Adaptable)tree);
        if (WidgetLCAUtil.hasChanged((Widget)tree, prop, newValue, Boolean.FALSE)) {
            JSWriter writer = JSWriter.getWriterFor((Widget)tree);
            writer.set(PROP_SELECTION_LISTENERS, newValue);
        }
    }

    private static Integer getScrollLeft(Tree tree) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = tree.getAdapter((Class)clazz);
        ITreeAdapter treeAdapter = (ITreeAdapter)adapter;
        return new Integer(treeAdapter.getScrollLeft());
    }

    private static Boolean hasHScrollBar(Tree tree) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = tree.getAdapter((Class)clazz);
        ITreeAdapter treeAdapter = (ITreeAdapter)adapter;
        return treeAdapter.hasHScrollBar();
    }

    private static Boolean hasVScrollBar(Tree tree) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.widgets.ITreeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object adapter = tree.getAdapter((Class)clazz);
        ITreeAdapter treeAdapter = (ITreeAdapter)adapter;
        return treeAdapter.hasVScrollBar();
    }
}

