/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.graphics;

import org.eclipse.swt.*;

/**
 * <code>LineAttributes</code> defines a set of line attributes that
 * can be modified in a GC.
 * <p>
 * Application code does <em>not</em> need to explicitly release the
 * resources managed by each instance when those instances are no longer
 * required, and thus no <code>dispose()</code> method is provided.
 * </p>
 *
 * @see GC#getLineAttributes()
 * @see GC#setLineAttributes(LineAttributes)
 * @see <a href="http://www.eclipse.org/swt/">Sample code and further information</a>
 *
 * @since 1.3
 */
public class LineAttributes {

	/**
	 * The line width.
	 */
	public float width;

	/**
	 * The line cap style.
	 *
	 * @see org.eclipse.swt.SWT#CAP_FLAT
	 * @see org.eclipse.swt.SWT#CAP_ROUND
	 * @see org.eclipse.swt.SWT#CAP_SQUARE
	 */
	public int cap;

	/**
	 * The line join style.
	 *
	 * @see org.eclipse.swt.SWT#JOIN_BEVEL
	 * @see org.eclipse.swt.SWT#JOIN_MITER
	 * @see org.eclipse.swt.SWT#JOIN_ROUND
	 */
	public int join;

  /**
   * Create a new line attributes with the specified line width.
   *
   * @param width the line width
   */
  public LineAttributes( final float width ) {
  	this( width, SWT.CAP_FLAT, SWT.JOIN_MITER );
  }

  /**
   * Create a new line attributes with the specified line cap, join and width.
   *
   * @param width the line width
   * @param cap the line cap style
   * @param join the line join style
   */
  public LineAttributes( final float width, final int cap, final int join ) {
    this.width = width;
    this.cap = cap;
    this.join = join;
  }
}
