/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.lifecycle;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.AdapterFactoryRegistry;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.rwt.internal.lifecycle.IPhase;
import org.eclipse.rwt.internal.lifecycle.ISessionShutdownAdapter;
import org.eclipse.rwt.internal.lifecycle.IUIThreadHolder;
import org.eclipse.rwt.internal.lifecycle.LifeCycle;
import org.eclipse.rwt.internal.lifecycle.PhaseListenerRegistry;
import org.eclipse.rwt.internal.lifecycle.PrepareUIRoot;
import org.eclipse.rwt.internal.lifecycle.ProcessAction;
import org.eclipse.rwt.internal.lifecycle.ReadData;
import org.eclipse.rwt.internal.lifecycle.Render;
import org.eclipse.rwt.internal.lifecycle.Scope;
import org.eclipse.rwt.internal.lifecycle.UICallBackManager;
import org.eclipse.rwt.internal.lifecycle.UIThread;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.ServiceContext;
import org.eclipse.rwt.internal.service.ServletLog;
import org.eclipse.rwt.internal.service.SessionStoreImpl;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.lifecycle.PhaseEvent;
import org.eclipse.rwt.lifecycle.PhaseId;
import org.eclipse.rwt.lifecycle.PhaseListener;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RWTLifeCycle
extends LifeCycle {
    public static final String UI_THREAD;
    private static final Integer ZERO;
    private static final String ATTR_SESSION_DISPLAY;
    private static final String ATTR_REDRAW_CONTROLS;
    private static final String INITIALIZED;
    private static final String CURRENT_PHASE;
    private static final String PHASE_ORDER;
    private static final String UI_THREAD_THROWABLE;
    private static final String REQUEST_THREAD_RUNNABLE;
    private static final IPhase[] PHASES;
    private static final IPhase[] PHASE_ORDER_STARTUP;
    private static final IPhase[] PHASE_ORDER_SUBSEQUENT;
    Runnable uiRunnable;
    private final Set listeners = new HashSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        UI_THREAD = String.valueOf(clazz.getName()) + ".uiThread";
        ZERO = new Integer(0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATTR_SESSION_DISPLAY = String.valueOf(clazz2.getName()) + "#sessionDisplay";
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ATTR_REDRAW_CONTROLS = String.valueOf(clazz3.getName()) + "#redrawControls";
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        INITIALIZED = String.valueOf(clazz4.getName()) + "Initialized";
        Class<?> clazz5 = class$0;
        if (clazz5 == null) {
            try {
                clazz5 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CURRENT_PHASE = String.valueOf(clazz5.getName()) + ".currentPhase";
        Class<?> clazz6 = class$0;
        if (clazz6 == null) {
            try {
                clazz6 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PHASE_ORDER = String.valueOf(clazz6.getName()) + ".phaseOrder";
        Class<?> clazz7 = class$1;
        if (clazz7 == null) {
            try {
                clazz7 = class$1 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle$UIThreadController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        UI_THREAD_THROWABLE = String.valueOf(clazz7.getName()) + "#UIThreadThrowable";
        Class<?> clazz8 = class$0;
        if (clazz8 == null) {
            try {
                clazz8 = class$0 = Class.forName("org.eclipse.rwt.internal.lifecycle.RWTLifeCycle");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REQUEST_THREAD_RUNNABLE = String.valueOf(clazz8.getName()) + "#requestThreadRunnable";
        PHASES = new IPhase[]{new PrepareUIRoot(), new ReadData(), new ProcessAction(), new Render()};
        PHASE_ORDER_STARTUP = new IPhase[]{new IPhase.IInterruptible(){

            public PhaseId execute() throws IOException {
                return null;
            }

            public PhaseId getPhaseID() {
                return PhaseId.PREPARE_UI_ROOT;
            }
        }, new Render()};
        PHASE_ORDER_SUBSEQUENT = new IPhase[]{new IPhase(){

            public PhaseId execute() throws IOException {
                return null;
            }

            public PhaseId getPhaseID() {
                return PhaseId.PREPARE_UI_ROOT;
            }
        }, new ReadData(), new IPhase.IInterruptible(){

            public PhaseId execute() throws IOException {
                new ProcessAction().execute();
                return null;
            }

            public PhaseId getPhaseID() {
                return PhaseId.PROCESS_ACTION;
            }
        }, new Render()};
    }

    public RWTLifeCycle() {
        this.listeners.addAll(Arrays.asList(PhaseListenerRegistry.get()));
        this.uiRunnable = new UIThreadController();
    }

    public void execute() throws IOException {
        RWTLifeCycle.initialize();
        if (RWTLifeCycle.getEntryPoint() != null) {
            this.setPhaseOrder(PHASE_ORDER_STARTUP);
        } else {
            this.setPhaseOrder(PHASE_ORDER_SUBSEQUENT);
        }
        Runnable runnable = null;
        do {
            RWTLifeCycle.setRequestThreadRunnable(null);
            this.executeUIThread();
            runnable = RWTLifeCycle.getRequestThreadRunnable();
            if (runnable == null) continue;
            runnable.run();
        } while (runnable != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhaseListener(PhaseListener listener) {
        ParamCheck.notNull(listener, "listener");
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhaseListener(PhaseListener listener) {
        ParamCheck.notNull(listener, "listener");
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    public Scope getScope() {
        return Scope.APPLICATION;
    }

    public static void requestThreadExec(Runnable runnable) {
        RWTLifeCycle.setRequestThreadRunnable(runnable);
        RWTLifeCycle.switchThread();
    }

    private static void setRequestThreadRunnable(Runnable runnable) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        stateInfo.setAttribute(REQUEST_THREAD_RUNNABLE, runnable);
    }

    private static Runnable getRequestThreadRunnable() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return (Runnable)stateInfo.getAttribute(REQUEST_THREAD_RUNNABLE);
    }

    void continueLifeCycle() {
        int start = 0;
        IPhase[] phaseOrder = this.getPhaseOrder();
        if (phaseOrder != null) {
            Integer currentPhase = RWTLifeCycle.getCurrentPhase();
            if (currentPhase != null) {
                int phaseIndex = currentPhase;
                this.afterPhaseExecution(phaseOrder[phaseIndex].getPhaseID());
                start = currentPhase + 1;
            }
            boolean interrupted = false;
            int i = start;
            while (!interrupted && i < phaseOrder.length) {
                IPhase phase = phaseOrder[i];
                this.beforePhaseExecution(phase.getPhaseID());
                if (phase instanceof IPhase.IInterruptible) {
                    IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                    stateInfo.setAttribute(CURRENT_PHASE, new Integer(i));
                    interrupted = true;
                } else {
                    try {
                        phase.execute();
                    }
                    catch (Throwable e) {
                        throw new PhaseExecutionError(e);
                    }
                    this.afterPhaseExecution(phase.getPhaseID());
                }
                ++i;
            }
            if (!interrupted) {
                ContextProvider.getStateInfo().setAttribute(CURRENT_PHASE, null);
            }
        }
    }

    static int createUI() {
        String startup;
        int result = -1;
        if (ZERO.equals(RWTLifeCycle.getCurrentPhase()) && (startup = RWTLifeCycle.getEntryPoint()) != null) {
            TextSizeDetermination.readStartupProbes();
            result = EntryPointManager.createUI(startup);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeUIThread() throws IOException {
        ServiceContext context = ContextProvider.getContext();
        ISessionStore session = ContextProvider.getSession();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        if (uiThread == null) {
            uiThread = this.createUIThread();
            uiThread.setServiceContext(context);
            Object object = uiThread.getLock();
            synchronized (object) {
                uiThread.getThread().start();
                uiThread.switchThread();
            }
        } else {
            uiThread.setServiceContext(context);
            uiThread.switchThread();
        }
        if (!uiThread.getThread().isAlive()) {
            session.setAttribute(UI_THREAD, null);
        }
        RWTLifeCycle.handleUIThreadException();
    }

    private static void handleUIThreadException() throws IOException {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Throwable throwable = (Throwable)stateInfo.getAttribute(UI_THREAD_THROWABLE);
        if (throwable != null) {
            if (throwable instanceof PhaseExecutionError) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }

    public void sleep() {
        this.continueLifeCycle();
        IUIThreadHolder uiThread = RWTLifeCycle.getUIThreadHolder();
        UICallBackManager.getInstance().notifyUIThreadEnd();
        uiThread.switchThread();
        uiThread.updateServiceContext();
        UICallBackManager.getInstance().notifyUIThreadStart();
        this.continueLifeCycle();
    }

    private IUIThreadHolder createUIThread() {
        ISessionStore session = ContextProvider.getSession();
        UIThread result = new UIThread(this.uiRunnable);
        result.getThread().setDaemon(true);
        result.getThread().setName("UIThread [" + session.getId() + "]");
        session.setAttribute(UI_THREAD, result);
        RWTLifeCycle.setShutdownAdapter(result);
        return result;
    }

    private static void switchThread() {
        ISessionStore session = ContextProvider.getSession();
        IUIThreadHolder uiThreadHolder = (IUIThreadHolder)session.getAttribute(UI_THREAD);
        uiThreadHolder.switchThread();
    }

    private static Integer getCurrentPhase() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return (Integer)stateInfo.getAttribute(CURRENT_PHASE);
    }

    private static String getEntryPoint() {
        String result = null;
        HttpServletRequest request = ContextProvider.getRequest();
        String startup = request.getParameter("startup");
        if (startup != null) {
            result = startup;
        } else if (RWTLifeCycle.getSessionDisplay() == null) {
            result = "default";
        }
        return result;
    }

    private static void setShutdownAdapter(ISessionShutdownAdapter adapter) {
        ISessionStore sessionStore = ContextProvider.getSession();
        SessionStoreImpl sessionStoreImpl = (SessionStoreImpl)sessionStore;
        sessionStoreImpl.setShutdownAdapter(adapter);
    }

    private void beforePhaseExecution(PhaseId current) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        PhaseEvent evt = new PhaseEvent(this, current);
        int i = 0;
        while (i < phaseListeners.length) {
            PhaseId listenerId = phaseListeners[i].getPhaseId();
            if (RWTLifeCycle.mustNotify(current, listenerId)) {
                try {
                    phaseListeners[i].beforePhase(evt);
                }
                catch (Throwable thr) {
                    String text = "Could not execute PhaseListener before phase ''{0}''.";
                    String msg = MessageFormat.format(text, current);
                    ServletLog.log(msg, thr);
                }
            }
            ++i;
        }
    }

    void afterPhaseExecution(PhaseId current) {
        PhaseListener[] phaseListeners = this.getPhaseListeners();
        PhaseEvent evt = new PhaseEvent(this, current);
        int i = 0;
        while (i < phaseListeners.length) {
            PhaseId listenerId = phaseListeners[i].getPhaseId();
            if (RWTLifeCycle.mustNotify(current, listenerId)) {
                try {
                    phaseListeners[i].afterPhase(evt);
                }
                catch (Throwable thr) {
                    String text = "Could not execute PhaseListener after phase ''{0}''.";
                    String msg = MessageFormat.format(text, current);
                    ServletLog.log(msg, thr);
                }
            }
            ++i;
        }
        if (current == PhaseId.PROCESS_ACTION) {
            RWTLifeCycle.doRedrawFake();
        }
    }

    private static void initialize() {
        ISessionStore session = ContextProvider.getSession();
        if (session.getAttribute(INITIALIZED) == null) {
            AdapterFactoryRegistry.register();
            session.setAttribute(INITIALIZED, Boolean.TRUE);
        }
    }

    private static boolean mustNotify(PhaseId currentId, PhaseId listenerId) {
        return listenerId == PhaseId.ANY || listenerId == PHASES[currentId.getOrdinal() - 1].getPhaseID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PhaseListener[] getPhaseListeners() {
        Set set = this.listeners;
        synchronized (set) {
            PhaseListener[] result = new PhaseListener[this.listeners.size()];
            this.listeners.toArray(result);
            return result;
        }
    }

    public static void fakeRedraw(Control control, boolean redraw) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HashSet<Control> set = (HashSet<Control>)stateInfo.getAttribute(ATTR_REDRAW_CONTROLS);
        if (set == null) {
            set = new HashSet<Control>();
            stateInfo.setAttribute(ATTR_REDRAW_CONTROLS, set);
        }
        if (redraw) {
            set.add(control);
        } else {
            set.remove(control);
        }
    }

    public static boolean needsFakeRedraw(Control control) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Set set = (Set)stateInfo.getAttribute(ATTR_REDRAW_CONTROLS);
        return set != null && set.contains(control);
    }

    private static void doRedrawFake() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Set set = (Set)stateInfo.getAttribute(ATTR_REDRAW_CONTROLS);
        if (set != null) {
            Object[] controls = set.toArray();
            int i = 0;
            while (i < controls.length) {
                Control control = (Control)controls[i];
                WidgetUtil.getLCA(control).doRedrawFake(control);
                ++i;
            }
        }
    }

    public void setPhaseOrder(IPhase[] phaseOrder) {
        IServiceStateInfo stateInfo = ContextProvider.getContext().getStateInfo();
        stateInfo.setAttribute(PHASE_ORDER, phaseOrder);
    }

    IPhase[] getPhaseOrder() {
        IServiceStateInfo stateInfo = ContextProvider.getContext().getStateInfo();
        return (IPhase[])stateInfo.getAttribute(PHASE_ORDER);
    }

    public static IUIThreadHolder getUIThreadHolder() {
        ISessionStore session = ContextProvider.getSession();
        return (IUIThreadHolder)session.getAttribute(UI_THREAD);
    }

    public static void setSessionDisplay(Display display) {
        ContextProvider.getSession().setAttribute(ATTR_SESSION_DISPLAY, display);
    }

    public static Display getSessionDisplay() {
        Display result = null;
        if (ContextProvider.hasContext()) {
            ISessionStore sessionStore = ContextProvider.getSession();
            result = (Display)sessionStore.getAttribute(ATTR_SESSION_DISPLAY);
        }
        return result;
    }

    private static final class PhaseExecutionError
    extends ThreadDeath {
        private static final long serialVersionUID = 1L;

        public PhaseExecutionError(Throwable cause) {
            this.initCause(cause);
        }
    }

    private final class UIThreadController
    implements Runnable {
        private UIThreadController() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            IUIThreadHolder uiThread = (IUIThreadHolder)((Object)Thread.currentThread());
            try {
                try {
                    Object object = uiThread.getLock();
                    synchronized (object) {
                        uiThread.updateServiceContext();
                        UICallBackManager.getInstance().notifyUIThreadStart();
                        RWTLifeCycle.this.continueLifeCycle();
                        RWTLifeCycle.createUI();
                        RWTLifeCycle.this.continueLifeCycle();
                        UICallBackManager.getInstance().notifyUIThreadEnd();
                    }
                }
                catch (UIThread.UIThreadTerminatedError thr) {
                    throw thr;
                }
                catch (Throwable thr) {
                    IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
                    stateInfo.setAttribute(UI_THREAD_THROWABLE, thr);
                }
                uiThread.switchThread();
            }
            catch (UIThread.UIThreadTerminatedError uIThreadTerminatedError) {
                ((ISessionShutdownAdapter)((Object)uiThread)).processShutdown();
            }
        }
    }
}

