/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.internal.ConfigurationReader;
import org.eclipse.rwt.internal.IConfiguration;
import org.eclipse.rwt.internal.IInitialization;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.service.IServiceHandler;

public abstract class AbstractServiceHandler
implements IServiceHandler {
    private static final String ACCEPT_ENCODING = "Accept-Encoding";
    private static final String CONTENT_ENCODING = "Content-Encoding";
    private static final String ENCODING_GZIP = "gzip";

    static boolean isAcceptEncoding() {
        String encodings = AbstractServiceHandler.getRequest().getHeader(ACCEPT_ENCODING);
        return encodings != null && encodings.indexOf(ENCODING_GZIP) != -1;
    }

    static PrintWriter getOutputWriter() throws IOException {
        OutputStreamWriter utf8Writer;
        ServletOutputStream out = AbstractServiceHandler.getResponse().getOutputStream();
        if (AbstractServiceHandler.isAcceptEncoding() && AbstractServiceHandler.getInitProps().isCompression()) {
            GZIPOutputStream zipStream = new GZIPOutputStream((OutputStream)out);
            utf8Writer = new OutputStreamWriter((OutputStream)zipStream, "UTF-8");
            AbstractServiceHandler.getResponse().setHeader(CONTENT_ENCODING, ENCODING_GZIP);
        } else {
            utf8Writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
        }
        return new PrintWriter((Writer)utf8Writer, false);
    }

    static IInitialization getInitProps() {
        IConfiguration configuration = ConfigurationReader.getConfiguration();
        return configuration.getInitialization();
    }

    protected static HttpServletRequest getRequest() {
        return ContextProvider.getRequest();
    }

    protected static HttpServletResponse getResponse() {
        return ContextProvider.getResponse();
    }
}

