/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.RWTMessages;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.DisplayUtil;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.resources.ResourceManager;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.StartupPage;
import org.eclipse.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.resources.IResourceManager;
import org.eclipse.swt.internal.graphics.TextSizeDetermination;

public final class RWTStartupPageConfigurer
implements StartupPage.IStartupPageConfigurer {
    private static final String PACKAGE_NAME;
    private static final String FOLDER;
    private static final String INDEX_TEMPLATE;
    private static int probeCount;
    private static long lastModified;
    private static StartupPageTemplateHolder template;
    private static final List registeredBrandings;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.RWTStartupPageConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PACKAGE_NAME = clazz.getPackage().getName();
        FOLDER = PACKAGE_NAME.replace('.', '/');
        INDEX_TEMPLATE = String.valueOf(FOLDER) + "/rwt-index.html";
        lastModified = System.currentTimeMillis();
        registeredBrandings = new ArrayList();
    }

    public StartupPageTemplateHolder getTemplate() throws IOException {
        RWTStartupPageConfigurer.readContent();
        template.reset();
        template.replace(StartupPageTemplateHolder.VAR_LIBRARIES, RWTStartupPageConfigurer.getLibraries());
        template.replace(StartupPageTemplateHolder.VAR_APPSCRIPT, RWTStartupPageConfigurer.getAppScript());
        RWTStartupPageConfigurer.applyBranding();
        return template;
    }

    public synchronized boolean isModifiedSince() {
        boolean result;
        int currentProbeCount = TextSizeDetermination.getProbeCount();
        if (probeCount != currentProbeCount) {
            lastModified = System.currentTimeMillis();
            probeCount = currentProbeCount;
        }
        HttpServletRequest request = ContextProvider.getRequest();
        HttpServletResponse response = ContextProvider.getResponse();
        response.addHeader("Cache-Control", "max-age=0, no-cache, must-revalidate, no-store");
        long dateHeader = request.getDateHeader("If-Modified-Since");
        if (dateHeader + 1000L < lastModified) {
            result = true;
            response.addDateHeader("Last-Modified", lastModified);
        } else {
            result = false;
            response.setStatus(304);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void readContent() throws IOException {
        if (template != null) return;
        InputStream stream = RWTStartupPageConfigurer.loadTemplateFile();
        InputStreamReader isr = new InputStreamReader(stream, "ISO-8859-1");
        BufferedReader reader = new BufferedReader(isr);
        try {
            String line = reader.readLine();
            StringBuffer buffer = new StringBuffer();
            while (true) {
                block4: {
                    if (line != null) break block4;
                    template = new StartupPageTemplateHolder(buffer.toString());
                    break;
                }
                buffer.append(line);
                buffer.append("\n");
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            reader.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        reader.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static InputStream loadTemplateFile() throws IOException {
        InputStream result = null;
        IResourceManager manager = ResourceManager.getInstance();
        ClassLoader buffer = manager.getContextLoader();
        Class<?> clazz = class$0;
        if (clazz == null) {
            Class<?> clazz2;
            try {
                clazz2 = Class.forName("org.eclipse.rwt.internal.service.RWTStartupPageConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            clazz = class$0 = clazz2;
        }
        manager.setContextLoader(clazz.getClassLoader());
        try {
            result = manager.getResourceAsStream(INDEX_TEMPLATE);
            if (result == null) {
                String text = "Failed to load Browser Survey HTML Page. Resource {0} could not be found.";
                Object[] param = new Object[]{INDEX_TEMPLATE};
                String msg = MessageFormat.format(text, param);
                throw new IOException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            manager.setContextLoader(buffer);
            throw throwable;
        }
        {
            Object var6_8 = null;
            manager.setContextLoader(buffer);
            return result;
        }
    }

    private static String getAppScript() throws IOException {
        String string;
        RWTStartupPageConfigurer.fakeWriter();
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter writer = stateInfo.getResponseWriter();
        writer.startElement("script", null);
        writer.writeText("safd", null);
        writer.clearBody();
        try {
            DisplayUtil.writeAppScript("w1");
            string = RWTStartupPageConfigurer.getContent(writer);
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            RWTStartupPageConfigurer.restoreWriter();
            throw throwable;
        }
        RWTStartupPageConfigurer.restoreWriter();
        return string;
    }

    private static void fakeWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        HtmlResponseWriter original = stateInfo.getResponseWriter();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.RWTStartupPageConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String key = clazz.getName();
        stateInfo.setAttribute(key, original);
        HtmlResponseWriter fake = new HtmlResponseWriter();
        stateInfo.setResponseWriter(fake);
    }

    private static void restoreWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.service.RWTStartupPageConfigurer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String key = clazz.getName();
        HtmlResponseWriter writer = (HtmlResponseWriter)stateInfo.getAttribute(key);
        stateInfo.setResponseWriter(writer);
    }

    private static String getLibraries() throws IOException {
        String string;
        RWTStartupPageConfigurer.fakeWriter();
        try {
            DisplayUtil.writeLibraries();
            string = RWTStartupPageConfigurer.getContent(ContextProvider.getStateInfo().getResponseWriter());
            Object var0_1 = null;
        }
        catch (Throwable throwable) {
            Object var0_2 = null;
            RWTStartupPageConfigurer.restoreWriter();
            throw throwable;
        }
        RWTStartupPageConfigurer.restoreWriter();
        return string;
    }

    private static String getContent(HtmlResponseWriter writer) {
        StringBuffer msg = new StringBuffer();
        int i = 0;
        while (i < writer.getBodySize()) {
            msg.append(writer.getBodyToken(i));
            ++i;
        }
        return msg.toString();
    }

    private static void applyBranding() throws IOException {
        AbstractBranding branding = BrandingUtil.findBranding();
        RWTStartupPageConfigurer.registerBrandingResources(branding);
        HttpServletRequest request = ContextProvider.getRequest();
        String entryPoint = request.getParameter("startup");
        if (entryPoint == null && ((entryPoint = branding.getDefaultEntryPoint()) == null || "".equals(entryPoint))) {
            entryPoint = "default";
        }
        if (branding.getThemeId() != null) {
            ThemeUtil.setCurrentThemeId(branding.getThemeId());
        }
        BrandingUtil.replacePlaceholder(template, StartupPageTemplateHolder.VAR_BODY, branding.getBody());
        BrandingUtil.replacePlaceholder(template, StartupPageTemplateHolder.VAR_TITLE, branding.getTitle());
        String headers = BrandingUtil.headerMarkup(branding);
        BrandingUtil.replacePlaceholder(template, StartupPageTemplateHolder.VAR_HEADERS, headers);
        String encodedEntryPoint = EncodingUtil.encodeHTMLEntities(entryPoint);
        BrandingUtil.replacePlaceholder(template, StartupPageTemplateHolder.VAR_STARTUP, encodedEntryPoint);
        String noScriptWarning = RWTMessages.getMessage("RWT_NoScriptWarning");
        BrandingUtil.replacePlaceholder(template, StartupPageTemplateHolder.VAR_NO_SCRIPT_MESSAGE, noScriptWarning);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerBrandingResources(AbstractBranding branding) throws IOException {
        List list = registeredBrandings;
        synchronized (list) {
            if (!registeredBrandings.contains(branding)) {
                branding.registerResources();
                registeredBrandings.add(branding);
            }
        }
    }
}

