/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.ITextSizeStorage;

public final class DefaultTextSizeStorage
implements ITextSizeStorage {
    public static final int MIN_STORE_SIZE = 1000;
    public static final int DEFAULT_STORE_SIZE = 10000;
    static final String COMMENT = "RAP DefaultFontSizeStorage";
    static final String PREFIX_FONT_KEY = "FONT_";
    private final Object lock = new Object();
    private final Set fontDatas;
    private final Map data = new HashMap();
    private int storeSize;
    private int clearRange;
    private int clock;

    public DefaultTextSizeStorage() {
        this.fontDatas = new HashSet();
        this.setStoreSize(10000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FontData[] getFontList() {
        FontData[] result;
        Object object = this.lock;
        synchronized (object) {
            result = new FontData[this.fontDatas.size()];
            this.fontDatas.toArray(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeFont(FontData fontData) {
        Object object = this.lock;
        synchronized (object) {
            this.fontDatas.add(fontData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point lookupTextSize(Integer key) {
        Point result = null;
        Object object = this.lock;
        synchronized (object) {
            Entry entry = (Entry)this.data.get(key);
            if (entry != null) {
                entry.timeStamp = this.clock++;
                result = entry.point;
            }
        }
        result = DefaultTextSizeStorage.defensiveCopy(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeTextSize(Integer key, Point size) {
        Point clone = DefaultTextSizeStorage.defensiveCopy(size);
        Entry entry = new Entry();
        entry.point = clone;
        entry.timeStamp = this.clock++;
        Object object = this.lock;
        synchronized (object) {
            this.data.put(key, entry);
            this.handleOverFlow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(OutputStream stream) throws IOException {
        FontData[] fontDataList;
        Properties properties = new Properties();
        Object object = this.lock;
        synchronized (object) {
            fontDataList = this.getFontList();
            Iterator iterator = this.data.keySet().iterator();
            while (iterator.hasNext()) {
                Integer key = (Integer)iterator.next();
                Point size = ((Entry)this.data.get(key)).point;
                StringBuffer value = new StringBuffer();
                value.append(size.x);
                value.append(",");
                value.append(size.y);
                properties.setProperty(key.toString(), value.toString());
            }
        }
        int i = 0;
        while (i < fontDataList.length) {
            StringBuffer key = new StringBuffer();
            key.append(PREFIX_FONT_KEY);
            key.append(i);
            String value = fontDataList[i].toString();
            properties.setProperty(key.toString(), value);
            ++i;
        }
        properties.store(stream, COMMENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(InputStream stream) throws IOException {
        Properties properties = new Properties();
        properties.load(stream);
        Object object = this.lock;
        synchronized (object) {
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = properties.getProperty(key);
                if (key.startsWith(PREFIX_FONT_KEY)) {
                    FontData fontData = new FontData(value);
                    this.storeFont(fontData);
                    continue;
                }
                this.storeTextSize(new Integer(key), DefaultTextSizeStorage.parsePoint(value));
            }
        }
    }

    public void setStoreSize(int storeSize) {
        if (storeSize < 1000) {
            String txt = "Store size must be >= {0}.";
            Object[] param = new Object[]{new Integer(1000)};
            String msg = MessageFormat.format(txt, param);
            throw new IllegalArgumentException(msg);
        }
        BigDecimal ten = new BigDecimal(10.0);
        BigDecimal bdStoreSize = new BigDecimal((double)storeSize);
        int rounding = 4;
        this.clearRange = bdStoreSize.divide(ten, 0, rounding).intValue();
        this.storeSize = storeSize;
    }

    public int getStoreSize() {
        return this.storeSize;
    }

    private void handleOverFlow() {
        if (this.data.size() >= this.storeSize) {
            Entry[] entries = new Entry[this.data.size()];
            this.data.values().toArray(entries);
            Arrays.sort(entries, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    Entry e1 = (Entry)obj1;
                    Entry e2 = (Entry)obj2;
                    int result = 0;
                    if (e1.timeStamp > e2.timeStamp) {
                        result = 1;
                    } else if (e1.timeStamp < e2.timeStamp) {
                        result = -1;
                    }
                    return result;
                }
            });
            int i = 0;
            while (i < this.clearRange) {
                this.data.values().remove(entries[i]);
                ++i;
            }
        }
    }

    private static Point parsePoint(String value) {
        String[] values = value.split(",");
        int x = Integer.valueOf(values[0]);
        int y = Integer.valueOf(values[1]);
        return new Point(x, y);
    }

    private static Point defensiveCopy(Point point) {
        Point result = null;
        if (point != null) {
            result = new Point(point.x, point.y);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFontList() {
        Set set = this.fontDatas;
        synchronized (set) {
            this.fontDatas.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetStringSizes() {
        Map map = this.data;
        synchronized (map) {
            this.data.clear();
        }
    }

    private static class Entry {
        private Point point;
        private long timeStamp;

        private Entry() {
        }
    }
}

