/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rwt.internal.lifecycle.DisposedWidgets;
import org.eclipse.rwt.internal.lifecycle.IRenderRunnable;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.swt.internal.widgets.IdGenerator;
import org.eclipse.swt.widgets.Widget;

public final class WidgetAdapter
implements IWidgetAdapter {
    private final String id;
    private boolean initialized;
    private final Map preservedValues;
    private String jsParent;
    private IRenderRunnable renderRunnable;
    private String variant;

    public WidgetAdapter() {
        this(IdGenerator.getInstance().newId());
    }

    public WidgetAdapter(String id) {
        this.id = id;
        this.preservedValues = new HashMap();
    }

    public String getId() {
        return this.id;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public void preserve(String propertyName, Object value) {
        this.preservedValues.put(propertyName, value);
    }

    public Object getPreserved(String propertyName) {
        return this.preservedValues.get(propertyName);
    }

    public void clearPreserved() {
        this.preservedValues.clear();
    }

    public String getJSParent() {
        return this.jsParent;
    }

    public void setJSParent(String jsParent) {
        this.jsParent = jsParent;
    }

    public void setRenderRunnable(IRenderRunnable renderRunnable) {
        if (this.renderRunnable != null) {
            throw new IllegalStateException("A renderRunnable was already set.");
        }
        this.renderRunnable = renderRunnable;
    }

    public IRenderRunnable getRenderRunnable() {
        return this.renderRunnable;
    }

    public void clearRenderRunnable() {
        this.renderRunnable = null;
    }

    public String getCachedVariant() {
        return this.variant;
    }

    public void setCachedVariant(String variant) {
        this.variant = variant;
    }

    public void markDisposed(Widget widget) {
        if (this.initialized) {
            DisposedWidgets.add(widget);
        }
    }
}

